function plot_tensor_components(md,options_structure,width,i,tensor,type,plot_options);
%PLOT_TENSOR_COMPONENT - plot component of a tensor
%
%   Usage:
%      plot_tensor_components(md,options_structure,width,i,tensor,type,plot_option);
%
%   See also: PLOTMODEL

	%Compute the indexes of the components plots
	upperplots=fix((i-1)/width);
	if upperplots==0, leftplots=i-1; else leftplots=i-width*upperplots-1; end
	if strcmpi(md.type,'2d')%3 components -> 3 indexes
		index1=4*width*upperplots+2*leftplots+1;
		index2=index1+1;
		index3=index1+width*2;
	elseif strcmpi(md.type,'3d')%6 components -> 6 indexes
		index1=3*3*width*upperplots+3*leftplots+1;
		index2=index1+1;
		index3=index1+2;
		index4=index1+width*3;
		index5=index4+1;
		index6=index4+2;
	end

	%smoothing?
	if strcmpi(options_structure.smooth,'yes') & length(tensor.xx)==md.numberofelements
		tensor.xx=elementstogrids(md,tensor.xx);
		tensor.yy=elementstogrids(md,tensor.yy);
		tensor.xy=elementstogrids(md,tensor.xy);
		if  strcmpi(md.type,'3d')
		tensor.zz=elementstogrids(md,tensor.zz);
		tensor.yz=elementstogrids(md,tensor.yz);
		tensor.xz=elementstogrids(md,tensor.xz);
		end
	end

			
	%layer projection? 
	if ~isnan(options_structure.layer) & options_structure.layer>=1,
		tensor.xx=project2d(md,tensor.xx,options_structure.layer); %project onto 2d mesh
		tensor.yy=project2d(md,tensor.yy,options_structure.layer); %project onto 2d mesh
		tensor.zz=project2d(md,tensor.zz,options_structure.layer); %project onto 2d mesh
		tensor.xy=project2d(md,tensor.xy,options_structure.layer); %project onto 2d mesh
		tensor.xz=project2d(md,tensor.xz,options_structure.layer); %project onto 2d mesh
		tensor.yz=project2d(md,tensor.yz,options_structure.layer); %project onto 2d mesh
		%we modify the mesh temporarily to a 2d mesh from which the 3d mesh was extruded. 
		md.x=md.x2d;
		md.y=md.y2d;
		md.z=md.z2d;
		md.elements=md.elements2d;
		md.elements_type=md.elements_type2d;
	end

	%units
	if ~isnan(options_structure.unitmultiplier),
		md.x=md.x*options_structure.unitmultiplier;
		md.y=md.y*options_structure.unitmultiplier;
		md.z=md.z*options_structure.unitmultiplier;
	end

	if length(tensor.xx)==length(md.elements),
		
		if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
			tensor.xx(find(md.elementoniceshelf))=NaN;
			tensor.yy(find(md.elementoniceshelf))=NaN;
			tensor.xy(find(md.elementoniceshelf))=NaN;
			if  strcmpi(md.type,'3d')
				tensor.zz(find(md.elementoniceshelf))=NaN;
				tensor.yz(find(md.elementoniceshelf))=NaN;
				tensor.xz(find(md.elementoniceshelf))=NaN;
			end
		end
		if ~isnan(options_structure.noicesheet) & options_structure.noicesheet,
			tensor.xx(find(~md.elementoniceshelf))=NaN;
			tensor.yy(find(~md.elementoniceshelf))=NaN;
			tensor.xy(find(~md.elementoniceshelf))=NaN;
			if  strcmpi(md.type,'3d')
				tensor.zz(find(~md.elementoniceshelf))=NaN;
				tensor.yz(find(~md.elementoniceshelf))=NaN;
				tensor.xz(find(~md.elementoniceshelf))=NaN;
			end
		end

		if (strcmpi(md.type,'2d')),
			A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

			subplot(2*width,2*width,index1)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.xx,'FaceColor','flat','EdgeColor','black');
			Apply_options_tensor(options_structure,type,'xx')

			subplot(2*width,2*width,index2)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.yy,'FaceColor','flat','EdgeColor','black');
			Apply_options_tensor(options_structure,type,'yy')

			subplot(2*width,2*width,index3)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.xy,'FaceColor','flat','EdgeColor','black');
			Apply_options_tensor(options_structure,type,'xy')
		else
			if options_structure.layer>=1,
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

				subplot(3*width,3*width,index1)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData',tensor.xx ,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'xx')

				subplot(3*width,3*width,index2)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData',tensor.yy ,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'yy')

				subplot(3*width,3*width,index3)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData',tensor.zz ,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'zz')

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData',tensor.xy ,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'xy')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData',tensor.xz ,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'xz')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData',tensor.yz ,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'yz')

			else
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); D=md.elements(:,4); E=md.elements(:,5); F=md.elements(:,6);

				subplot(3*width,3*width,index1)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.xx,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.xx,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.xx,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.xx,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.xx,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'xx')

				subplot(3*width,3*width,index2)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.yy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.yy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.yy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.yy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.yy,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'yy')

				subplot(3*width,3*width,index3)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.zz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.zz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.zz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.zz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.zz,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'zz')

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.xy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.xy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.xy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.xy,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.xy,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'xy')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.xz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.xz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.xz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.xz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.xz,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'xz')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.yz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.yz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.yz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.yz,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.yz,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'yz')
			end
		end
	elseif length(tensor.xx)==md.numberofgrids |  length(tensor.xx)==md.numberofgrids2d,
		if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
			pos=find(md.gridoniceshelf);
			tensor.xx(pos)=NaN;
			tensor.yy(pos)=NaN;
			tensor.xy(pos)=NaN;
			if strcmpi(md.type,'3d')
				tensor.zz(pos)=NaN;
				tensor.xz(pos)=NaN;
				tensor.yz(pos)=NaN;
			end
		end
		if ~isnan(options_structure.noiceshelf) & options_structure.noicesheet,
			pos=find(md.gridonicesheet);
			tensor.xx(pos)=NaN;
			tensor.yy(pos)=NaN;
			tensor.xy(pos)=NaN;
			if strcmpi(md.type,'3d')
				tensor.zz(pos)=NaN;
				tensor.xz(pos)=NaN;
				tensor.yz(pos)=NaN;
			end
		end

		if strcmpi(md.type,'2d'),
			A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

			subplot(2*width,2*width,index1)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.xx ,'FaceColor','flat','EdgeColor','none');
			Apply_options_tensor(options_structure,type,'xx')

			subplot(2*width,2*width,index2)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.yy ,'FaceColor','flat','EdgeColor','none');
			Apply_options_tensor(options_structure,type,'yy')

			subplot(2*width,2*width,index3)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.xy ,'FaceColor','flat','EdgeColor','none');
			Apply_options_tensor(options_structure,type,'xy')

		else
			if options_structure.layer>=1,
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 
				subplot(3*width,3*width,index1)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.xx ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'xx')

				subplot(3*width,3*width,index2)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.yy ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'yy')

				subplot(3*width,3*width,index3)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.zz ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'zz')

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.xy ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'xy')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.xz ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'xz')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.yz ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'yz')

			else
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); D=md.elements(:,4); E=md.elements(:,5); F=md.elements(:,6);

				subplot(3*width,3*width,index1)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xx,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xx,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xx,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xx,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xx,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'xx')

				subplot(3*width,3*width,index2)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yy,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'yy')

				subplot(3*width,3*width,index3)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.zz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.zz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.zz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.zz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.zz,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'zz')

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xy,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xy,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'xy')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.xz,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'xz')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yz,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.yz,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'yz')
			end
		end
	end
end

function Apply_options_tensor(options_structure,type,component)
%apply options
	if isnan(options_structure.title)
		if ismember('_',type) %user plotet stress_tensor
			strings=strsplit(type,'_');
			string=strings{1};
		else %default plot: user requested stress
			string=type;
		end
		options_structure.title=[upper(string(1)) string(2:end) ' ' component];
	end 
	applyoptions(md,[],options_structure);
end
