function derivatives=GetParameterDerivativeValue(pentaelem,grid_values,xyz_list,gauss_coord),
%GETPARAMETERDERIVATIVEVALUE - return the derivative value of a parameter at a specified point
%
%   From grid values of parameter, return parameter derivative value at gaussian point specified by gauss_coord:
%   For example, if p is the parameter,
%   dp/dx=p1*dh1/dx+p2*dh2/dx+p3*dh3/dx+p4*dh4/dx+p5*dh5/dx+p5*dh5/dx
%   dp/dy=p1*dh1/dy+p2*dh2/dy+p3*dh3/dy+p4*dh4/dy+p5*dh5/dy+p5*dh5/dy
%   dp/dz=p1*dh1/dz+p2*dh2/dz+p3*dh3/dz+p4*dh4/dz+p5*dh5/dz+p5*dh5/dz
%
%   Usage:
%      derivatives=GetParameterDerivativeValue(pentaelem,grid_values,xyz_list,gauss_coord)
%
%   See also GETPARAMETERVALUE

derivatives=zeros(3,1);

%Get dh1dh6 in basic coordinate system:
dh1dh6=GetNodalFunctionsDerivativesBasic(pentaelem,xyz_list, gauss_coord);
derivatives(1)=sum(grid_values'.*dh1dh6(1,:));
derivatives(2)=sum(grid_values'.*dh1dh6(2,:));
derivatives(3)=sum(grid_values'.*dh1dh6(3,:));
