#Server Makefile configuration.
   
ifeq ($(cluster),1)

	#Add some strict compiling 
	CFLAGS  += -Werror-implicit-function-declaration

	#Undefine matlab if already defined. 
	CFLAGS+= -UMATLAB

	ifdef MPILAUNCH
		mpilaunch = $(MPILAUNCH)
	else
		mpilaunch= mpi
	endif

	ifeq ($(mpilaunch),bsub)
		CFLAGS   += -D_BSUB_
	endif
	ifeq ($(mpilaunch),mpi)
		CFLAGS   += -D_MPI_
	endif

	#Server flags
		CFLAGS += -fno-strict-aliasing -funroll-loops -g3 -D_SERVER_ -O3
		#CFLAGS += -Wall

	#Cluster flags: 
	MPIROOT=/proj/ice/Libraries/linux/mpich2-gnu
	CC=$(MPIROOT)/bin/mpicc

	CFLAGS +=  -D_CLUSTER_ -I$(MPIROOT)/include

	COMPUTLIBS += -L$(MPIROOT) -lfmpich -lmpich  -lmpichcxx 	

	#PETSC Definitions: 
	ifeq (petsc,$(findstring petsc,$(computlib)))
		#LAPACK and BLAS definitions needed for MPI use of Petsc.
		FBLASLAPACKDIR=$(PETSCROOT)/externalpackages/fblaslapack/$(PETSCARCH)
		COMPUTLIBS += -L$(FBLASLAPACKDIR) -lflapack -lfblas 
	endif

	#SLEPC Definitions
	ifeq (slepc,$(findstring slepc,$(computlib)))
		SLEPCDIR=/proj/ice/Libraries/linux/slepc-2.3.3
		
		CFLAGS += -I$(SLEPCDIR)/include

		#COMPUTLIBS += -L$(SLEPCDIR)/lib/$(PETSCARCH) -lslepc
	endif

	#SCALAPACK Definitions
	ifeq (scalapack,$(findstring scalapack,$(computlib)))
		SCALAPACKDIR=/proj/ice/Libraries/linux/SCALAPACK/mpich2-gnu
		#We need BLACS to work with Scalapack
		BLACSDIR=/proj/ice/Libraries/linux/BLACS/LIB/mpich2-gnu
		
		COMPUTLIBS += -L$(SCALAPACKDIR) -lscalapack \
					 -L$(BLACSDIR)  -lblacsF77init_MPI-LINUX-0 -lblacs_MPI-LINUX-0 -lblacsCinit_MPI-LINUX-0
	endif

	#PLAPACK Definitions.
	ifeq (plapack,$(findstring plapack,$(computlib)))
		PLAPACKDIR=$(PETSCROOT)/externalpackages/PLAPACKR32
		#We need also Petsc Plapack prototypes found in  $PETSCROOT)/src/mat/impls/dense/mpi/plapack/PLA_prototypes.h

		CFLAGS += -I$(PLAPACKDIR)/INCLUDE -I$(PETSCROOT)/src/mat/impls/dense/mpi/plapack/

		COMPUTLIBS += -L$(PLAPACKDIR)/$(PETSCARCH) -lPLAPACK
	endif

	#Metis definitions
	METISDIR=/proj/ice/Libraries/linux/metis-4.0/
	CFLAGS += -I$(METISDIR)/Lib
	COMPUTLIBS += -L$(METISDIR) -lmetis

	#Extra definitions
	COMPUTLIBS += -lnsl -lrt -L/usr/X11R6/lib -lX11 -lg2c -lpetsc

	
	COMPUTLIBS += -L/usr/local/g95/lib/gcc-lib/i686-pc-linux-gnu/4.0.3/ -lf95
	#Fortran defintions in case using different compiler (absoft)
	#FORTRAN_DIR=/opt/absoft/
	#FORTRAN_LIBS= -lutil -lpthread -lfio -lU77 -lV77 -lf90math -lf77math -lf95math 
	   
endif 

ifeq ($(batch),1)
#Add _BATCH_ flag to compilation
CFLAGS+= -D_BATCH_
endif
