/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

/* automatically generated by maint/genstates */

#include "mpiimpl.h"

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI

#ifdef HAVE_TIMING

#if (USE_LOGGING == MPID_LOGGING_RLOG)

#include <math.h>

/* utility funcions */
#ifndef RGB
#define RGB(r,g,b)      ((unsigned long)(((unsigned char)(r)|((unsigned short)((unsigned char)(g))<<8))|(((unsigned long)(unsigned char)(b))<<16)))
#endif

static unsigned long getColorRGB(double fraction, double intensity, unsigned char *r, unsigned char *g, unsigned char *b)
{
    double red, green, blue;
    double dtemp;

    fraction = fabs(modf(fraction, &dtemp));
    
    if (intensity > 2.0)
	intensity = 2.0;
    if (intensity < 0.0)
	intensity = 0.0;

    dtemp = 1.0/6.0;

    if (fraction < 1.0/6.0)
    {
	red = 1.0;
	green = fraction / dtemp;
	blue = 0.0;
    }
    else
    {
	if (fraction < 1.0/3.0)
	{
	    red = 1.0 - ((fraction - dtemp) / dtemp);
	    green = 1.0;
	    blue = 0.0;
	}
	else
	{
	    if (fraction < 0.5)
	    {
		red = 0.0;
		green = 1.0;
		blue = (fraction - (dtemp*2.0)) / dtemp;
	    }
	    else
	    {
		if (fraction < 2.0/3.0)
		{
		    red = 0.0;
		    green = 1.0 - ((fraction - (dtemp*3.0)) / dtemp);
		    blue = 1.0;
		}
		else
		{
		    if (fraction < 5.0/6.0)
		    {
			red = (fraction - (dtemp*4.0)) / dtemp;
			green = 0.0;
			blue = 1.0;
		    }
		    else
		    {
			red = 1.0;
			green = 0.0;
			blue = 1.0 - ((fraction - (dtemp*5.0)) / dtemp);
		    }
		}
	    }
	}
    }

    if (intensity > 1)
    {
	intensity = intensity - 1.0;
	red = red + ((1.0 - red) * intensity);
	green = green + ((1.0 - green) * intensity);
	blue = blue + ((1.0 - blue) * intensity);
    }
    else
    {
	red = red * intensity;
	green = green * intensity;
	blue = blue * intensity;
    }

    *r = (unsigned char)(red * 255.0);
    *g = (unsigned char)(green * 255.0);
    *b = (unsigned char)(blue * 255.0);

    return RGB(*r,*g,*b);
}

static unsigned long random_color(unsigned char *r, unsigned char *g, unsigned char *b)
{
    double d1, d2;

    d1 = (double)rand() / (double)RAND_MAX;
    d2 = (double)rand() / (double)RAND_MAX;

    return getColorRGB(d1, d2 + 0.5, r, g, b);
}

#define MAX_RANDOM_COLOR_STR 40
static char random_color_str[MAX_RANDOM_COLOR_STR];
static char *get_random_color_str()
{
    unsigned char r,g,b;
    random_color(&r, &g, &b);
    MPIU_Snprintf(random_color_str, MAX_RANDOM_COLOR_STR, 
		  "%3d %3d %3d", (int)r, (int)g, (int)b);
    return random_color_str;
}

int MPIR_Describe_timer_states()
{

    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_FINALIZE, "MPID_Finalize", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_REQUEST_FREE, "MPI_Request_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_WAIT, "MPID_Win_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_GET_SOCK_ID, "mpidu_sock_getid", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GATHER, "MPI_Gather", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_GROUP, "MPI_Comm_group", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RDMA_WRITEV, "mpidi_ch3i_rdma_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SSEND_INIT, "MPID_Ssend_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WAIT, "MPI_Wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_FINALIZE, "mpidu_sock_finalize", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_WAIT, "MPIU_Event_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_POST_CLOSE, "mpidu_sock_post_close", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_WRITEV, "MPIDI_CH3I_SHM_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_HVECTOR, "MPI_Type_hvector", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_GET_ENVELOPE, "MPI_Type_get_envelope", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_DELETE, "MPI_Info_delete", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_MPIDI_CH3I_MQSHM_SEND, "MPIDI_MPIDI_CH3I_mqshm_send", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_PACK_EXTERNAL32_TO_BUF, "MPID_Segment_contig_pack_external32_to_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_CREATEQP, "ibu_createqp", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_HANDLE_SOCK_OP, "handle_sock_op", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PACK_EXTERNAL_SIZE, "MPI_Pack_external_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_TEST, "MPI_Win_test", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_SET_ERRHANDLER, "MPI_Win_set_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_INCL, "MPI_Group_incl", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_STRUCT, "MPI_Type_create_struct", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_MAP, "MPI_Cart_map", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_GETQUEUEDCOMPLETIONSTATUS, "GetQueuedCompletionStatus", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_NATIVE_TO_SOCK, "mpidu_sock_native_to_sock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_CONTINUE_PACKET_HANDLER, "MPIDI_CH3_CONTINUE_PACKET_HANDLER", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INITIALIZED, "MPI_Initialized", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_POST_WRITEV, "ibu_post_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SENDRECV, "MPI_Sendrecv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SETUP_CONNECTIONS, "MPIDI_CH3I_Setup_connections", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_WRITE, "MPIDI_CH3I_SHM_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SOCKI_FREE_EVENTQ_MEM, "MPIDU_Socki_free_eventq_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_FREE_KEYVAL, "MPI_Win_free_keyval", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SCATTER, "MPI_Scatter", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PACK_SIZE, "MPI_Pack_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_UNPUBLISH_NAME, "MPI_Unpublish_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_STATUS_SET_ELEMENTS, "MPI_Status_set_elements", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_MATCH_SIZE, "MPI_Type_match_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ABORT, "MPIDI_CH3_Abort", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SHMI_READ_UNEX, "shmi_read_unex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_CONNECT, "MPI_Comm_connect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SLEEP_YIELD, "MPIDU_Sleep_yield", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_UNPACK_EXTERNAL, "MPID_Segment_unpack_external", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_CANCEL_RECV, "MPID_Cancel_recv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_HANDLE_ORDERED_RECV_PKT, "MPIDI_CH3U_Handle_ordered_recv_pkt", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GET_ELEMENTS, "MPI_Get_elements", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_VCRT_CREATE, "MPID_VCRT_Create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_START_QP, "ibu_start_qp", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GREQUEST_COMPLETE, "MPI_Grequest_complete", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_WAIT, "MPI_Win_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_HANDLE_CONNECT, "MPIDU_Socki_handle_connect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_TOSTRING, "MPIDI_CH3I_BootstrapQ_tostring", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_WRITEV, "mpidu_sock_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_REQUEST_GET_STATUS, "MPI_Request_get_status", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GRAPH_GET, "MPI_Graph_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_HANDLE_SHM_READ, "handle_shm_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GET_PROCESSOR_NAME, "MPI_Get_processor_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_POST_READ, "mpidu_sock_post_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_CREATE, "MPIU_Event_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_RECVQ_FDP_OR_AEU, "MPIDI_CH3U_Recvq_FDP_or_AEU", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TESTANY, "MPI_Testany", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ERRHANDLER_CREATE, "MPI_Errhandler_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_CREATE, "MPIDI_CH3I_BootstrapQ_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FINALIZED, "MPI_Finalized", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SET_ATTR, "MPI_Comm_set_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_CONNECT_TO_ROOT, "MPIDI_CH3I_Connect_to_root", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_READ_PROGRESS, "MPIDI_CH3I_SHM_Read_progress", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_START_EPOCH, "MPIDI_CH3_Start_epoch", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_INDEXED, "MPI_Type_indexed", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SPAWN_MULTIPLE, "MPI_Comm_spawn_multiple", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_STATUS_SET_CANCELLED, "MPI_Status_set_cancelled", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIC_IRECV, "MPIC_Irecv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_ACCEPTQ_ENQUEUE, "MPIDI_CH3I_AcceptQ_enqueue", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_PROCESS_LOCK_INIT, "MPIDU_Process_lock_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_CH3_INIT, "MPID_CH3_Init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLGATHERV, "MPI_Allgatherv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_COMPARE, "MPI_Comm_compare", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_POST_READV, "MPIDI_CH3I_SHM_post_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_UPDATE_REMOTE_RDMA_BUF, "ibui_update_remote_rdma_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_SEND_FAIL, "connection_send_fail", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_ISEND, "MPID_Isend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_CREATE, "MPI_Win_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_NOCACHE_REGISTER_MEMORY, "ibu_nocache_register_memory", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_FREE, "connection_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_VECTOR_PACK_TO_IOV, "MPID_Segment_vector_pack_to_iov", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_RDMA_READ, "ibu_rdma_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SPAWN, "MPI_Comm_spawn", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_IREAD, "MPIDI_CH3_Iread", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_PACK, "MPID_Segment_pack", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ISSEND, "MPI_Issend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_POKE, "MPIDI_CH3_Progress_poke", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_IBSEND, "MPI_Ibsend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_CALL_ERRHANDLER, "MPI_Comm_call_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_OP_CREATE, "MPI_Op_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GET_COUNT, "MPI_Get_count", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_CREATE, "MPI_Cart_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLTOALLW, "MPI_Alltoallw", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_GET_BUSINESS_CARD, "MPIDI_CH3I_Get_business_card", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_REMOTE_SIZE, "MPI_Comm_remote_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GRAPHDIMS_GET, "MPI_Graphdims_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_ATTACH_TO_MEM, "MPIDI_CH3I_SHM_Attach_to_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_RECV_INIT, "MPID_Recv_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_HINDEXED, "MPI_Type_create_hindexed", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SCATTERV, "MPI_Scatterv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_BUFFER_UNEX_READ, "ibui_buffer_unex_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_REQUEST_CREATE, "MPIDI_CH3_Request_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_RDMA_BUF_INIT, "ibui_rdma_buf_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_GET_NEXT_BOOTSTRAP_MSG, "Get_next_bootstrap_msg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_DELETE_ATTR, "MPI_Type_delete_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SWITCH_RNDV_TO_EAGER, "MPIDI_CH3I_Switch_rndv_to_eager", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_FINALIZE, "ibu_finalize", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_VCR_DUP, "MPID_VCR_Dup", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_CREATE_SET, "mpidu_sock_create_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SEND_LOCK_PUT_OR_ACC, "MPIDI_CH3I_Send_lock_put_or_acc", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_VCRT_GET_PTR, "MPID_VCRT_Get_ptr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ADD_ERROR_STRING, "MPI_Add_error_string", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_SHIFT, "MPI_Cart_shift", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SIZE, "MPI_Comm_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_DO_PASSIVE_TARGET_RMA, "MPIDI_CH3I_Do_passive_target_rma", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_FENCE, "MPID_Win_fence", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_GET_PARENT, "MPI_Comm_get_parent", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GRAPH_MAP, "MPI_Graph_map", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ERRHANDLER_FREE, "MPI_Errhandler_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CANCEL, "MPI_Cancel", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_START, "MPI_Start", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_INIT, "mpidu_sock_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SSEND, "MPID_Ssend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ERROR_CLASS, "MPI_Error_class", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_VCRT_RELEASE, "MPID_VCRT_Release", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_DUP, "MPI_Type_dup", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_HANDLE_WRITTEN, "handle_written", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_INIT, "ibu_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_DO_RTS, "MPID_CH3_do_rts", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PCONTROL, "MPI_Pcontrol", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_RSEND_INIT, "MPID_Rsend_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_POST_WRITEV, "mpidu_sock_post_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_POST, "MPI_Win_post", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SCAN, "MPI_Scan", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TESTALL, "MPI_Testall", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_UPDATE_REQUEST, "update_request", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_RANK, "MPI_Group_rank", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIC_WAIT, "MPIC_Wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ACCUMULATE, "MPIDI_CH3_Accumulate", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ACCUMULATE, "MPI_Accumulate", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_CREATE_NAMED, "MPIDI_CH3I_BootstrapQ_create_named", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_VAPI_POST_SR, "VAPI_post_sr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_FENCE, "MPI_Win_fence", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_WRITE, "mpidu_sock_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_GET_ERROR_CLASS_STRING, "mpidu_sock_get_error_class_string", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIC_SEND, "MPIC_Send", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SSEND_INIT, "MPI_Ssend_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_REDUCE_SCATTER, "MPI_Reduce_scatter", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GREQUEST_START, "MPI_Grequest_start", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_LISTEN, "mpidu_sock_listen", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_IWRITE, "MPIDI_CH3_iWrite", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_EXTENT, "MPI_Type_extent", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_EXCL, "MPI_Group_excl", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INTERCOMM_MERGE, "MPI_Intercomm_merge", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BIZCARD_CACHE_FREE, "MPIDI_CH3I_Bizcard_cache_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_OPEN, "MPIU_Event_open", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PUT, "MPIDI_CH3_Put", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_COMM_CONNECT, "MPID_Comm_connect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SOCKI_EVENT_ENQUEUE, "MPIDU_Socki_event_enqueue", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_YIELD, "MPIDU_Yield", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GRAPH_CREATE, "MPI_Graph_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_RECVQ_FDU_OR_AEP, "MPIDI_CH3U_Recvq_FDU_or_AEP", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_KEYVAL, "MPI_Type_create_keyval", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_HANDLE_RECV_REQ, "MPIDI_CH3U_Handle_recv_req", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WTICK, "MPI_Wtick", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RDMA_READV, "mpidi_ch3i_rdma_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_CLOSE_PORT, "MPID_Close_port", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_FREE_MEM, "MPIDI_CH3_Free_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_DUP, "MPI_Info_dup", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_DO_PUT, "do_put", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_GET_MEM, "MPIDI_CH3I_SHM_Get_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_REQUEST_LOAD_SEND_IOV, "MPIDI_CH3U_Request_load_send_iov", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_UNLOCK, "MPID_Win_unlock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ATTR_DELETE, "MPI_Attr_delete", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_RECV, "MPID_Recv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_DUP, "MPI_Comm_dup", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_FREE, "MPI_Info_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_F90_COMPLEX, "MPI_Type_create_f90_complex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_UNPACK, "MPID_Segment_unpack", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IB_MALLOC_REGISTER, "ib_malloc_register", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_REDUCE, "MPI_Reduce", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_READV, "readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_COUNT_CONTIG_BLOCKS, "MPID_Segment_count_contig_blocks", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_PACK_TO_IOV, "MPID_Segment_contig_pack_to_iov", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_READ_UNEX, "ibui_read_unex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_POLL, "poll", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_READ, "read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_GET_FIRST_ACTIVE_CA, "ibui_get_first_active_ca", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV, "MPIDI_CH3I_RDMA_read_datav", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_REQUEST_UNPACK_UEBUF, "MPIDI_CH3U_Request_unpack_uebuf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_UNLINK_MEM, "MPIDI_CH3I_SHM_Unlink_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_VC_POST_CONNECT, "MPIDI_CH3I_VC_post_connect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_GET_NAME, "MPI_Type_get_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PACK_EXTERNAL, "MPI_Pack_external", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_SUB, "MPI_Cart_sub", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_TEST, "MPIU_Event_test", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_INTERSECTION, "MPI_Group_intersection", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_ACCEPTQ_DEQUEUE, "MPIDI_CH3I_AcceptQ_dequeue", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ISTARTRNDVMSG, "MPIDI_CH3_iStartRndvMsg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_OPEN_PORT, "MPIDI_CH3_Open_port", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_WAIT_MULTIPLE, "MPIU_Event_wait_multiple", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SOCKI_EVENT_DEQUEUE, "MPIDU_Socki_event_dequeue", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_END, "MPIDI_CH3_Progress_end", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_RECVQ_FDP, "MPIDI_CH3U_Recvq_FDP", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_IS_THREAD_MAIN, "MPI_Is_thread_main", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_COMPLETE, "MPI_Win_complete", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_HOSTNAME_TO_HOST_DESCRIPTION, "mpidu_sock_hostname_to_host_description", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_RSEND, "MPI_Rsend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SHMI_READV_UNEX, "shmi_readv_unex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_WAIT, "MPIDI_CH3I_SHM_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CARTDIM_GET, "MPI_Cartdim_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_LOOKUP_NAME, "MPI_Lookup_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_END_PT_EPOCH, "MPIDI_CH3_End_PT_epoch", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_GET_ERRHANDLER, "MPI_Comm_get_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FILE_GET_ERRHANDLER, "MPI_File_get_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_MODIFYQP, "ibu_modifyqp", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_IRSEND, "MPI_Irsend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TESTSOME, "MPI_Testsome", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_POST_RNDV_CTS_IOV_REG_ERR, "ibui_post_rndv_cts_iov_reg_err", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_GET_EXTENT, "MPI_Type_get_extent", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_POST_READ, "ibu_post_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_FREE, "MPID_Win_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_VCR_GET_LPID, "MPID_VCR_Get_lpid", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TEST, "MPI_Test", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ISEND, "MPIDI_CH3_Isend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_HANDLE_UNORDERED_RECV_PKT, "MPIDI_CH3U_Handle_unordered_recv_pkt", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_LOCK, "MPID_Win_lock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_POST_SEND_PKT, "connection_post_send_pkt", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_DIMS_CREATE, "MPI_Dims_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_DELETE_ATTR, "MPI_Win_delete_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_INDEXED_BLOCK, "MPI_Type_create_indexed_block", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_ALLOC_MEM, "MPID_Alloc_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ISEND, "MPI_Isend", "64 64 255");
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIC_SENDRECV, "MPIC_Sendrecv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_READV_UNEX, "ibui_readv_unex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_SET_NAME, "MPI_Type_set_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_SET_ATTR, "MPI_Win_set_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_HANDLE_POLLERR, "MPIDU_Socki_handle_pollerr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIC_RECV, "MPIC_Recv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_POST_WRITE, "mpidu_sock_post_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_COMM_CONNECT, "MPIDI_CH3_Comm_connect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_UNLINK_AND_DETACH_MEM, "MPIDI_CH3I_SHM_Unlink_and_detach_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_GET, "MPI_Cart_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_GET_NKEYS, "MPI_Info_get_nkeys", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_FREE, "MPI_Win_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_SET, "MPIU_Event_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_REQUEST_UNPACK_SRBUF, "MPIDI_CH3U_Request_unpack_srbuf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_CREATE_ERRHANDLER, "MPI_Comm_create_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INTERCOMM_CREATE, "MPI_Intercomm_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GRAPH_NEIGHBORS, "MPI_Graph_neighbors", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_GET, "MPIDI_CH3_Get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_PROGRESS, "MPIDI_CH3I_Progress", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_COMM_SPAWN_MULTIPLE, "MPID_Comm_spawn_multiple", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_RECVQ_FU, "MPIDI_CH3U_Recvq_FU", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_READ, "mpidu_sock_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_TEST_INTER, "MPI_Comm_test_inter", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_END_EPOCH, "MPIDI_CH3_End_epoch", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_UNPACK_EXTERNAL, "MPI_Unpack_external", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_CANCEL_SEND, "MPIDI_CH3_Cancel_send", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_UNLOCK, "MPI_Win_unlock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_CREATE_KEYVAL, "MPI_Comm_create_keyval", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_RESET, "MPIU_Event_reset", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_PROCESS_LOCK_FREE, "MPIDU_Process_lock_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_VCRT_ADD_REF, "MPID_VCRT_Add_ref", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_IRSEND, "MPID_Irsend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_DEREGISTER_MEMORY, "ibu_deregister_memory", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_GET, "MPI_Info_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_VECTOR, "MPI_Type_vector", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_RECVQ_DP, "MPIDI_CH3U_Recvq_DP", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_REGISTER_MEMORY, "ibu_register_memory", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_TRANSLATE_RANKS, "MPI_Group_translate_ranks", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SET_ERRHANDLER, "MPI_Comm_set_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_NOCACHE_DEREGISTER_MEMORY, "ibu_nocache_deregister_memory", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PUBLISH_NAME, "MPI_Publish_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_REQUEST_ADJUST_IOV, "MPIDI_CH3I_request_adjust_iov", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_INIT, "MPIDI_CH3I_Progress_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_BSEND_INIT, "MPI_Bsend_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_START_PT_EPOCH, "MPIDI_CH3_Start_PT_epoch", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_RANK, "MPI_Comm_rank", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PACK, "MPI_Pack", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_INVALIDATE_MEMORY, "ibu_invalidate_memory", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_EXSCAN, "MPI_Exscan", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FINALIZE, "MPI_Finalize", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SENDRECV_REPLACE, "MPI_Sendrecv_replace", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ISTARTMSG, "MPIDI_CH3_iStartMsg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_UB, "MPI_Type_ub", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_PROBE, "MPID_Probe", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INIT_THREAD, "MPI_Init_thread", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_RSEND_INIT, "MPI_Rsend_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PUT, "MPI_Put", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_UNPACK_EXTERNAL32_TO_BUF, "MPID_Segment_contig_unpack_external32_to_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_RDMAI_BUFFER_UNEX_READ, "shmi_buffer_unex_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_REQUEST_ADD_REF, "MPIDI_CH3_Request_add_ref", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLOC_MEM, "MPI_Alloc_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_LISTENER_GET_PORT, "MPIDI_CH3I_Listener_get_port", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV, "MPIDI_CH3I_RDMA_put_datav", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_RDMA_WRITEV, "mpidi_ch3i_shm_rdma_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GET, "MPI_Get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_POST_READV, "ibu_post_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_SOCK_FREE, "MPIDU_Socki_sock_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_UNPACK_VECTOR, "MPID_Segment_unpack_vector", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_RECV, "MPI_Recv", "255 0 0");
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_STARTALL, "MPID_Startall", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_REMOTE_GROUP, "MPI_Comm_remote_group", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLTOALL, "MPI_Alltoall", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_POST_PKT_RECV, "post_pkt_recv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_START, "MPI_Win_start", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_BSEND, "MPI_Bsend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_GET_ERRHANDLER, "MPI_Win_get_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ABORT, "MPI_Abort", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_COMPARE_SWAP, "MPIDU_Compare_swap", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_SET_NAME, "MPI_Win_set_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_FREE_MEM, "MPID_Free_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_GET, "MPID_Get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_BUFFER_COPY, "MPIDI_CH3U_buffer_copy", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_COMM_DISCONNECT, "MPID_Comm_disconnect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_PUT_DATAV, "MPIDI_CH3I_Put_datav", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_COUNT_BLOCK, "MPID_Segment_contig_count_block", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_IRECV, "MPI_Irecv", "255 64 64");
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_QUERY_THREAD, "MPI_Query_thread", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_COORDS, "MPI_Cart_coords", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TEST_CANCELLED, "MPI_Test_cancelled", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_RDMAI_READ_UNEX, "shmi_read_unex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_PACK_EXTERNAL, "MPID_Segment_pack_external", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_IPROBE, "MPI_Iprobe", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_COMMIT, "MPI_Type_commit", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_GET_NAME, "MPI_Comm_get_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_COMM_SPAWN_MULTIPLE, "MPIDI_CH3_Comm_spawn_multiple", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLREDUCE, "MPI_Allreduce", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_RECV_MSG, "MPIDI_CH3I_BootstrapQ_recv_msg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_GET_LID, "ibu_get_lid", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_COMPLETE, "MPID_Win_complete", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_WRITE, "ibu_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_PROCESS_LOCK_BUSY_WAIT, "MPIDU_Process_lock_busy_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_RDMAI_READV_UNEX, "shmi_readv_unex", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_CREATE_UNIQUE_NAME, "MPIDI_CH3I_BootstrapQ_create_unique_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_HVECTOR, "MPI_Type_create_hvector", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MEMCPY, "memcpy", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_VAPI_REGISTER_MR, "VAPI_register_mr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_OPEN_PORT, "MPID_Open_port", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_ATTACH, "MPIDI_CH3I_BootstrapQ_attach", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_PUT, "MPID_Put", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_UNION, "MPI_Group_union", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SEND, "MPI_Send", "0 0 255");
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_ALLOC, "connection_alloc", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WAITANY, "MPI_Waitany", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_MQSHM_RECEIVE, "MPIDI_CH3I_mqshm_receive", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_SIZE, "MPI_Type_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_RDMA_WRITE, "ibu_rdma_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ADD_ERROR_CODE, "MPI_Add_error_code", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_START, "MPIDI_CH3_Progress_start", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_FREE, "MPI_Comm_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_HANDLE_READ, "MPIDU_Socki_handle_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_BUFFER_ATTACH, "MPI_Buffer_attach", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_CREATE, "MPI_Info_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_RELOAD_IOV_REPLY_HANDLER, "MPIDI_CH3_RELOAD_IOV_REPLY_HANDLER", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_MQSHM_UNLINK, "MPIDI_CH3I_mqshm_unlink", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_FINISH_QP, "ibu_finish_qp", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IB_FREE_DEREGISTER, "ib_free_degregister", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WTIME, "MPI_Wtime", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_READV, "mpidu_sock_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_POST_ACK_WRITE, "ibui_post_ack_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_HANDLE_READ, "handle_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SOCK_NATIVE_TO_SOCK, "sock_native_to_sock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_PROBE, "MPI_Probe", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_CREATE, "MPI_Comm_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GET_ADDRESS, "MPI_Get_address", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_GET_SOCK_SET_ID, "mpidu_sock_getsetid", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ERROR_STRING, "MPI_Error_string", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_REGISTER_DATAREP, "MPI_Register_datarep", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ERRHANDLER_GET, "MPI_Errhandler_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_GET_ATTR, "MPI_Type_get_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_WRITE_PROGRESS, "MPIDI_CH3I_SHM_Write_progress", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ISTARTMSGV, "MPIDI_CH3_iStartMsgv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLTOALLV, "MPI_Alltoallv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_POST_READV, "mpidu_sock_post_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_TEST, "MPID_Win_test", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_REQUEST_DESTROY, "MPIDI_CH3_Request_destroy", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_HANDLE_SEND_REQ, "MPIDI_CH3U_Handle_send_req", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_WIN_FREE, "MPIDI_CH3_Win_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_WAIT, "mpidi_ch3_progress_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_STARTALL, "MPI_Startall", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_RELEASE_MEM, "MPIDI_CH3I_SHM_Release_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_BARRIER, "MPI_Barrier", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_OP_FREE, "MPI_Op_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_VECTOR_UNPACK_TO_BUF, "MPID_Segment_vector_unpack_to_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_GET_ATTR, "MPI_Win_get_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ISTARTRNDVTRANSFER, "MPIDI_CH3_iStartRndvTransfer", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_STRUCT, "MPI_Type_struct", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ATTR_PUT, "MPI_Attr_put", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_HANDLE_WRITE, "MPIDU_Socki_handle_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_COMPARE, "MPI_Group_compare", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_ACCUMULATE, "MPID_Accumulate", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_PROGRESS_HANDLE_SOCK_EVENT, "mpidi_ch3i_progress_handle_sock_event", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_SET_ATTR, "MPI_Type_set_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_SET_USER_PTR, "ibu_set_vc_ptr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_VECTOR_PACK_TO_BUF, "MPID_Segment_vector_pack_to_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_GET_HOST_DESCRIPTION, "mpidu_sock_get_host_description", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_DISCONNECT, "MPI_Comm_disconnect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_F90_INTEGER, "MPI_Type_create_f90_integer", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_BOOTSTRAPQWNDPROC, "BOOTSTRAPQWNDPROC", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WAITSOME, "MPI_Waitsome", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CONTIGUOUS, "MPI_Type_contiguous", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_UNPACK_TO_BUF, "MPID_Segment_contig_unpack_to_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_ISSEND, "MPID_Issend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_TEST_MULTIPLE, "MPIU_Event_test_multiple", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_CALL_ERRHANDLER, "MPI_Win_call_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_UNLINK, "MPIDI_CH3I_BOOTSTRAPQ_UNLINK", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBUI_GET_LIST_OF_HCAS, "ibui_get_list_of_hcas", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS, "MPIDI_CH3_Progress", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_VECTOR_FLATTEN, "MPID_Segment_vector_flatten", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_ABORT, "MPID_Abort", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_WRITE, "write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_POST_RECV_PKT, "connection_post_recv_pkt", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CLOSE_PORT, "MPI_Close_port", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_FREE, "MPI_Group_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_WAIT, "mpidu_sock_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RECV_RMA_MSG, "MPIDI_CH3I_Recv_rma_msg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_WRITEV, "writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SPLIT, "MPI_Comm_split", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FREE_MEM, "MPI_Free_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ATTR_GET, "MPI_Attr_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_WIN_CREATE, "MPIDI_CH3_Win_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SEND_ENQUEUEDV, "send_enqueuedv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_CREATE_ERRHANDLER, "MPI_Win_create_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_PACK_VECTOR, "MPID_Segment_pack_vector", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_FLATTEN, "MPID_Segment_flatten", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_RSEND, "MPID_Rsend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_DARRAY, "MPI_Type_create_darray", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_POST_WRITE, "ibu_post_write", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_SUBARRAY, "MPI_Type_create_subarray", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_GET_CONTENTS, "MPI_Get_contents", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_POST_SEND_PKT_AND_PGID, "connection_post_send_pkt_and_pgid", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_SET_USER_PTR, "mpidu_sock_set_user_ptr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_GET_VALUELEN, "MPI_Info_get_valuelen", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_SIZE, "MPI_Group_size", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_GET_ATTR, "MPI_Comm_get_attr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FILE_SET_ERRHANDLER, "MPI_File_set_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_UNPACK, "MPI_Unpack", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_RECV_FAIL, "connection_recv_fail", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_CREATE, "MPID_Win_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_RDMA_READV, "mpidi_ch3i_shm_rdma_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_BCAST, "MPI_Bcast", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_COMM_ACCEPT, "MPIDI_CH3_Comm_accept", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_START, "MPID_Win_start", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_IPROBE, "MPID_Iprobe", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_PROGRESS_INIT, "MPID_STATE_MPIDI_CH3I_PROGRESS_INIT", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_F90_REAL, "MPI_Type_create_f90_real", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_PARSE_OPTION, "MPID_Parse_option", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RDMA_POST_READV, "MPIDI_CH3I_RDMA_post_readv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_BUFFER_DETACH, "MPI_Buffer_detach", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_RANGE_INCL, "MPI_Group_range_incl", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_DESTROY_SET, "ibu_destroy_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_POST_CONNECT, "mpidu_sock_post_connect", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GATHERV, "MPI_Gatherv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_SET_NAME, "MPI_Comm_set_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_CREATE_KEYVAL, "MPI_Win_create_keyval", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FILE_CREATE_ERRHANDLER, "MPI_File_create_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_WRITEV, "ibu_writev", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SEND_LOCK_GET, "MPIDI_CH3I_Send_lock_get", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_CREATE_SET, "ibu_create_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_SET, "MPI_Info_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_WAIT, "ibu_wait", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_DETACH, "MPIDI_CH3I_BootstrapQ_detach", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_FREE, "MPI_Type_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_FREE_KEYVAL, "MPI_Comm_free_keyval", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_HANDLE_POLLHUP, "MPIDU_Socki_handle_pollhup", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_GETMAXINLINESIZE, "getMaxInlineSize", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_RELOAD_IOV_OR_DONE_HANDLER, "MPIDI_CH3_RELOAD_IOV_OR_DONE_HANDLER", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_ATTACH_NOTUNLINK_MEM, "MPIDI_CH3I_SHM_Attach_notunlink_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_KEYVAL_CREATE, "MPI_Keyval_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_PROGRESS_FINALIZE, "MPID_STATE_MPIDI_CH3I_PROGRESS_FINALIZE", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_LB, "MPI_Type_lb", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CONNECTION_POST_SENDQ_REQ, "connection_post_sendq_req", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_POST_READ, "MPIDI_CH3I_SHM_post_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_PACK_TO_BUF, "MPID_Segment_contig_pack_to_buf", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_HINDEXED, "MPI_Type_hindexed", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_PROCESS_UNLOCK, "MPIDU_Process_lock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_RANGE_EXCL, "MPI_Group_range_excl", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_RECV_INIT, "MPI_Recv_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SSEND, "MPI_Ssend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_MQSHM_CLOSE, "MPIDI_CH3I_mqshm_close", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_JOIN, "MPI_Comm_join", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ADD_ERROR_CLASS, "MPI_Add_error_class", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_DESTROY, "MPIDI_CH3I_BootstrapQ_destroy", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_ACCEPT, "MPI_Comm_accept", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INFO_GET_NTHKEY, "MPI_Info_get_nthkey", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ERRHANDLER_SET, "MPI_Errhandler_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_GET_MEM_NAMED, "MPIDI_CH3I_SHM_Get_mem_named", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_RECVQ_FDU, "MPIDI_CH3U_Recvq_FDU", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_MQSHM_CREATE, "MPIDI_CH3I_mqshm_create", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_REQUEST_RELEASE_REF, "MPIDI_CH3_Request_release_ref", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3U_REQUEST_LOAD_RECV_IOV, "MPIDI_CH3U_Request_load_recv_iov", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_TEST, "MPIDI_CH3_Progress_test", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_BOOTSTRAPQ_SEND_MSG, "MPIDI_CH3I_BootstrapQ_send_msg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_VAPI_DEREGISTER_MR, "VAPI_deregister_mr", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEND, "MPID_Send", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WAITALL, "MPI_Waitall", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_DESTROY_SET, "mpidu_sock_destroy_set", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_BSEND_INIT, "MPID_Bsend_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_READ_PROGRESS, "rdma_read_progress", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_DO_CTS, "MPIDI_CH3_do_cts", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ALLGATHER, "MPI_Allgather", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEND_INIT, "MPID_Send_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_LOCK, "MPI_Win_lock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCK_ACCEPT, "mpidu_sock_accept", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_LOOKUP_BIZCARD_CACHE, "MPIDI_CH3I_Lookup_bizcard_cache", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_GET_NAME, "MPI_Win_get_name", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_OPEN_PORT, "MPI_Open_port", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_PROCESS_LOCK, "MPIDU_Process_lock", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIC_ISEND, "MPIC_Isend", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ALLOC_MEM, "MPIDI_CH3_Alloc_mem", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_FREE_KEYVAL, "MPI_Type_free_keyval", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_FILE_CALL_ERRHANDLER, "MPI_File_call_errhandler", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_ADDRESS, "MPI_Address", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_SEGMENT_CONTIG_FLATTEN, "MPID_Segment_contig_flatten", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_KEYVAL_FREE, "MPI_Keyval_free", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_CANCEL_SEND, "MPID_Cancel_send", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_COMM_ACCEPT, "MPID_Comm_accept", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_ISENDV, "MPIDI_CH3_Isendv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_WIN_GET_GROUP, "MPI_Win_get_group", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_CART_RANK, "MPI_Cart_rank", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GET_VERSION, "MPI_Get_version", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_WIN_POST, "MPID_Win_post", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GROUP_DIFFERENCE, "MPI_Group_difference", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_SHMI_BUFFER_UNEX_READ, "shmi_buffer_unex_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_CTS_PACKET_HANDLER, "MPIDI_CH3_CTS_PACKET_HANDLER", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_CREATE_REQUEST, "Create_request", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_GET_TRUE_EXTENT, "MPI_Type_get_true_extent", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDU_SOCKI_SOCK_ALLOC, "MPIDU_Socki_sock_alloc", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_RDMA_POST_READ, "MPIDI_CH3I_RDMA_post_read", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_SEND_INIT, "MPI_Send_init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_ADD_TO_BIZCARD_CACHE, "MPIDI_CH3I_Add_to_bizcard_cache", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIU_EVENT_CLOSE, "MPIU_Event_close", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_IBU_POLL, "ibu_poll", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TOPO_TEST, "MPI_Topo_test", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SHM_GET_MEM_SYNC, "MPIDI_CH3I_SHM_Get_mem_sync", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_GRAPH_NEIGHBORS_COUNT, "MPI_Graph_neighbors_count", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_PROGRESS_FINALIZE, "MPIDI_CH3I_Progress_finalize", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_INIT, "MPI_Init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_IRECV, "MPID_Irecv", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3I_SEND_RMA_MSG, "MPIDI_CH3I_Send_rma_msg", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_TYPE_CREATE_RESIZED, "MPI_Type_create_resized", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_COMM_SPAWN, "mpidi_comm_spawn", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPID_INIT, "MPID_Init", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPIDI_CH3_START_PACKET_HANDLER, "MPIDI_CH3_START_PACKET_HANDLER", get_random_color_str());
    RLOG_DescribeState(g_pRLOG, MPID_STATE_MPI_COMM_DELETE_ATTR, "MPI_Comm_delete_attr", get_random_color_str());
    return 0;
}

#endif /* USE_LOGGING == MPID_LOGGING_RLOG */
#endif /* HAVE_TIMING */
#endif /* MPICH_MPI_FROM_PMPI */
