#!/bin/csh -f
########################################################################
# This is the environment setting script for Dakota's CSH-based test
# suite.  It is sourced by '[run,send]_[base|package]_[test,mail].csh'.
########################################################################

# BMA: Only Linux64 sections have been updated

# Default user .cshrc file (/bin/csh initialization).
# Set up C shell environment: source system-wide .cshrc
if ( -r /usr/local/etc/system.cshrc ) then
  source /usr/local/etc/system.cshrc
endif

# Need /usr/local/bin to be ahead of /usr/bin in the $PATH
# (removing duplicates could be better...quick and dirty for now)
setenv PATH `echo $PATH | sed 's/\/usr\/local\/bin/\/usr\/bin/'`
setenv PATH `echo $PATH | sed 's/\/usr\/bin/\/usr\/local\/bin/'`
if ( -f /usr/bin/uname ) then
  if ( `/usr/bin/uname` == 'Darwin' ) then
    setenv PATH $PATH":/usr/bin"
  endif
endif

# Miscellaneous netpub tools setup
#setenv PATH "/usr/netpub/bin:"$PATH

# SIERRA setup
#setenv PATH "/home/sntools/production/current/sntools/engine:"$PATH

# TEXINPUTS setup (be certain to put a trailing ':' on this variable)
setenv TEXINPUTS /Net/dakota/TeX/styles:

# Autotools, Dakota, Subversion and test directory setup
setenv CVS_RSH "ssh"
setenv DAKOTA_HOME "/Net/dakota"
setenv DEV_SVNROOT "svn+ssh://development.sandia.gov/usr/local/svn"
setenv SOF_SVNROOT "svn+ssh://software.sandia.gov/svn/private"


# Set umask to allow group write permission on all created files
umask 002

# Platform-specific $*PATH setup
setenv ARCH `uname -m`
setenv UNAME `uname`
if ( $UNAME == 'AIX' ) then
  setenv MANPATH "/usr/lpp/xlf/man/en_US:"$MANPATH
  setenv MANPATH "/usr/vac/man/en_US:/usr/vacpp/man/en_US:"$MANPATH
else if ( $UNAME == 'Darwin' ) then
  setenv MANPATH `manpath`
  setenv MANPATH $MANPATH":/opt/ibmcmp/xlf/8.1/man/en_US/man"
  setenv MANPATH $MANPATH":/sw/man"
  setenv MPIHOME "/usr/local/mpich-1.2.7p1"
  setenv PATH $PATH":/opt/ibmcmp/xlf/8.1/bin"
  setenv PATH $PATH":/sw/bin:/sw/sbin"
  setenv MANPATH "$MPIHOME/man:"$MANPATH
  setenv PATH "$MPIHOME/sbin:"$PATH
  setenv PATH "$MPIHOME/bin:"$PATH
  setenv PATH ".:"$PATH
else if ( $UNAME == 'Linux' ) then
  setenv MANPATH `manpath`
  if ( $ARCH == 'i686' ) then
    setenv AUTOHOME `echo "$AUTOHOME"32`
    if ( -d /usr/local/mpi/mpich/32Bit/1.2.7/gcc-3.4.3 ) then # RHEL 4
      setenv MPIHOME "/usr/local/mpi/mpich/32Bit/1.2.7/gcc-3.4.3"
    else if ( -d /usr/local/mpi/mpich/1.2.5.2/gcc-3.2.2 ) then # RedHat 9
      setenv MPIHOME "/usr/local/mpi/mpich/1.2.5.2/gcc-3.2.2"
    endif
  else if ( $ARCH == 'x86_64' ) then
    setenv AUTOHOME "/Net/dakota/arch/linux64"
    if ( -d /Net/dakota/arch/linux64/mpich-1.2.7p1 ) then # RHEL 4
      setenv MPIHOME /Net/dakota/arch/linux64/mpich-1.2.7p1
    endif
    setenv SVNHOME "/Net/dakota/arch/linux64"
    #set pgifix64 = 'sed -e s/\(linux86\)\(\/\)/\1\-64\2/g'
    #setenv PGI `echo $PGI | $pgifix64`
    #setenv PATH `echo $PATH | $pgifix64`
    #setenv LD_LIBRARY_PATH `echo $LD_LIBRARY_PATH | $pgifix64`
  endif
  setenv MANPATH "$MPIHOME/man:"$MANPATH
  setenv PATH "$MPIHOME/sbin:"$PATH
  setenv PATH "$MPIHOME/bin:"$PATH
else if ( $UNAME == 'SunOS' ) then
  setenv MPIHOME "/opt/SUNWhpc"
  setenv MANPATH "$MPIHOME/man:"$MANPATH
  setenv PATH "$MPIHOME/sbin:"$PATH
  setenv PATH "$MPIHOME/bin:"$PATH
endif

# Set up stty to behave correctly on platforms other than Darwin/Linux/Solaris
if ( $UNAME == 'AIX' || $UNAME == 'IRIX64' ) then
  stty sane dec
endif

# Platform-independent $*PATH setup
setenv MANPATH "$AUTOHOME/man:$SVNHOME/man:"$MANPATH
setenv PATH "$AUTOHOME/bin:$SVNHOME/bin:"$PATH

# Platform-specific environment setup
if ( $UNAME == 'AIX' ) then
  setenv BUILD_JOBS "16"
  setenv CC "xlc"
  setenv CXX "xlC"
  setenv F77 "xlf"
  setenv FC "xlf90"
  setenv LAPACK_LIBS "/usr/netpub/LAPACK/liblapack.a"
else if ( $UNAME == 'Darwin' ) then
  setenv BUILD_JOBS "2"
  setenv CC "gcc"
  setenv CXX "g++"
  setenv F77 "g77"
  setenv FC "xlf90"
  setenv LDFLAGS "-lcc_dynamic -Wl,-framework -Wl,vecLib"
  setenv MPICXX "mpicxx"
  setenv X_CFLAGS "-I/sw/include"
  setenv X_LIBS "-L/sw/lib"
else if ( $UNAME == 'IRIX64' ) then
  setenv AWK "/bin/awk"
  setenv BUILD_JOBS "4"
  setenv CC "cc"
  setenv CXX "CC"
  setenv F77 "f77"
  setenv FC "f90"
  setenv EDG_PRELINK_INPUT_LINE_SIZE 65536
  setenv SGI_ABI "-64"
  setenv X_CFLAGS "-I/usr/include"
  setenv X_LIBS "-L/usr/lib64"
  setenv YACC "/usr/bin/yacc"
else if ( $UNAME == 'Linux' ) then
  setenv BUILD_JOBS "4"
  setenv CC "gcc"
  setenv CXX "g++"
  setenv F77 "g77"
  setenv FC "gfortran"
  setenv LDFLAGS "-static-libgcc"
else if ( $UNAME == 'SunOS' ) then
  setenv BUILD_JOBS "4"
  setenv CC "cc"
  setenv CXX "CC"
  setenv F77 "f77"
  setenv FC "f90"
  setenv BLAS_LIBS "/opt/SUNWspro/lib/libsunperf.so"
  setenv LAPACK_LIBS "/opt/SUNWspro/lib/libsunperf.so"
  setenv LDFLAGS "-lmvec"
  setenv YACC "/usr/ccs/bin/yacc"
endif
if ( $UNAME == 'SunOS' ) then
  setenv CFLAGS "-fast"
  setenv CXXFLAGS "-fast"
  setenv FFLAGS "-fast"
  setenv FCFLAGS "-fast"
else
  setenv CFLAGS "-O2"
  setenv CXXFLAGS "-O2"
  setenv FFLAGS "-O2"
  setenv FCFLAGS "-O2"
endif
