%
%  display for the nonlinear_inequality_constraint class.
%
%  []=display(nic)
%
function []=display(nic)

if ~isa(nic,'nonlinear_inequality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(nic),'nonlinear_inequality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(nic)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(nic),inputname(1),string_dim(nic,i)));
    disp(sprintf('    descriptor: ''%s'''  ,nic(i).descriptor));
    disp(sprintf('         lower: %g'      ,nic(i).lower));
    disp(sprintf('         upper: %g'      ,nic(i).upper));
    disp(sprintf('    scale_type: ''%s'''  ,nic(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,nic(i).scale));
end

end
