/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

#ifndef SYSTEM_DEFS_H
#define SYSTEM_DEFS_H

#ifdef HAVE_CONFIG_H
#include "dakota_config.h"
#endif /* HAVE_CONFIG_H */

/* C++ headers */

#ifdef __cplusplus
#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
using namespace std;
#endif /* __cplusplus */

/* C headers */

#if defined(HAVE_STD) && defined(__cplusplus)
/* C++ compiler using new C headers */
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>
#include <cfloat>
#include <climits>
#include <cmath>
#include <cassert>
#include <csignal>
#include <cerrno>
#include <ctime>
#else
/* C compiler (old style headers are used to avoid std namespace)
   or a C++ compiler which uses old C headers */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <float.h>
#include <limits.h>
#include <math.h>
#include <assert.h>
#include <signal.h>
#include <errno.h>
#include <time.h>
#endif /* HAVE_STD && __cplusplus */

#endif /* SYSTEM_DEFS_H */
