function outvector=ShiftLayers(md,vector,initial_layer,final_layer)
%SHIFTLAYERS - shift the value of a 3d field from ina layer to another
%
%   Usage:
%      outvector=ShiftLayers(md,vector,initial_layer,final_layer)

%Project initial_layer of vector onto 2d mesh
vector2d=project2d(md,vector,initial_layer);

%Extrude vector2d onto 3d vector, where vector2d is in the final layer of the mesh
outvector=project3d(md,vector2d,'node',final_layer);
