/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class GeneticAlgorithmOperatorSet.

    NOTES:

        See notes of GeneticAlgorithmOperatorSet.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Wed May 28 16:03:18 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the GeneticAlgorithmOperatorSet class.
 */





/*
================================================================================
Includes
================================================================================
*/







/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {






/*
================================================================================
Namespace Using Directives
================================================================================
*/






/*
================================================================================
Inline Mutators
================================================================================
*/





/*
================================================================================
Inline Accessors
================================================================================
*/
inline
GeneticAlgorithm&
GeneticAlgorithmOperatorSet::GetAlgorithm(
    )
{
    return _algorithm;
}

inline
const GeneticAlgorithm&
GeneticAlgorithmOperatorSet::GetAlgorithm(
    ) const
{
    return _algorithm;
}






/*
================================================================================
Inline Public Methods
================================================================================
*/






/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA
