function xyz=getgriddata(pentaelem,grids)
%GETGRIDDATA - create an array of space coordinates for the grids
%
%   Create array xyz of size num_grids x 3 (3 for x,y and z)
%   of space coordinates for each grid. 
%
%   Usage:
%      xyz=getgriddata(pentaelem,grids)

num_grids=6;

xyz=zeros(num_grids,3);

for i=1:num_grids,
	xyz(i,1)=grids(pentaelem.g(i)).grid.x;
	xyz(i,2)=grids(pentaelem.g(i)).grid.y;
	xyz(i,3)=grids(pentaelem.g(i)).grid.z;
end
