#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of triangle
name=`echo *.zip | sed 's/\.zip//g'`

#Some cleanup 
rm -rf install $name

#Create install directories
mkdir install

#Untar 
cd install
cp ../$name.zip ./
unzip $name.zip

#copy new makefile
cp ../makefile ./

#Patch triangle.c 
patch triangle.c ../triangle.c.patch

#Compile triangle
make  -j $NUMCPUS

#Patch triangle.h
patch triangle.h ../triangle.h.patch

