function projected_vector=project3d(md,vector2d,type,varargin);
%PROJECT3D - vertically project a vector from 2d mesh
%
%   vertically project a vector from 2d mesh (split in noncoll and coll areas) into a 3d mesh.
%   This vector can be a grid vector of size (md.numberofgrids2d,N/A) or an 
%   element vector of size (md.numberofelements2d,N/A). 
%   type is 'element' or 'node'. layer an optional layer number where vector 
%   should keep its values. If not specified, all layers adopt the value of the 
%   2d vector.
%
%   Usage:
%      extruded_vector=project3d(md,vector2d,type,layer);

if nargin==4,
	layer=varargin{1};
	if ((layer<1) || (layer>md.numlayers)),
		error(['project3d error message: layer shoud be between 1 and ' num2str(md.numlayers)]);
	end
else
	layer=0;
end

if strcmpi(type,'node'),

	projected_vector=zeros(md.numberofgrids,size(vector2d,2));
	
	if layer==0,
		for i=1:md.numlayers,
			projected_vector(((i-1)*md.numberofgrids2d+1):(i*md.numberofgrids2d),:)=vector2d;
		end
	else
		projected_vector(((layer-1)*md.numberofgrids2d+1):(layer*md.numberofgrids2d),:)=vector2d;
	end
else

	projected_vector=zeros(md.numberofelements,size(vector2d,2));

	if layer==0,
		for i=1:(md.numlayers-1),
			projected_vector( ((i-1)*md.numberofelements2d+1):(i*md.numberofelements2d),:)=vector2d;
		end

	else
		projected_vector( ((layer-1)*md.numberofelements2d+1):(layer*md.numberofelements2d),:)=vector2d;
	end
end
