%
%  display for the least_squares_term class.
%
%  []=display(lst)
%
function []=display(lst)

if ~isa(lst,'least_squares_term')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(lst),'least_squares_term');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(lst)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(lst),inputname(1),string_dim(lst,i)));
    disp(sprintf('    descriptor: ''%s'''  ,lst(i).descriptor));
    disp(sprintf('    scale_type: ''%s'''  ,lst(i).scale_type));
    disp(sprintf('         scale: %g'      ,lst(i).scale));
    disp(sprintf('        weight: %g\n'    ,lst(i).weight));
end

end
