function [indic ,info ,index,x,y,node_on_boundary,element_on_boundary]=mesh_creator_2d(domain,nel_initial);
%MESH_CREATOR_2D - ???
%
%   This program creates a mesh from a contour,
%   INPUT domain nel_initial
%   OUTPUT index x y node_on_boundary element_on_boundary
%
%   Usage:
%      [indic ,info ,index,x,y,node_on_boundary,element_on_boundary]=mesh_creator_2d(domain,nel_initial);

nods=length(domain.x);

%%%%%%%%%%%%%create the region file
fid2=fopen(['D:/programmation/utils/mesh.rg2'],'wt');
fprintf(fid2,'%i\n',nods);

for i=1:nods,
      A=[domain.x(i) domain.y(i) 2];
      fprintf(fid2,'%f %f %i\n',A);
end


newline(fid2);
fprintf(fid2,'%i\n',0);
newline(fid2);

fprintf(fid2,'%i\n',1);
newline(fid2);

fprintf(fid2,'%i %i %i\n',[nods 1 0]);
A='';
for i=1:nods-1,
   A=[A '%i '];
end
A=[A '%i\n'];

B=1:1:nods;

C=zeros(1,nods);
for i=1:nods,
   C(i)=20*i+2;
end

fprintf(fid2,A,B);
fprintf(fid2,A,C);

fclose(fid2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%create curves files
fid2=fopen(['D:/programmation/utils/mesh.cs2'],'wt');
fprintf(fid2,'%i\n',nods);
newline(fid2);

for i=1:nods-1,
   fprintf(fid2,'%i %i\n',[1 0]);
   fprintf(fid2,'%i %i\n',[i i+1]);
   newline(fid2);
end
fprintf(fid2,'%i %i\n',[1 0]);
fprintf(fid2,'%i %i\n',[nods 1]);
newline(fid2);

fclose(fid2);







fid=fopen(['D:/programmation/utils/mesh2d.in'],'wt');
fprintf(fid,'%i %i %i %i %i %i %i\n',[202 1 1 0 0 0 1]);
fprintf(fid,'%s',['D:/programmation/utils/mesh.rg2']);
newline(fid);
fprintf(fid,'%s',['D:/programmation/utils/mesh.cs2']);
newline(fid);
fprintf(fid,'%s',['D:/programmation/utils/mesh2d.exp']);
fprintf(fid,'\n%12.12f %i %i',[1.0e-10 0 0]);
fprintf(fid,'\n%i %i %f %f %f %f %f %f %f %i %i %i %i %f %i %i %f',[4 0 45.0 0.04 0.2 30.0 20.0 1 0.4 10 nel_initial +3 4 0.1 2 2 0.3]);
fclose(fid);

dos(['D:/programmation/utils/zgp0203 D:/programmation/utils/mesh2d.in D:/programmation/utils/mesh2d.out']);
%eval(['delete D:/programmation/utils/mesh.rg2']);
%eval(['delete D:/programmation/utils/mesh.cs2']);
%eval(['delete D:/programmation/utils/mesh2d.in']);
%eval(['delete D:/programmation/utils/mesh2d.out']);


fid=fopen('D:/programmation/utils/mesh2d.exp','r');

[A,bytecount]=fscanf(fid,'%f',[1]);
nods=A(1);
x=zeros(nods,1);
y=zeros(nods,1);
indic=zeros(nods,1);

for n=1:nods,
   [A,bytecount]=fscanf(fid,'%f %f %i',[1,3]);
   x(n)=A(1);
   y(n)=A(2);
   indic(n)=A(3);
end

[A,bytecount]=fscanf(fid,'%i',[1]);
n=A(1);
for i=1:n,
   fscanf(fid,'%i %i %f',[1,3]);
end

[A,bytecount]=fscanf(fid,'%i %i',[1,2]);

nel=A(2);
index=zeros(nel,3);

for n=1:nel,
   [A,bytecount]=fscanf(fid,'%i %i %i ',[1,3]);
   index(n,1)=A(1);
	index(n,2)=A(2);
   index(n,3)=A(3);
end

info=zeros(nel,3);
for n=1:nel,
   [A,bytecount]=fscanf(fid,'%i %i %i %i',[1,4]);
   info(n,1)=A(2);
   info(n,2)=A(3);
   info(n,3)=A(4);

end
fclose(fid);

pos=find(info(:,1)>20 | info(:,2)>20 | info(:,3)>20);
element_on_boundary=zeros(nel,1);
element_on_boundary(pos)=1;


node_on_boundary=zeros(nods,1);
pos=find(info~=5);
node_on_boundary(index(pos))=1;
break
eval(['delete D:/programmation/utils/mesh2d.exp']);




