/*!\file exceptions.h
 * \brief: two types of exceptions are handled for now. Errors, and 
 * warnings. Those exceptions are trapped provided the matlab modules 
 * are started using MODULEBOOT, and ended using MODULEEND. These are 
 * macros hiding try, catch statements. This header file defines our 
 * own exceptions
 */

#ifndef MY_EXCEPTIONS_H_
#define MY_EXCEPTIONS_H_

#include <exception>
#include <string>
using namespace std;

/*We derive our classes from the c++ exception class: */
class ErrorException: public exception {
	
	string what_str;
	string function_name;

	public:

	ErrorException(const string &what_function,const string &what_arg);
	~ErrorException() throw();

	virtual const char *what() const throw();

	void Report();


};
	

char* exprintf(char* format,...);
#endif
