function array=SetStructureField(array,name,field,value);
%SETSTRUCTUREFIELD - set structure field
%
%   Go through the elements of an array and a a given value
%   for a given field
%
%   Usage:
%      array=SetStructureField(array,name,field,value)
%
%   See Also: MODELPROCESSOR

if (ischar(value)  | isscalar(value)),
	for n=1:length(array), 
		structure=getfield(array(n),name);
		structure=setfield(structure,field,value);
		array(n)=setfield(array(n),name,structure);
		%array(n).element=SetField(array(n).element,field,value);
	end
else
	for n=1:length(array), 
		structure=getfield(array(n),name);
		structure=setfield(structure,field,value(n,:)');
		array(n)=setfield(array(n),name,structure);
		%array(n).element=SetField(array(n).element,field,value(n,:));
	end
end
