/*  _________________________________________________________________________
 *
 *  EXACT: An Experimental Algorithmics Computational Toolkit.
 *  Copyright (c) 2007, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README file in the top source directory.
 *  _________________________________________________________________________
 */

#include <exception>
#include <signal.h>
#include <limits>
#include <utilib/PM_LCG.h>
#include <utilib/Uniform.h>

int niter=0;

void signal_handler(int sig)
{
std::cerr << "Caught Signal " << sig << std::endl;
niter = 0;
}

using namespace utilib;


double f(double x)
{
return (x-1.0)*(x-1.0)+100;
}


int main(int argc, char* argv[])
{
signal(SIGINT, signal_handler);
signal(SIGTERM, signal_handler);

int seed = atoi(argv[1]);
niter = atoi(argv[5]);
int dosleep =0;
if (argc == 7)
   dosleep = atoi(argv[6]);
PM_LCG rng(seed);
Uniform rnd(&rng);

double proby = atof(argv[4]);
double offset=0.0;
if (rnd()<proby)
   offset = 2.0;

double scale = atof(argv[3]);

double x_min = 1000;
int i=0;

  for (; i<niter; i++) {
    double x;
    if (strcmp("log",argv[2])==0) 
       x = std::log(rnd()*scale+offset);
    else
       x = std::exp(rnd()*scale+offset);
    if (f(x) < f(x_min)) x_min = x;
    }

std::cout << "Point:   " << x_min << std::endl;
std::cout << "Value:   " << f(x_min) << std::endl;
std::cout << "Seed:    " << seed << std::endl;
std::cout << "Proby:   " << proby << std::endl;
std::cout << "Scale:   " << scale << std::endl;
std::cout << "Offset:  " << offset << std::endl;
std::cout << "Niter:   " << i << std::endl;
std::cout << "Mapping: ";
if (strcmp("log",argv[2])==0)
   std::cout << "log" << std::endl;
else
   std::cout << "exp" << std::endl;

//
// To generate an error within valgrind
//
double* dummy = new double;

//
// To ensure that the memory used is detectible by memmon
//
if (dosleep)
   #if defined(MSC_VER) || defined(__MINGW32__)
   _sleep( 1 * 1000);
   #else
   sleep(1);
   #endif

return 0;
}
