/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file colin.h
 *
 * Global header for COLIN.
 */

/**
 * \namespace colin
 *
 * The namespace used to encapsulate classes for the COLIN optimization 
 * library interface.
 */

#include <acro_config.h>
#ifndef colin_colin_h
#define colin_colin_h

#include <colin/AnalysisCode.h>
#include <colin/AppResponseAnalysis.h>
#include <colin/AppResponse.h>
#include <colin/AppResponseInfo.h>
#include <colin/AppResponseLValues.h>
#include <colin/AppResponseTypes.h>
#include <colin/AppResponseValues.h>
#include <colin/BatchEvaluator.h>
#include <colin/BatchPoint.h>
#include <colin/ColinGlobals.h>
#include <colin/ColinUtilib.h>
#include <colin/CommandShell.h>
#include <colin/DirectApplicationBase.h>
#include <colin/DirectFuncApplication.h>
#include <colin/DirectSimpleApplication.h>
#include <colin/DirectUserResponseApplication.h>
#include <colin/ForkCallAnalysisCode.h>
#include <colin/ForkCallApplication.h>
#include <colin/GenericOptSolver.h>
#include <colin/MasterSlaveOptExec.h>
#include <colin/MSApplication.h>
#include <colin/OptApplicationBase.h>
#include <colin/OptApplication.h>
#include <colin/OptDomainTraits.h>
#include <colin/OptProblemAppBody.h>
#include <colin/OptProblemAppHandle.h>
#include <colin/OptProblemAppWrapper.h>
#include <colin/OptProblemFrag_Base.h>
#include <colin/OptProblemFrag_Bounds.h>
#include <colin/OptProblemFrag_IntParams.h>
#include <colin/OptProblemFrag_LinearConstraints.h>
#include <colin/OptProblemFrag_RealParams.h>
#include <colin/OptProblem.h>
#include <colin/OptProblemStateBase.h>
#include <colin/OptProblemState.h>
#include <colin/OptResponse.h>
#include <colin/OptSetup.h>
#include <colin/OptSolverBase.h>
#include <colin/OptSolver.h>
#include <colin/OptSolverHandle.h>
#include <colin/OptSolverWrapperDerived.h>
#include <colin/OptSolverWrapper.h>
#include <colin/real.h>
#include <colin/StatusCodes.h>
#include <colin/StdOptSolver.h>
#include <colin/SysCallAnalysisCode.h>
#include <colin/SysCallApplication.h>
#include <colin/UserResponse.h>
#include <colin/OptPointDB.h>

#endif
