function expcreateprofile(filename);
%EXPCREATEPROFILE - create an Argus file from a list of points
%
%   expcreateprofile: from a list of (x,y) points (retrieve using ginput on an undetermined
%   number of points: used RETURN key to end input), create an Argus .exp 
%   file holding the corresponding open profile.
%    
%   Usage:
%      expcreateprofile(filename)
%
%   See also EXPMASTER, EXPDOC

%Get root of filename
[path root ext ver]=fileparts(filename);

%Get profile
disp('Click on profile points you desire. Type RETURN to end input of points');
[x,y]=ginputquick;

%plot contour
hold on;
plot(x,y,'r-');

%create structure for expwrite routine
a.x=x;
a.y=y;
a.name=root;
a.density=1;

%write profile using expwrite
expwrite(a,filename);
