function md=parameterize(md,parametername)
%PARAMETERIZE - parameterize a model
%
%   from a parameter matlab file, start filling in all the @model fields that were not 
%   filled in by the mesh.m and geography.m @model methods.
%   Warning: the paramter file must be able to be run in Matlab
%
%   Usage:
%      md=parameterize(md,parametername)
%
%   Example:
%      md=parameterize(md,'Square.par');

if md.counter>=4,
	choice=input('This model already has parameters and has been extruded. Are you sure you want to go ahead? (y/n)','s');
	if ~strcmp(choice,'y')
		error('no parameters done ... exiting');
	end
elseif md.counter==3
	disp('This model already has parameters, overwriting...')
else
	if (md.counter~=2)
		error('parameterize error message: you need to run geography.m first on this model');
	else
		md.counter=3;
	end
end

%Try and run parameter file. We try to capture the error message, but this is not allowed for 
%lower versions of matlab.

stringfile=readfile(parametername);
stringlines=strsplit(stringfile,char(10)); %split into lines

for i=1:length(stringlines),
	a=stringlines{i};
	try,
		eval(stringlines{i});
	catch me,
		disp(' ');
		disp(['Error in ==> ' parametername ' at ' num2str(i)]);
		disp(me.message);
		disp(stringlines{i});
		error(' ');
	end
end

%Keep track of parameter file
md.parameterfile=readfile(parametername);

%Name and notes
md.notes=['Model created by using parameter file: ' parametername ' on: ' datestr(now)];
[a,root,c,d]=fileparts(parametername); md.name=root;
