dnl Methods

AC_DEFUN([DAK_METHODS],[
  dnl ACRO package checks.
  AC_ARG_WITH([acro],AS_HELP_STRING([--without-acro],[turn ACRO support off]),
	      [with_acro=$withval],[with_acro=yes])
  if test "x$with_acro" = xyes -a -d $srcdir/methods/acro; then
    case "${host_os}" in
	*aix*)
		AX_CXXFLAGS_AIX_OPTION([-DAIX_CC])dnl AIX-specific Acro code.
	;;
	*irix*)
		AX_CXXFLAGS_IRIX_OPTION([-DSGI_CC])dnl SGI-specific Acro code.
	;;
	*osf*)
		AX_CXXFLAGS_OSF_OPTION([-DOSF_CC])dnl OSF-specific Acro code.
	;;
	*solaris*)
		dnl Solaris-specific Acro code.
		AX_CXXFLAGS_SUN_OPTION([-DSOLARIS_CC])
	;;
	*)
	;;
    esac
    AC_CONFIG_SUBDIRS([methods/acro])
    AC_DEFINE([DAKOTA_3PO],[1],[Macro to handle code which depends on 3PO.])
    AC_DEFINE([DAKOTA_UTILIB],[1],
              [Macro to handle code which depends on UTILIB.])
    AC_DEFINE([DAKOTA_COLINY],[1],
              [Macro to handle code which depends on COLINY.])
    AC_DEFINE([DAKOTA_AMPL],[1],[Macro to handle code which depends on AMPL.])
    AC_DEFINE([USING_3PO],[1],[Macro to handle code which depends on 3PO.])
    MAYBE_ACRO=acro
  else
    MAYBE_ACRO=
  fi
  AC_SUBST([MAYBE_ACRO])
  AM_CONDITIONAL([WITH_ACRO],[test "x$with_acro" = xyes -a \
				   -d $srcdir/methods/acro])

  dnl CONMIN package check.
  AC_ARG_WITH([conmin],AS_HELP_STRING([--without-conmin],
				      [turn CONMIN support off]),
	      [with_conmin=$withval],[with_conmin=yes])
  if test "x$with_conmin" = xyes; then
    AC_CONFIG_SUBDIRS([methods/CONMIN])
    AC_DEFINE([DAKOTA_CONMIN],[1],
	      [Macro to handle code which depends on CONMIN.])
  fi
  AM_CONDITIONAL([WITH_CONMIN],[test "x$with_conmin" = xyes])

  dnl DDACE package check.
  AC_ARG_WITH([ddace],AS_HELP_STRING([--without-ddace],
				     [turn DDACE support off]),
	      [with_ddace=$withval],[with_ddace=yes])
  if test "x$with_ddace" = xyes -a -d $srcdir/methods/DDACE; then
    AC_CONFIG_SUBDIRS([methods/DDACE])
    AC_DEFINE([DAKOTA_DDACE],[1],
	      [Macro to handle code which depends on DDACE.])
    MAYBE_DDACE=DDACE
  else
    MAYBE_DDACE=
  fi
  AC_SUBST([MAYBE_DDACE])
  AM_CONDITIONAL([WITH_DDACE],[test "x$with_ddace" = xyes -a \
				    -d $srcdir/methods/DDACE])

  dnl DL_SOLVER package check.
  AC_ARG_WITH([dl_solver],AS_HELP_STRING([--with-dl_solver],[turn DL_SOLVER support on]),
	      [with_dl_solver=$withval],[with_dl_solver=no])
  if test "x$with_dl_solver" = xyes ; then
    AC_DEFINE([DAKOTA_DL_SOLVER],[1],
	      [Macro to handle code that depends on DL_SOLVER.])
  fi
  AM_CONDITIONAL([WITH_DL_SOLVER],
                 [test "x$with_dl_solver" = xyes ])

  dnl DOT package check.
  AC_ARG_WITH([dot],AS_HELP_STRING([--without-dot],[turn DOT support off]),
	      [with_dot=$withval],[with_dot=yes])
  if test "x$with_dot" = xyes -a \
          -e $srcdir/methods/DOT/dbl_prec/dot1.f; then
    AC_CONFIG_SUBDIRS([methods/DOT])
    AC_DEFINE([DAKOTA_DOT],[1],[Macro to handle code which depends on DOT.])
  fi
  AM_CONDITIONAL([WITH_DOT],
                 [test "x$with_dot" = xyes -a \
                       -e $srcdir/methods/DOT/dbl_prec/dot1.f])

  dnl EVIDENCE package check.
  AC_ARG_WITH([evidence],AS_HELP_STRING([--without-evidence],
					[turn EVIDENCE support off]),
	      [with_evidence=$withval],[with_evidence=yes])
  if test "x$with_evidence" = xyes -a \
          -e $srcdir/methods/Evidence/src/input.f; then
    AC_CONFIG_SUBDIRS([methods/Evidence])
    AC_DEFINE([DAKOTA_EVIDENCE],[1],
	      [Macro to handle code which depends on EVIDENCE.])
  fi
  AM_CONDITIONAL([WITH_EVIDENCE],
                 [test "x$with_evidence" = xyes -a \
                       -e $srcdir/methods/Evidence/src/input.f])

  dnl FSUDACE package check.
  AC_ARG_WITH([fsudace],AS_HELP_STRING([--without-fsudace],
				       [turn FSUDace support off]),
	      [with_fsudace=$withval],[with_fsudace=yes])
  if test "x$with_fsudace" = xyes; then
    AC_DEFINE([DAKOTA_FSUDACE],[1],
	      [Macro to handle code which depends on FSUDACE.])
    AC_CONFIG_SUBDIRS([methods/FSUDace])
  fi
  AM_CONDITIONAL([WITH_FSUDACE],[test "x$with_fsudace" = xyes])

  dnl HOPSPACK/APPSPACK package check.
  AC_ARG_WITH([appspack],AS_HELP_STRING([--without-appspack],
				        [turn APPSPACK support off]),
	      [with_appspack=$withval],[with_appspack=yes])
  if test "x$with_appspack" = xyes -a -d $srcdir/methods/hopspack; then
    AC_CONFIG_SUBDIRS([methods/hopspack])
    AC_DEFINE([DAKOTA_APPS],[1],
	      [Macro to handle code which depends on APPSPACK.])
    MAYBE_APPSPACK=hopspack
  else
    MAYBE_APPSPACK=
  fi
  AC_SUBST([MAYBE_APPSPACK])
  AM_CONDITIONAL([WITH_APPSPACK],[test "x$with_appspack" = xyes -a \
				    -d $srcdir/methods/hopspack])

  dnl JEGA package check.
  AC_ARG_WITH([jega],AS_HELP_STRING([--without-jega],[turn JEGA support off]),
	      [with_jega=$withval],[with_jega=yes])
  if test "x$with_jega" = xyes -a -d $srcdir/methods/JEGA; then
    AC_CONFIG_SUBDIRS([methods/JEGA])
    AC_DEFINE([DAKOTA_JEGA],[1],
	      [Macro to handle code which depends on JEGA.])
    MAYBE_JEGA=JEGA
  else
    MAYBE_JEGA=
  fi
  AC_SUBST([MAYBE_JEGA])
  AM_CONDITIONAL([WITH_JEGA],[test "x$with_jega" = xyes -a \
				    -d $srcdir/methods/JEGA])

  dnl NCSUOpt package check.
  AC_ARG_WITH([ncsu],AS_HELP_STRING([--without-ncsu],
				    [turn NCSUOpt support off]),
	      [with_ncsu=$withval],[with_ncsu=yes])
  if test "x$with_ncsu" = xyes; then
    AC_CONFIG_SUBDIRS([methods/NCSUOpt])
    AC_DEFINE([DAKOTA_NCSU],[1],
	      [Macro to handle code which depends on NCSUOpt.])
  fi
  AM_CONDITIONAL([WITH_NCSU],
                 [test "x$with_ncsu" = xyes])

  dnl NL2SOL package check.
  AC_ARG_WITH([nl2sol],AS_HELP_STRING([--without-nl2sol],
				      [turn NL2SOL support off]),
	      [with_nl2sol=$withval],[with_nl2sol=yes])
  if test "x$with_nl2sol" = xyes; then
    AC_CONFIG_SUBDIRS([methods/NL2SOL])
    AC_DEFINE([DAKOTA_NL2SOL],[1],
    	      [Macro to handle code which depends on NL2SOL.])
  fi
  AM_CONDITIONAL([WITH_NL2SOL],[test "x$with_nl2sol" = xyes])

  dnl NLPQL package check.
  AC_ARG_WITH([nlpql],AS_HELP_STRING([--with-nlpql],[turn NLPQL support on]),
	      [with_nlpql=$withval],[with_nlpql=no])
  if test "x$with_nlpql" = xyes -a \
	  -e $srcdir/methods/NLPQL/NLPQLP20.f; then
    AC_CONFIG_SUBDIRS([methods/NLPQL])
    AC_DEFINE([DAKOTA_NLPQL],[1],
	      [Macro to handle code which depends on NLPQL.])
  fi
  AM_CONDITIONAL([WITH_NLPQL],
                 [test "x$with_nlpql" = xyes -a \
	               -e $srcdir/methods/NLPQL/NLPQLP20.f])

  dnl NPSOL package check.
  AC_ARG_WITH([npsol],AS_HELP_STRING([--without-npsol],
				     [turn NPSOL support off]),
	      [with_npsol=$withval],[with_npsol=yes])
  if test "x$with_npsol" = xyes -a \
          -e $srcdir/methods/NPSOL/npsolsubs.f; then
    AC_CONFIG_SUBDIRS([methods/NPSOL])
    AC_DEFINE([DAKOTA_NPSOL],[1],
    [Macro to handle code which depends on NPSOL.])
  fi
  AM_CONDITIONAL([WITH_NPSOL],
                 [test "x$with_npsol" = xyes -a \
                       -e $srcdir/methods/NPSOL/npsolsubs.f])

  dnl OPTPP package check.
  AC_ARG_WITH([optpp],AS_HELP_STRING([--without-optpp],
				     [turn OPTPP support off]),
	      [with_optpp=$withval],[with_optpp=yes])
  if test "x$with_optpp" = xyes -a -d $srcdir/methods/OPTPP; then
    AC_CONFIG_SUBDIRS([methods/OPTPP])
    AC_DEFINE([DAKOTA_OPTPP],[1],
	      [Macro to handle code which depends on OPTPP.])
    AC_DEFINE([DAKOTA_NEWMAT],[1],
	      [Macro to handle code which depends on NEWMAT.])
    MAYBE_OPTPP=OPTPP
  else
    MAYBE_OPTPP=
  fi
  AC_SUBST([MAYBE_OPTPP])
  AM_CONDITIONAL([WITH_OPTPP],[test "x$with_optpp" = xyes -a \
				    -d $srcdir/methods/OPTPP])
  dnl PSUADE package check.
  AC_ARG_WITH([psuade],AS_HELP_STRING([--with-psuade],
				      [turn PSUADE support on]),
	      [with_psuade=$withval],[with_psuade=no])
  if test "x$with_psuade" = xyes -a \
          -e $srcdir/methods/PSUADE/MOATSampling.cpp; then
    if test -z "${WITH_GSL_TRUE}"; then
      AC_CONFIG_SUBDIRS([methods/PSUADE])
      AC_DEFINE([DAKOTA_PSUADE],[1],
      	        [Macro to handle code which depends on PSUADE.])
    else
      AC_MSG_NOTICE([PSUADE cannot be configured without GSL. Automatically
		     configuring --without-psuade.])
    fi
  fi
  AM_CONDITIONAL([WITH_PSUADE],
                 [test "x$with_psuade" = xyes -a \
                       -z "${WITH_GSL_TRUE}" -a \
	               -e $srcdir/methods/PSUADE/MOATSampling.cpp])

  dnl check for isfinite
  AC_COMPILE_IFELSE([
	#include <cmath>
	#include <cfloat>
	#include <iostream>	// Sun's CC surprisingly includes math.h
	int foo(double x) { return isfinite(x); }
],AC_DEFINE([Isfinite],[isfinite],[Simplest case of isfinite.]),AC_COMPILE_IFELSE([
	#include <cmath>
	#include <cfloat>
	#include <iostream>	// Sun's CC surprisingly includes math.h
	int foo(double x) { return std::isfinite(x); }
],AC_DEFINE([Isfinte],[std::isfinite],[Namespace std version of isfinite.]),
	AC_DEFINE([DAKOTA_NEED_Isfinite],[1],[Indicate we need to provide isfinite().])))

])
