/*!\file:  GaussPoints.h
 * \brief
 */ 

#ifndef _GAUSSPOINTS_H
#define _GAUSSPOINTS_H


#define    MAX_LINE_GAUS_PTS    4

int GaussLegendre( double** pxgaus,
				   double** pxwgt,
				   int ngaus );

#define    MAX_LINE_GLOB_PTS    5

int GaussLobatto( double** pxgaus,
				  double** pxwgt,
				  int ngaus );

#define MAX_GAUS_ITER   30

int GaussRecur( double* zero,
				double* weight,
				int n,
				double* alpha,
				double* beta );

int GaussQuad( double** pxgaus,
			   double** pxwgt,
			   double** pegaus,
			   double** pewgt,
			   int nigaus,
			   int njgaus );

#define    MAX_TRIA_SYM_ORD    20

int GaussTria( int* pngaus,
			   double** pl1,
			   double** pl2,
			   double** pl3,
			   double** pwgt,
			   int iord );

int GaussHexa( double** pxgaus,
			   double** pxwgt,
			   double** pegaus,
			   double** pewgt,
			   double** pzgaus,
			   double** pzwgt,
			   int nigaus,
			   int njgaus,
			   int nkgaus );

int GaussPenta( int* pngaus,
				double** pl1,
				double** pl2,
				double** pl3,
				double** pwgt,
				double** pzgaus,
				double** pzwgt,
				int iord,
				int nkgaus );

#define    MAX_TETRA_SYM_ORD    6

int GaussTetra( int* pngaus,
				double** pl1,
				double** pl2,
				double** pl3,
				double** pl4,
				double** pwgt,
				int iord );
void GaussSegment(double** psegment_coord,double** pgauss_weights,int num_gauss);

#endif

