function LaunchQueueJobcosmos(md,executionpath)
%LAUNCHQUEUEJOBCOSMOS - ...
%
%   Usage:
%      LaunchQueueJobcosmos(md,executionpath)

%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobcosmos error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobcosmos error message: queueing script issing, cannot go forward');
end

%Some special handling here! We could not get lsf to work through ssh, there is always something going badly 
%in terms of environment variables not being correctly setup. This is due to the fact the ssh does not use a loging 
%shell! What we therefore did, is figure out every variable setup in a login shell ( you can find it out by typing 
%export in a login bash shell). Instead of trying to figure out which path variable is not being correctly setup, 
%we just dump the export command result into a file, which we source before launching our job. This ensures we replicate 
%exactly the state of a login shell, through ssh.
cosmosvariableslocation=which('cosmosvariables.sh');
if isempty(cosmosvariableslocation),
	error('LaunchQueueJobcosmos error message: could not find environment variables for cosmos cluster!');
end

%now upload both files to cluster
disp('uploading input file,  queueing script and variables script');
eval(['!scp ' md.name '.bin' ' ' md.name '.queue ' cosmosvariableslocation ' ' md.cluster ':' executionpath]);

disp('launching solution sequence on remote cluster');
%now call the queuing script to launch the job.
system(['ssh  ' md.cluster ' ''cd ' executionpath ' && source ./cosmosvariables.sh && bsub <  ' md.name '.queue  && rm cosmosvariables.sh ''']);
