function plot_section(md,data,options_structure,width,i)
%PLOT_SECTION - plot a given field on a section
%
%   Usage:
%      plot_section(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%How many subplots?
if strcmpi(options_structure.showsection,'yes')

	%Compute the indexes of the 2 plots (one for the sectionvalue and one for showsection
	upperplots=fix((i-1)/width);
	if upperplots==0, leftplots=i-1; else leftplots=i-width*upperplots-1; end
	index1=4*width*upperplots+2*leftplots+1;
	index2=index1+1;
	width=2*width;
else
	index1=i;
end

%check on arguments
if (iscell(data) | isempty(data)),
	error('plot error message: data provided is empty');
end
if md.numberofgrids==size(md.elements,1),
	error('plot error message: the number of elements is the same as the number of grids! cannot plot anything with model/plot, use matlab/plot instead')
end

%smoothing?
if strcmpi(options_structure.smooth,'yes') & length(data)==md.numberofelements
	data=elementstogrids(md,data);
end

%layer projection? 
if ~isnan(options_structure.layer) & options_structure.layer>=1,
	data=project2d(md,data,options_structure.layer); %project onto 2d mesh
	%we modify the mesh temporarily to a 2d mesh from which the 3d mesh was extruded. 
	md.x=md.x2d;
	md.y=md.y2d;
	md.z=md.z2d;
	md.elements=md.elements2d;
	md.elements_type=md.elements_type2d;
	md.type='2d';
end

%units
if ~isnan(options_structure.unitmultiplier),
	md.x=md.x*options_structure.unitmultiplier;
	md.y=md.y*options_structure.unitmultiplier;
	md.z=md.z*options_structure.unitmultiplier;
end

%resolution
if ~isnan(options_structure.resolution),
	resolution=options_structure.resolution;
else %Default resolution
	resolution=[1000 10*md.numlayers];
	disp(['plot_section warning: no resolution specified, use default resolution: [horizontal_resolution vertical_resolution]=[' num2str(resolution)  ']']);
end

%Compute section value
[elements,x,y,z,s,data]=SectionValues(md,data,options_structure.sectionvalue,resolution);

if strcmpi(md.type,'2d')
	%plot section value
	subplot(width,width,index1)
	plot(s,data)
else
	%plot section value
	%if user requested view2: 2d plot with curvilinear coordinate
	if (~isnan(options_structure.view) & options_structure.view==2 )
		subplot(width,width,index1)
		A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
		patch( 'Faces', [A B C D], 'Vertices', [s z zeros(length(s),1)],'FaceVertexCData',data,'FaceColor','interp','EdgeColor','none');
	else
		subplot(width,width,index1)
		A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
		patch( 'Faces', [A B C D], 'Vertices', [x y z],'FaceVertexCData',data,'FaceColor','interp','EdgeColor','none');
		view(3)
	end
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Section value';
end 
if isnan(options_structure.colorbar) & strcmpi(md.type,'2d')
	options_structure.colorbar=0;
end
if isnan(options_structure.xlabel) & (strcmpi(md.type,'2d') | options_structure.view==2 )
	options_structure.xlabel='Curvilinear coordinate';
end
if isnan(options_structure.ylabel) & (strcmpi(md.type,'3d') & options_structure.view==2 )
	options_structure.ylabel='z';
end
applyoptions(md,[],options_structure);

%plot section if requested by user
if strcmpi(options_structure.showsection,'yes')
	subplot(width,width,index2)
	hold on
	text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
	text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
	plot(x,y)
	axis([min(md.x) max(md.x) min(md.y) max(md.y)])
	view(2)
end
