/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        global_defs
//- Description:  Global object initializations and global function
//-               implementations
//- Owner:        Mike Eldred

#include "system_defs.h"
//#include "data_types.h"
#include "global_defs.h"
#include "ParamResponsePair.H"
#include "PRPCache.H"
#include "DakotaBinStream.H"
#include "DakotaGraphics.H"
#include "ParallelLibrary.H"
#include "ProblemDescDB.H"

#ifdef HAVE_AIX_MPI
// AIX POE utility function header needed for pm_child_sig_handler call below.
#include <pm_util.h>
#endif

static const char rcsId[]="@(#) $Id: global_defs.C 4860 2008-02-06 04:46:49Z wjbohnh $";


namespace Dakota {

#ifdef DAKOTA_NEED_Isfinite //{
int Isfinite(const Real &x)
{
  static int Kase = 2;
  typedef union { unsigned int u[2]; Real d; } U;
  U u;

  switch(Kase) {
  case 2:	// must configure
    if (sizeof(Real) != 8 || sizeof(unsigned int) != 4) {
      Cerr << "Isfinite configuration: expected sizeof(Real) == 8" << endl;
      Cerr << "and sizeof(unsigned int) == 4, but got " << sizeof(Real)
	   << " and " << sizeof(unsigned int) << endl;
      abort_handler(-1);
    }
    u.d = 1.;
    if (u.u[0] == 0x3ff00000 && u.u[1] == 0) {
      Kase = 0;
      break;
    }
    if (u.u[1] == 0x3ff00000 && u.u[0] == 0) {
      Kase = 1;
      break;
    }
    Cerr << "Isfinite configuration:  unexpected double format." << endl;
    abort_handler(-1);
  }
  return (((U*)&x)->u[Kase] & 0x7ff00000) != 0x7ff00000;
}
#endif //} DAKOTA_NEED_Isfinite

// --------------------------
// Instantiate global objects
// --------------------------
ostream* dakota_cout = &cout; ///< DAKOTA stdout initially points to cout, but
                              ///< may be redirected to a tagged ofstream if
                              ///< there are concurrent iterators.
ostream* dakota_cerr = &cerr; ///< DAKOTA stderr initially points to cerr, but
                              ///< may be redirected to a tagged ofstream if
                              ///< there are concurrent iterators.
PRPCache data_pairs;          ///< contains all parameter/response pairs.
BoStream write_restart;       ///< the restart binary output stream (doesn't
                              ///< really need to be global anymore except for
                              ///< abort_handler()).
Graphics dakota_graphics;     ///< the global Dakota::Graphics object used by
                              ///< strategies, models, and approximations
int write_precision = 10;     ///< used in ostream data output functions
                              ///< (restart_util.C overrides this default value)
ParallelLibrary dummy_lib(0); ///< dummy ParallelLibrary object used for
                              ///< mandatory reference initialization when a
                              ///< real ParallelLibrary instance is unavailable
ProblemDescDB dummy_db;       ///< dummy ProblemDescDB object used for
                              ///< mandatory reference initialization when a
                              ///< real ProblemDescDB instance is unavailable
#ifdef DAKOTA_MODELCENTER
int mc_ptr_int = 0;           ///< global pointer for ModelCenter API
#endif // DAKOTA_MODELCENTER


// -----------------------
// Define global functions
// -----------------------
void abort_handler(int code)
{
//
// WEH - uncomment this code if you want signals to generate a corefile.  This is handy 
//       for debugging infinite loops ... which can be difficult to debug within GDB.
//
//abort();

  if (code > 1) // code = 2 (Cntl-C signal), 0 (normal), & -1/1 (abnormal)
    Cout << "Signal Caught!" << endl;

  // Clean up
  Cout << flush; // flush cout or ofstream redirection
  Cerr << flush; // flush cerr or ofstream redirection
  write_restart.close();

  // Abort the process(es)
#ifdef HAVE_MPI // call MPI_Abort if MPI is initialized and size > 1
#ifdef HAVE_AIX_MPI
  // AIX POE utility function for signal handling w/MPI to exit normally.
  pm_child_sig_handler(code,NULL,NULL);
#endif
  int initialized = 0;
  MPI_Initialized(&initialized);
  if (initialized) {
    //int size;
    //MPI_Comm_size(MPI_COMM_WORLD, &size);
    //if (size>1) {
      // MPICH already instruments the abort with "[rank] Message"
      //int rank;
      //MPI_Comm_rank(MPI_COMM_WORLD, &rank);
      //Cerr << "Processor rank " << rank << " calling MPI_Abort." << endl;
      MPI_Abort(MPI_COMM_WORLD, code);
    //}
    //else
    //  exit(code);
  }
  else
    exit(code);
#else
  exit(code); // or exit(EXIT_FAILURE) from /usr/include/stdlib.h
#endif // HAVE_MPI
}

} // namespace Dakota
