%
%  definition for the response_function class.
%
%  [rf]=response_function(varargin)
%
classdef response_function
    properties
        descriptor='';
        respl     =[];
        probl     =[];
        rell      =[];
        grell     =[];
    end
    
    methods
        function [rf]=response_function(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if  (nargin == 1) && isa(varargin{1},'response_function')
                        rf=varargin{1};
                    else
                        rf.descriptor=varargin{1};

                        if (nargin >= 2)
                            rf.respl     =varargin{2};
                            if (nargin >= 3)
                                rf.probl     =varargin{3};
                                if (nargin >= 4)
                                    rf.rell      =varargin{4};
                                    if (nargin >= 5)
                                        rf.grell     =varargin{5};

                                        if (nargin > 5)
                                            warning('response_function:extra_arg',...
                                                'Extra arguments for object of class ''%s''.',...
                                                class(rf));
                                        end
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =dresp_desc(rf)
            desc=cell(size(rf));
            for i=1:numel(rf)
                desc(i)=cellstr(rf(i).descriptor);
            end
        end
        function [stype ]=dresp_stype(rf)
            stype={};
        end
        function [scale] =dresp_scale(rf)
            scale=[];
        end
        function [weight]=dresp_weight(rf)
            weight=[];
        end
        function [lower] =dresp_lower(rf)
            lower=[];
        end
        function [upper] =dresp_upper(rf)
            upper=[];
        end
        function [target]=dresp_target(rf)
            target=[];
        end
        function [respl,probl,rell,grell]=dresp_levels(rf)
            respl=cell(size(rf));
            probl=cell(size(rf));
            rell =cell(size(rf));
            grell=cell(size(rf));
            for i=1:numel(rf)
                respl(i)={rf(i).respl};
                probl(i)={rf(i).probl};
                rell (i)={rf(i).rell};
                grell(i)={rf(i).grell};
            end
            respl=allempty(respl);
            probl=allempty(probl);
            rell =allempty(rell);
            grell=allempty(grell);
        end
    end
end
