function BuildQueueingScriptcosmos(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTCOSMOS - build queueing script for batch system when running parallel
%
%   solutiontype is 'diagnostic','prognostic','transient','thermalsteady','thermaltransient','parameters' or 'control'
%   and varargin is an optional package name ('cielo', 'ice' or 'macayeal')
%
%   Usage:
%       md=solve(md,solutiontype,varargin)
%
%   Examples:
%      md=solve(md,'diagnostic','macayeal');
%

function BuildQueueingScriptcosmos(md,solutiontype,executionpath,codepath)
%BUILDQUEUEINGSCRIPTCOSMOS - ...
%
%   Usage:
%      BuildQueueingScriptcosmos(md,executionpath,codepath)

scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptcosmoserror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'#BSUB -n %i -W %i\n',md.np,md.time);
if md.exclusive,
	fprintf(fid,'#BSUB -x\n');
end
fprintf(fid,'#BSUB -a mpich_gm\n');
fprintf(fid,'#BSUB -J %s\n',md.name);
fprintf(fid,'#BSUB -o %s.outlog -e %s.errlog\n',md.name,md.name);
fprintf(fid,'cd %s\n',executionpath);
fprintf(fid,'rm -rf %s.outlog %s.errlog %s.lock\n',md.name,md.name,md.name);
if md.alloc_cleanup,
	fprintf(fid,'mpirun.lsf /home/larour/bin/alloc_cleanup.exe\n');
end
if strcmpi(solutiontype,'diagnostic_horiz') |  strcmpi(solutiontype,'diagnostic'),
	fprintf(fid,'mpirun.lsf %s/diagnostic.exe %s %s.bin %s.outbin %s.lock',codepath,executionpath,md.name,md.name,md.name);
elseif strcmpi(solutiontype,'control') ,
	fprintf(fid,'mpirun.lsf %s/control.exe %s %s.bin %s.outbin %s.lock',codepath,executionpath,md.name,md.name,md.name);
elseif strcmpi(solutiontype,'thermalsteady') ,
	fprintf(fid,'mpirun.lsf %s/thermalsteady.exe %s %s.bin %s.outbin %s.lock',codepath,executionpath,md.name,md.name,md.name);
else
	error('BuildQueueingScriptcosmso error message: unsupported solution type!');
end
fclose(fid);
