*   _______________________________________________________________________
*
*   DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
*   Copyright (c) 2006, Sandia National Laboratories.
*   This software is distributed under the GNU General Public License.
*   For more information, see the README file in the top Dakota directory.
*   _______________________________________________________________________
*
c    This code was written to filter time history stress data and has an 
c    option to average and filter the data from a selected group of elements.
c
c    The input data containing the raw data is in a neutral file written from 
c    BLOT (xmgr.neu). The number of elements from which data is being filtered 
c    is read from another file (numelm.dat).
c
c    Modified by Mike Eldred for use in the DAKOTA system, 1/23/95.
c    Simplified (fewer arrays) and max array size lengthened, 5/2/95.
c
      character*72 line
      integer      numdat, order, numelm
      real         time, sig, y(500000), alpha, maxsig, avg(500000),
     +             sigbar, g_sig
c
c      open(unit=12,file='sigfil.dat')
c      open(unit=13,file='maxsig.dat')
c
c    Read the number of elements from which data is being read and filtered
c    and the prescibed upper bound on maximum stress (for constraint evaluation)
c
c     nominal: numelm=4, sigbar=23000, order=1, alpha=0.5
      open(unit=10,file='fildata.dat')
      read(10,*) numelm
      read(10,*) sigbar
      read(10,*) order
      read(10,*) alpha
      close(10)
c
      if( numelm .lt. 1 ) then
         write(*,*)'Error - incorrect number of elements specified'
         stop
      endif       
c
      do 1 i = 1, 500000
         avg(i) = 0.0 
 1    continue
c
      open(unit=11,file='xmgr.neu')
c
      do 10 i=1,17
         read(11,100)line
c         write(*,*)line
 10   continue
c
      do 30 j= 1, numelm
c
         do 20 i = 1, 500000
            read( 11, 110, err=999, end=999 ) time, sig
c            write(*,*) i, time, sig
            avg(i) = avg(i) + sig/numelm
 20      continue
c
c NOTE: Only final numdat is correct; preceding numdat's are 1 too high 
c       due to blank line separating stress histories.
 999     numdat = i - 1
c         write (*,*) i, 'numdat =', numdat
c
         if (j .lt. numelm) then
c
           do 25 i=1, 7
             read(11,100)line
c             write(*,*)line
 25        continue
c
         endif
c
 30   continue
      close(11)
c
c ------- END DATA CAPTURE & AVERAGING, BEGIN FILTERING -------
c
      maxsig = 0.0
c
c start-up:
c
      y(1) = avg(1)
      y(2) = alpha*avg(2) + (1-alpha)*y(1)
c
      do 40 i = 3, numdat
c
        if (order .eq. 1) then
c
           y(i) = alpha*avg(i) + (1-alpha)*y(i-1)
c
        elseif (order .eq. 2) then
c
           y(i) = alpha**2 * avg(i) + 2.0 * ( 1.0 - alpha ) * y(i-1)
     +            - ( 1.0 - alpha )**2 * y(i-2)
c
        endif
c
        if (abs(y(i)).gt.maxsig) then
           maxsig=abs(y(i))
        endif
c
 40   continue
c
c      write(*,*) maxsig
c Stress constraint: g = [(max. sigyy) - (sigma bar)]/(sigma bar) <= 0.
      g_sig=(maxsig-sigbar)/sigbar
      write(*,200) g_sig
c
 100  format(a72)
 110  format(e14.11,e19.15)
 120  format(a20,e12.4,a20,i4,a10,i4)
c 130  format(1h ,e14.7,3i6)
c 140  format(1h ,'min sigyy,  element,  step,  max. step')
c 150  format(f14.11,1h ,e17.11, 1h ,e17.11)
 200  format(f13.10)
      stop 
      end
