(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21972,        671]*)
(*NotebookOutlinePosition[     22604,        693]*)
(*  CellTagsIndexPosition[     22560,        689]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
DAKOTA
User's Manual Graphics
Chapter 2 - Tutorial
Created by S.L. Brown, 20 June 2006\
\>", "Title"],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell["\<\
Set the working directory to the directory that this checked out \
copy of tutorial-image-generator.nb is in.\
\>", "Text"],

Cell[BoxData[
    \(\(SetDirectory[
        ToFileName[
          Extract["\<FileName\>" /. 
              NotebookInformation[EvaluationNotebook[]], {1}, 
            FrontEnd`FileName]]];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rosenbrock's Function", "Section"],

Cell[CellGroupData[{

Cell["Visualization", "Subsection"],

Cell[BoxData[
    \(rosen[x_, y_] := 100\ \((y - x^2)\)^2 + \((1 - x)\)^2\)], "Input"],

Cell[BoxData[
    \(rosensurf = 
      Plot3D[rosen[x, y], {x, \(-2\), 2}, {y, \(-2\), 
          2}, \[IndentingNewLine]AxesLabel \[Rule] {x\_1, 
            x\_2\ , "\<\>"}, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotRange \[Rule] {0, 
            4000}, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(rosencont = 
      ContourPlot[
        rosen[x, y], {x, \(-2\), 2}, {y, \(-2\), 
          2}, \[IndentingNewLine]Contours \[Rule] 
          40, \[IndentingNewLine]ContourShading \[Rule] 
          False, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotPoints \[Rule] 
          50, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Parameter Studies", "Subsection"],

Cell[CellGroupData[{

Cell["2-D Parameter Study Data", "Subsubsection"],

Cell[BoxData[
    \(\(data2d = 
        Import["\<../../tutorial/Examples/2d.out.sav\>", "\<Table\>"];\)\)], \
"Input"],

Cell[BoxData[
    \(\(data2dPTS = 
        Transpose[{First /@ Select[data2d, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[data2d, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(plot2dPTS = 
      ListPlot[data2dPTS, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(rosen2dpts = 
      Show[rosencont, 
        plot2dPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Vector Parameter Study Data", "Subsubsection"],

Cell[BoxData[
    \(\(datavec = 
        Import["\<../../tutorial/Examples/vector.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(datavecPTS = 
        Transpose[{First /@ Select[datavec, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[datavec, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(plotvecPTS = 
      ListPlot[datavecPTS, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(rosenvectpts = 
      Show[rosencont, 
        plotvecPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Optimization", "Subsection"],

Cell[CellGroupData[{

Cell["Gradient-based Unconstrained Optimization", "Subsubsection"],

Cell[BoxData[
    \(\(datauncon = 
        Import["\<../../tutorial/Examples/grad_opt.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(dataunconPTS = 
        Rest /@ Select[datauncon, 
            MatchQ[#, {"\<1)\>", _, _}] &];\)\)], "Input"],

Cell["\<\
We're only taking the data after the first three points (line \
search).\
\>", "Text"],

Cell[BoxData[
    \(plotunconPTS = 
      ListPlot[Take[
          dataunconPTS, \(-\((Length[dataunconPTS] - 
                3)\)\)], \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(rosenunconpts = 
      Show[rosencont, 
        plotunconPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Nongradient-based Optimization via Pattern Search", "Subsubsection"],

Cell[BoxData[
    \(\(dataps = 
        Import["\<../../tutorial/Examples/ps_opt.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(datapsPTS = 
        Transpose[{First /@ Select[dataps, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[dataps, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(plotpsPTS = 
      ListPlot[datapsPTS, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(rosenpspts = 
      Show[rosencont, 
        plotpsPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(rosencontclose = 
      ContourPlot[
        rosen[x, y], {x, \(-0.5\), 0.5}, {y, \(-0.5\), 
          0.5}, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]Contours \[Rule] 
          40, \[IndentingNewLine]ContourShading \[Rule] 
          False, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotPoints \[Rule] 
          50, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(plotpsPTSclose = 
      ListPlot[Select[Select[datapsPTS, First[#] < 0.5 &], 
          Last[#] < 0.5 &], \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(rosenpsptsclose = 
      Show[rosencontclose, 
        plotpsPTSclose, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Nongradient-based Optimization via Evolutionary Algorithm", \
"Subsubsection"],

Cell[BoxData[
    \(\(dataea = 
        Import["\<../../tutorial/Examples/ea_opt.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(dataeaPTS = 
        Transpose[{First /@ Select[dataea, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[dataea, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(ploteaPTSinit = 
      ListPlot[Take[dataeaPTS, 50], \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(ploteaPTSfinal = 
      ListPlot[Take[dataeaPTS, \(-50\)], \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(roseneaptsinit = 
      Show[rosencont, 
        ploteaPTSinit, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(roseneaptsfinal = 
      Show[rosencont, 
        ploteaPTSfinal, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Sampling", "Subsection"],

Cell[CellGroupData[{

Cell["Monte Carlo", "Subsubsection"],

Cell[BoxData[
    \(\(datamc = 
        Import["\<../../tutorial/Examples/nond.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(datamcPTS = 
        Transpose[{First /@ Select[datamc, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[datamc, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(plotmcPTS = 
      ListPlot[datamcPTS, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(rosencontmcPTS = 
      Show[rosencont, 
        plotmcPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Textbook Function", "Section"],

Cell[CellGroupData[{

Cell["Visualization", "Subsection"],

Cell[BoxData[
    \(textbook[x_, y_] := \((x - 1)\)\^4 + \((y - 1)\)\^4\)], "Input"],

Cell[BoxData[
    \(g1[t_] := {t\/4, t\^2\/8}\)], "Input"],

Cell[BoxData[
    \(g2[t_] := {t\^2\/8, t\/4}\)], "Input"],

Cell[BoxData[
    \(textbookcont = 
      ContourPlot[
        textbook[x, y], {x, \(-3\), 4}, {y, \(-3\), 
          4}, \[IndentingNewLine]Contours \[Rule] 
          50, \[IndentingNewLine]ContourShading \[Rule] 
          False, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotPoints \[Rule] 
          50, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(g1param = 
      ParametricPlot[
        g1[t], {t, \(-Sqrt[32]\), 
          Sqrt[32]}, \[IndentingNewLine]PlotStyle \[Rule] {{Thickness[
                0.015]}}]\)], "Input"],

Cell[BoxData[
    \(g2param = 
      ParametricPlot[
        g2[t], {t, \(-Sqrt[32]\), 
          Sqrt[32]}, \[IndentingNewLine]PlotStyle \[Rule] {{Thickness[0.015], 
              Dashing[{0.05, 0.05}]}}]\)], "Input"],

Cell[BoxData[
    \(tbconscont = 
      Show[textbookcont, g1param, 
        g2param, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]Frame \[Rule] 
          True, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(textbookconscontclose = 
      ContourPlot[
        textbook[x, y], {x, \(-1\), 1}, {y, \(-1\), 
          1}, \[IndentingNewLine]Contours \[Rule] 
          50, \[IndentingNewLine]ContourShading \[Rule] 
          False, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotPoints \[Rule] 
          50, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"],

Cell[BoxData[
    \(g1paramclose = 
      ParametricPlot[
        g1[t], {t, \(-Sqrt[8]\), 
          Sqrt[8]}, \[IndentingNewLine]PlotStyle \[Rule] {{Thickness[
                0.015]}}]\)], "Input"],

Cell[BoxData[
    \(g2paramclose = 
      ParametricPlot[
        g2[t], {t, \(-Sqrt[8]\), 
          Sqrt[8]}, \[IndentingNewLine]PlotStyle \[Rule] {{Thickness[0.015], 
              Dashing[{0.05, 0.05}]}}]\)], "Input"],

Cell[BoxData[
    \(tbconscontclose = 
      Show[textbookconscontclose, g1paramclose, 
        g2paramclose, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]Frame \[Rule] 
          True, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Optimization", "Subsection"],

Cell[CellGroupData[{

Cell["Gradient-based Constrained Optimization", "Subsubsection"],

Cell[BoxData[
    \(\(datatbcon = 
        Import["\<../../tutorial/Examples/textbook.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(datatbconPTS = 
        Transpose[{First /@ Select[datatbcon, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[datatbcon, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(plottbconPTS = 
      ListPlot[datatbconPTS, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
              0.03]}]\)], "Input"],

Cell[BoxData[
    \(tbconsoptcont = 
      Show[textbookcont, g1param, g2param, 
        plottbconPTS, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]Frame \[Rule] 
          True, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}]\)], "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Uncertainty Quantification", "Section"],

Cell[BoxData[
    \(<< Graphics`MultipleListPlot`\)], "Input"],

Cell[CellGroupData[{

Cell["Sampling", "Subsection"],

Cell[BoxData[
    \(\(lhsgraphicdata = \(data = {{0.2, 0.2}, {0.7, 0.3}, {0.8, 0.7}, {0.3, 
              0.9}}\);\)\)], "Input"],

Cell[BoxData[
    \(\(data10lhssamples = 
        Import["\<../../tutorial/Examples/uq_users_0.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(data5lhssamples = 
        Import["\<../../tutorial/Examples/uq_users_1.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(data10randomsamples = 
        Import["\<../../tutorial/Examples/uq_users_2.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(data5randomsamples = 
        Import["\<../../tutorial/Examples/uq_users_3.out.sav\>", \
"\<Table\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(lhsgraphicPTS\  = \ 
        ListPlot[
          data, \[IndentingNewLine]AspectRatio \[Rule] 
            1, \[IndentingNewLine]Axes \[Rule] 
            False, \[IndentingNewLine]AxesOrigin \[Rule] {0, 
              0}, \[IndentingNewLine]Frame \[Rule] 
            True, \[IndentingNewLine]GridLines \[Rule] {Table[
                0.25\ i, {i, 0, 4}], 
              Table[0.25\ i, {i, 0, 
                  4}]}, \[IndentingNewLine]FrameLabel \[Rule] {x\_1, 
              x\_2}, \[IndentingNewLine]FrameTicks \[Rule] {{0, 1}, {0, 1}, 
              None, None}, \[IndentingNewLine]ImageSize \[Rule] 
            600, \[IndentingNewLine]PlotRange \[Rule] {{0, 1}, {0, 
                1}}, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
                0.03]}, \[IndentingNewLine]RotateLabel \[Rule] 
            False, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> \
"\<Times\>", FontSize \[Rule] 24}];\)\)], "Input"],

Cell[BoxData[
    \(\(data10lhsPTS = 
        Transpose[{First /@ 
              Select[data10lhssamples, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[data10lhssamples, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(\(data5lhsPTS = 
        Transpose[{First /@ 
              Select[data5lhssamples, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[data5lhssamples, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(\(data10randomPTS = 
        Transpose[{First /@ 
              Select[data10randomsamples, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[data10randomsamples, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(\(data5randomPTS = 
        Transpose[{First /@ 
              Select[data5randomsamples, MatchQ[#, {_, "\<x1\>"}] &], 
            First /@ Select[data5randomsamples, 
                MatchQ[#, {_, "\<x2\>"}] &]}];\)\)], "Input"],

Cell[BoxData[
    \(plot5uqPTS = 
      MultipleListPlot[data5lhsPTS, 
        data5randomPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]Frame \[Rule] 
          True, \[IndentingNewLine]FrameLabel \[Rule] {x\_1, 
            x\_2\ }, \[IndentingNewLine]GridLines \[Rule] 
          Automatic, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotLabel -> "\<samples = 5\>", \
\[IndentingNewLine]PlotRange \[Rule] {{0, 1}, {0, 
              1}}, \[IndentingNewLine]RotateLabel \[Rule] 
          False, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> "\<Times\
\>", FontSize \[Rule] 
              24}, \[IndentingNewLine]SymbolShape \[Rule] \
{MakeSymbol[{Line[{{5, 0}, {\(-5\), 0}}], Line[{{0, 5}, {0, \(-5\)}}]}], 
            PlotSymbol[Triangle, 8, Filled \[Rule] False]}]\)], "Input"],

Cell[BoxData[
    \(plot10uqPTS = 
      MultipleListPlot[data10lhsPTS, 
        data10randomPTS, \[IndentingNewLine]AspectRatio \[Rule] 
          1, \[IndentingNewLine]Axes \[Rule] 
          False, \[IndentingNewLine]Frame \[Rule] 
          True, \[IndentingNewLine]FrameLabel \[Rule] {x\_1, 
            x\_2\ }, \[IndentingNewLine]FrameTicks \[Rule] 
          Automatic, \[IndentingNewLine]GridLines \[Rule] {Table[
              0.1\ i, {i, 0, 10}], 
            Table[0.1\ i, {i, 0, 10}]}, \[IndentingNewLine]ImageSize \[Rule] 
          600, \[IndentingNewLine]PlotLabel -> "\<samples = 10\>", \
\[IndentingNewLine]PlotRange \[Rule] {{0, 1}, {0, 
              1}}, \[IndentingNewLine]RotateLabel \[Rule] 
          False, \[IndentingNewLine]TextStyle \[Rule] {FontFamily -> "\<Times\
\>", FontSize \[Rule] 
              24}, \[IndentingNewLine]SymbolShape \[Rule] \
{MakeSymbol[{Line[{{5, 0}, {\(-5\), 0}}], Line[{{0, 5}, {0, \(-5\)}}]}], 
            PlotSymbol[Triangle, 8, Filled \[Rule] False]}]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Image Output", "Section"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_3d_surf.\>" <> #, 
            rosensurf] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_2d_surf.\>" <> #, 
            rosencont] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_2d_pts.\>" <> #, 
            rosen2dpts] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_vect_pts.\>" <> #, 
            rosenvectpts] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_grad_opt_pts.\>" <> #, 
            rosenunconpts] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_ps_opt_pts.\>" <> #, 
            rosenpspts] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_ps_opt_pts2.\>" <> #, 
            rosenpsptsclose] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_ea_init.\>" <> #, 
            roseneaptsinit] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_ea_final.\>" <> #, 
            roseneaptsfinal] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/rosen_nond_pts.\>" <> #, 
            rosencontmcPTS] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/textbook_contours.\>" <> #, 
            tbconscont] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/textbook_closeup.\>" <> #, 
            tbconscontclose] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/textbook_history.\>" <> #, 
            tbconsoptcont] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/lhs_graphic.\>" <> #, 
            lhsgraphicPTS] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/input_samples5.\>" <> #, 
            plot5uqPTS] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"],

Cell[BoxData[
    \(\(\(Export["\<images/input_samples10.\>" <> #, 
            plot10uqPTS] &\) /@ {"\<eps\>", "\<png\>"};\)\)], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
WindowSize->{520, 600},
WindowMargins->{{204, Automatic}, {210, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 111, 5, 330, "Title"],

Cell[CellGroupData[{
Cell[1912, 62, 32, 0, 74, "Section"],
Cell[1947, 64, 133, 3, 50, "Text"],
Cell[2083, 69, 204, 5, 91, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2324, 79, 40, 0, 44, "Section"],

Cell[CellGroupData[{
Cell[2389, 83, 35, 0, 38, "Subsection"],
Cell[2427, 85, 86, 1, 27, "Input"],
Cell[2516, 88, 391, 7, 91, "Input"],
Cell[2910, 97, 434, 9, 123, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3381, 111, 39, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[3445, 115, 49, 0, 28, "Subsubsection"],
Cell[3497, 117, 119, 3, 43, "Input"],
Cell[3619, 122, 206, 4, 75, "Input"],
Cell[3828, 128, 192, 4, 59, "Input"],
Cell[4023, 134, 283, 6, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4343, 145, 52, 0, 22, "Subsubsection"],
Cell[4398, 147, 124, 3, 59, "Input"],
Cell[4525, 152, 209, 4, 75, "Input"],
Cell[4737, 158, 194, 4, 59, "Input"],
Cell[4934, 164, 286, 6, 75, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5269, 176, 34, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[5328, 180, 66, 0, 28, "Subsubsection"],
Cell[5397, 182, 128, 3, 59, "Input"],
Cell[5528, 187, 131, 3, 43, "Input"],
Cell[5662, 192, 96, 3, 32, "Text"],
Cell[5761, 197, 269, 6, 91, "Input"],
Cell[6033, 205, 289, 6, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6359, 216, 74, 0, 22, "Subsubsection"],
Cell[6436, 218, 123, 3, 59, "Input"],
Cell[6562, 223, 206, 4, 75, "Input"],
Cell[6771, 229, 192, 4, 59, "Input"],
Cell[6966, 235, 283, 6, 75, "Input"],
Cell[7252, 243, 500, 10, 139, "Input"],
Cell[7755, 255, 259, 5, 91, "Input"],
Cell[8017, 262, 298, 6, 91, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8352, 273, 84, 1, 22, "Subsubsection"],
Cell[8439, 276, 123, 3, 59, "Input"],
Cell[8565, 281, 206, 4, 75, "Input"],
Cell[8774, 287, 206, 4, 59, "Input"],
Cell[8983, 293, 212, 4, 59, "Input"],
Cell[9198, 299, 291, 6, 75, "Input"],
Cell[9492, 307, 293, 6, 91, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9834, 319, 30, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[9889, 323, 36, 0, 28, "Subsubsection"],
Cell[9928, 325, 121, 3, 59, "Input"],
Cell[10052, 330, 206, 4, 75, "Input"],
Cell[10261, 336, 192, 4, 59, "Input"],
Cell[10456, 342, 287, 6, 75, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10804, 355, 36, 0, 44, "Section"],

Cell[CellGroupData[{
Cell[10865, 359, 35, 0, 38, "Subsection"],
Cell[10903, 361, 84, 1, 29, "Input"],
Cell[10990, 364, 58, 1, 46, "Input"],
Cell[11051, 367, 58, 1, 46, "Input"],
Cell[11112, 370, 440, 9, 123, "Input"],
Cell[11555, 381, 197, 5, 59, "Input"],
Cell[11755, 388, 218, 5, 75, "Input"],
Cell[11976, 395, 393, 8, 107, "Input"],
Cell[12372, 405, 449, 9, 123, "Input"],
Cell[12824, 416, 200, 5, 59, "Input"],
Cell[13027, 423, 221, 5, 75, "Input"],
Cell[13251, 430, 417, 8, 123, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[13705, 443, 34, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[13764, 447, 64, 0, 28, "Subsubsection"],
Cell[13831, 449, 128, 3, 59, "Input"],
Cell[13962, 454, 215, 4, 75, "Input"],
Cell[14180, 460, 198, 4, 59, "Input"],
Cell[14381, 466, 410, 8, 123, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14852, 481, 45, 0, 44, "Section"],
Cell[14900, 483, 62, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[14987, 488, 30, 0, 38, "Subsection"],
Cell[15020, 490, 129, 2, 43, "Input"],
Cell[15152, 494, 137, 3, 59, "Input"],
Cell[15292, 499, 136, 3, 59, "Input"],
Cell[15431, 504, 140, 3, 59, "Input"],
Cell[15574, 509, 139, 3, 59, "Input"],
Cell[15716, 514, 954, 17, 235, "Input"],
Cell[16673, 533, 244, 5, 107, "Input"],
Cell[16920, 540, 241, 5, 107, "Input"],
Cell[17164, 547, 253, 5, 107, "Input"],
Cell[17420, 554, 250, 5, 107, "Input"],
Cell[17673, 561, 898, 16, 267, "Input"],
Cell[18574, 579, 1024, 18, 299, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19647, 603, 31, 0, 44, "Section"],
Cell[19681, 605, 134, 2, 43, "Input"],
Cell[19818, 609, 134, 2, 43, "Input"],
Cell[19955, 613, 134, 2, 43, "Input"],
Cell[20092, 617, 138, 2, 43, "Input"],
Cell[20233, 621, 143, 2, 43, "Input"],
Cell[20379, 625, 138, 2, 43, "Input"],
Cell[20520, 629, 144, 2, 43, "Input"],
Cell[20667, 633, 139, 2, 43, "Input"],
Cell[20809, 637, 141, 2, 43, "Input"],
Cell[20953, 641, 140, 2, 43, "Input"],
Cell[21096, 645, 139, 2, 43, "Input"],
Cell[21238, 649, 143, 2, 43, "Input"],
Cell[21384, 653, 141, 2, 43, "Input"],
Cell[21528, 657, 136, 2, 43, "Input"],
Cell[21667, 661, 136, 2, 43, "Input"],
Cell[21806, 665, 138, 2, 43, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

