function [u]=griddata_nearest_vector(x_m,y_m,u_m,x,y)
%GRIDDATA_NEAREST_VECTOR - interpolates a function on a grid
%
%   This function returns interpolated u_m function of x_m and y_m,
%   on the grid defined by x and y.
%   INPUT x_m,y_m,u_M, x,y where x_m,y_m, u_m, x,y are all one dimensional vectors,
%   See griddata_nearest_matrix for the case where x_m,y_m and u_m are matrices 
%   and x,y are vectores.
%   See griddata_perso for a user defined version of griddata ( with fuzz coeff).
%
%   Usage:
%      [u]=griddata_nearest_vector(x_m,y_m,u_m,x,y)

u=zeros(length(x),1);
for n=1:length(x),
   if mod(n,length(x)/10)==0,
      disp(n/length(x)*100);
   end
   
   dist=sqrt((x(n)-x_m).^2+(y(n)-y_m).^2);
   pos=find(dist==min(dist));
   if isnan(u_m(pos)),
      pos
   end
   
   u(n)=u_m(pos);
   
end
