/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class UnconstrainedStatistician.

    NOTES:

        See notes of UnconstrainedStatistician.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Thu May 22 08:05:53 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the UnconstrainedStatistician class.
 */


/*
================================================================================
Includes
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Utilities {







/*
================================================================================
Inline Mutators
================================================================================
*/






/*
================================================================================
Inline Accessors
================================================================================
*/







/*
================================================================================
Inline Public Methods
================================================================================
*/
template <typename DesignContainer, typename PFunc>
DesignDoubleMap
UnconstrainedStatistician::ApplyPenalty(
    const DesignContainer& designs,
    PFunc penalizer
    )
{
    // prepare our return object.
    DesignDoubleMap ret;

    const DesignOFSortSet::const_iterator e(designs.end());
    for(typename DesignContainer::const_iterator it(designs.begin());
        it!=e; ++it) ret.AddValue(*it, penalizer(*it));

    return ret;
}

template <typename DesignContainer, typename PFunc>
const DesignDoubleMap&
UnconstrainedStatistician::AddPenalty(
    const DesignContainer& designs,
    PFunc penalizer,
    DesignDoubleMap& to
    )
{
    // go through and do each Design in "group"
    const typename DesignContainer::const_iterator e(designs.end());

    for(typename DesignContainer::const_iterator it(designs.begin());
        it!=e; ++it) to.AddToValue(*it, penalizer(*it));

    return to;
}

template <typename DesignContainer>
const DesignDoubleMap&
UnconstrainedStatistician::AddOutOfBoundsPenalties(
    const DesignContainer& designs,
    DesignDoubleMap& to
    )
{
    return AddPenalty<DesignContainer>(designs, BoundsPenalizer(), to);

} // UnconstrainedStatistician::AddOutOfBoundsPenalties

template <typename DesignContainer>
DesignDoubleMap
UnconstrainedStatistician::ApplyExteriorPenalty(
    const DesignContainer& designs,
    double multiplier
    )
{
    return ApplyPenalty<DesignContainer>(
        designs, ExteriorPenalizer(multiplier)
        );

} // UnconstrainedStatistician::ApplyExteriorPenalty

template <typename DesignContainer>
DesignDoubleMap
UnconstrainedStatistician::ApplyQuadraticPenalty(
    const DesignContainer& designs,
    double multiplier
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return ApplyExteriorPenalty<DesignContainer>(designs, multiplier);
}








/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Utilities
} // namespace JEGA
