/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per grid.
 */ 

#include "../include/macros.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"

#undef __FUNCT__  
#define __FUNCT__ "DistributeNumDofs"

int DistributeNumDofs(int *pnumdofs,int analysis_type){

	int numdofs=2;
	int i;

	/*ok, according to analysis type: */
	if (analysis_type==DiagnosticHorizAnalysisEnum()){
		numdofs=2;
	}
	else if (analysis_type==ControlAnalysisEnum()){
		numdofs=2;
	}
	else if (analysis_type==ThermalSteadyAnalysisEnum()){
		numdofs=1;
	}
	else throw ErrorException(__FUNCT__," analysis type not implemented yet!");

	/*Assign output pointers:*/
	*pnumdofs=numdofs;;

	return 1;
}
