function projection_value=project2d(md,value,layer)
%PROJECT2D - returns the value of a field for a given layer of the mesh
%
%   project 'value' vector taken at layer 'layer' from extruded 2d-3d mesh onto 2d mesh 
%   used to do the extrusion. This routine is used to compare values between a 2d-3d mesh
%   at a certain layer, and the equivalent value (if it exists), on the original 2d mesh. 
%   This routine relies heavily on projections (contained in 3d model md) recored during 
%   the extrude operation.
%
%   Usage:
%      projection_value=project2d(md,value,layer)
%
%   Example:
%      vel2=project2d(md,md.vel,2);

%some checks on list of arguments
if ((nargin~=3) ),
	project2dusage();
	error('project2d error message');
end

if md.counter<4,
	error('this model has not been extruded! ... exiting');
end

if ~strcmpi(md.type,'3d'),
	error('wrong model type ... should be ''3d''');
end

if ((layer<1) | (layer>md.numlayers)),
	error(['layer must be between 1 and ' num2str(md.numlayers)]);
end

if length(value)==md.numberofgrids,
	projection_value=value((layer-1)*md.numberofgrids2d+1:layer*md.numberofgrids2d);
else
	projection_value=value((layer-1)*md.numberofelements2d+1:layer*md.numberofelements2d);
end

function project2dusage();
disp(' project2d:  project ''value'' vector taken at layer ''layer'' from extruded 2d-3d mesh onto 2d mesh ');
disp('              used to do the extrusion. This routine is used to compare values between a 2d-3d mesh');
disp('              at a certain layer, and the equivalent value (if it exists), on the original 2d mesh. ');
disp('              This routine relies heavily on projections (contained in 3d model md) recored during ');
disp('              the extrude operation.');
disp(' INPUT function projection_value=project2d(md,value,layer)');
