function [handle_structure]=antlatlonoverlay(latstep,lonstep,color,resolution,gap)
%ANTLATLONOVERLAY - ???
%
%   latstep,lonstep: step, in latitude and longitude degreees, between two latitudinal, longitudinal profiles.
%   color: [1 1 1] for ex
%   resolution: profile resolution ( in lat,lon degrees) 
%   gap: gap (in meters) to plug lat,lon degree numbers;
%  
%   Usage:
%      [handle_structure]=antlatlonoverlay(latstep,lonstep,color,resolution,gap)

if ((nargin==0) || (nargin~=5) || (nargout~=1)),
	help antlatlonoverlay;
	return;
end
handle_structure(1).text='';

step=min(latstep,lonstep);

%Find lat and lon that fit within the bounds of our image.
lat=-90:step:0;
lon=0:step:360;

xlimits=xlim;
ylimits=ylim;

found=0;
for i=1:length(lon),
	latitudes=lat;
	longitude=lon(i);
	[x,y]=ll2xy(lat,lon(i));
	if length(find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2))),
		found=1;
		break;
	end
end

if found==0,
	handle_structure=antlatlonoverlay(latstep/2,lonstep/2,color,resolution,gap);
end

pos= find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2));
thislat=latitudes(pos(1));
thislon=longitude;
%build profiles from this center outwards. 
latprofile.x=0;
latprofile.y=0;
lonprofile.x=0;
lonprofile.y=0;

longitude=(0:(resolution*4):360)';
for i=0:(90/latstep),
	[x,y]=ll2xy((thislat+i*latstep)*ones(length(longitude),1),longitude);
	if ~length(find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2))),
		break;
	else
		pos= find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2));
		latprofile(end+1).x=x(pos);
		latprofile(end).y=y(pos);
		latprofile(end).lat=thislat+i*latstep;
	end
end

for i=0:(90/latstep),
	[x,y]=ll2xy((thislat-i*latstep)*ones(length(longitude),1),longitude);
	if ~length(find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2))),
		break;
	else
		pos= find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2));
		latprofile(end+1).x=x(pos);
		latprofile(end).y=y(pos);
		latprofile(end).lat=thislat-i*latstep;
	end
end

latitude=(-90:resolution:0)';
for i=0:(180/lonstep),
	[x,y]=ll2xy(latitude,(thislon+i*lonstep)*ones(length(latitude),1));
	if ~length(find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2))),
		break;
	else
		pos= find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2));
		lonprofile(end+1).x=x(pos);
		lonprofile(end).y=y(pos);
		lonprofile(end).lon=thislon+i*lonstep;
	end
end
for i=0:(180/lonstep),
	[x,y]=ll2xy(latitude,(thislon-i*lonstep)*ones(length(latitude),1));
	if ~length(find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2))),
		break;
	else
		pos= find(x>xlimits(1) & x<xlimits(2) & y>ylimits(1) & y<ylimits(2));
		lonprofile(end+1).x=x(pos);
		lonprofile(end).y=y(pos);
		lonprofile(end).lon=thislon-i*lonstep;
	end
end


latprofile=latprofile(2:end);
lonprofile=lonprofile(2:end);


%Verify we don't have duplicate profiles, and root out profiles that have less than 10 points.
prof=latprofile(1);
for i=2:length(latprofile),
	found=0;
	for j=1:length(prof),
		if (prof(j).lat==latprofile(i).lat),
			found=1;
		end
	end
	if length(latprofile(i).x)<10,
		found=1; %reject this profile
	end
	if found==0,
		prof(end+1)=latprofile(i);
	end
end
latprofile=prof;

prof=lonprofile(1);
for i=2:length(lonprofile),
	found=0;
	for j=1:length(prof),
		if (prof(j).lon==lonprofile(i).lon),
			found=1;
		end
	end
	if length(lonprofile(i).x)<10,
		found=1; %reject this profile
	end
	if found==0,
		prof(end+1)=lonprofile(i);
	end
end
lonprofile=prof;

hold on;
for i=1:length(latprofile),
	l=line(latprofile(i).x,latprofile(i).y,'Color',color);
	disp(['Specifiy where to put number for latitude ' num2str(latprofile(i).lat)])
	[xcorner,ycorner]=ginput(1);

	%Find nearest point on this profile corresponding to (xcorner,ycorner):
	ind=find_point(latprofile(i).x,latprofile(i).y,xcorner,ycorner);
	xcorner=latprofile(i).x(ind);
	ycorner=latprofile(i).y(ind);
	
	if length(latprofile(i).x(1:ind))>10,
		xcorner2=latprofile(i).x(ind-10);
		ycorner2=latprofile(i).y(ind-10);
	else
		xcorner2=latprofile(i).x(ind-1);
		ycorner2=latprofile(i).y(ind-1);
	end


	angle=180/pi*atan2((ycorner2-ycorner),(xcorner2-xcorner));

	if (xcorner>xlimits(1) & xcorner<xlimits(2) & ycorner>ylimits(1) & ycorner<ylimits(2)),
		handle_structure(end+1).text=text(xcorner,ycorner,[num2str(latprofile(i).lat) '^{\circ}']);set(handle_structure(end).text,'Color',color,'Rotation',angle,'FontSize',14,'HorizontalAlignment','center','VerticalAlignment','middle');

		%erase line and redraw it in two parts, to leave space for latitude number
		delete(l);
		dl=sqrt((latprofile(i).x(1)-latprofile(i).x(10))^2+(latprofile(i).y(1)-latprofile(i).y(10))^2);
		indoffset=floor(10*gap/dl);
		handle_structure(end+1).line=line(latprofile(i).x(1:(ind-indoffset)),latprofile(i).y(1:(ind-indoffset)),'Color',color);hold on;
		handle_structure(end+1).line=line(latprofile(i).x((ind+indoffset):length(latprofile(i).y)),latprofile(i).y((ind+indoffset):length(latprofile(i).y)),'Color',color);
	end
	latprofile(i).linehandle=l;
end

for i=1:length(lonprofile),
	l=line(lonprofile(i).x,lonprofile(i).y,'Color',color);
	if lonprofile(i).lon<180,
		disp(['Specifiy where to put number for longitude ' num2str(lonprofile(i).lon)])
		[xcorner,ycorner]=ginput(1);
		%Find nearest point on this profile corresponding to (xcorner,ycorner):
		ind=find_point(lonprofile(i).x,lonprofile(i).y,xcorner,ycorner);
		xcorner=lonprofile(i).x(ind);
		ycorner=lonprofile(i).y(ind);
		if length(lonprofile(i).x(1:ind))>10,
			xcorner2=lonprofile(i).x(ind-10);
			ycorner2=lonprofile(i).y(ind-10);
		else
			xcorner2=lonprofile(i).x(ind-1);
			ycorner2=lonprofile(i).y(ind-1);
		end

		angle=180/pi*atan2((ycorner2-ycorner),(xcorner2-xcorner));


		if (xcorner>xlimits(1) & xcorner<xlimits(2) & ycorner>ylimits(1) & ycorner<ylimits(2)),
			handle_structure(end+1).text=text(xcorner,ycorner,[num2str(lonprofile(i).lon) '^{\circ}']);set(handle_structure(end).text,'Color',color,'Rotation',angle,'FontSize',14,'HorizontalAlignment','center','VerticalAlignment','middle');
			%erase line and redraw it in two parts, to leave space for longitude number
			delete(l);
			dl=sqrt((lonprofile(i).x(1)-lonprofile(i).x(10))^2+(lonprofile(i).y(1)-lonprofile(i).y(10))^2);
			indoffset=floor(10*gap/dl);
			handle_structure(end+1).line=line(lonprofile(i).x(1:(ind-indoffset)),lonprofile(i).y(1:(ind-indoffset)),'Color',color);hold on;
			handle_structure(end+1).line=line(lonprofile(i).x((ind+indoffset):length(lonprofile(i).y)),lonprofile(i).y((ind+indoffset):length(lonprofile(i).y)),'Color',color);
		end
	else
		disp(['Specifiy where to put number for longitude ' num2str(360-lonprofile(i).lon)])
		[xcorner,ycorner]=ginput(1);
		%Find nearest point on this profile corresponding to (xcorner,ycorner):
		ind=find_point(lonprofile(i).x,lonprofile(i).y,xcorner,ycorner);
		xcorner=lonprofile(i).x(ind);
		ycorner=lonprofile(i).y(ind);
		if length(lonprofile(i).x(1:ind))>10,
			xcorner2=lonprofile(i).x(ind-10);
			ycorner2=lonprofile(i).y(ind-10);
		else
			xcorner2=lonprofile(i).x(ind-1);
			ycorner2=lonprofile(i).y(ind-1);
		end
		angle=180/pi*atan2((ycorner2-ycorner),(xcorner2-xcorner));

		if (xcorner>xlimits(1) & xcorner<xlimits(2) & ycorner>ylimits(1) & ycorner<ylimits(2)),
			handle_structure(end+1).text=text(xcorner,ycorner,[num2str(360-lonprofile(i).lon) '^{\circ}']);set(handle_structure(end).text,'Color',color,'Rotation',angle,'FontSize',14,'HorizontalAlignment','center','VerticalAlignment','middle');
			%erase line and redraw it in two parts, to leave space for longitude number
			delete(l);
			dl=sqrt((lonprofile(i).x(1)-lonprofile(i).x(10))^2+(lonprofile(i).y(1)-lonprofile(i).y(10))^2);
			indoffset=floor(10*gap/dl);
			handle_structure(end+1).line=line(lonprofile(i).x(1:(ind-indoffset)),lonprofile(i).y(1:(ind-indoffset)),'Color',color);hold on;
			handle_structure(end+1).line=line(lonprofile(i).x((ind+indoffset):length(lonprofile(i).y)),lonprofile(i).y((ind+indoffset):length(lonprofile(i).y)),'Color',color);
		end
	end
	lonprofile(i).linehandle=l;
end

%return effective handle_structure: 
handle_structure=handle_structure(2:length(handle_structure));
