%
%  definition for the continuous_design class.
%
%  [cdv]=continuous_design(varargin)
%
classdef continuous_design
    properties
        descriptor='';
        initpt    = NaN;
        lower     = NaN;
        upper     = NaN;
    end
    
    methods
        function [cdv]=continuous_design(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'continuous_design')
                        cdv=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'continuous_design');
                    end

%  create the object from the input

                otherwise
                    cdv.descriptor=varargin{1};
                    cdv.initpt    =varargin{2};
                    if (nargin >= 3)
                        cdv.lower     =varargin{3};
                        if (nargin >= 4)
                            cdv.upper     =varargin{4};
                            if (nargin > 4)
                                warning('continuous_design:extra_arg',...
                                    'Extra arguments for object of class ''%s''.',...
                                    class(cdv));
                            end
                        end
                    end
            end

        end
        function [desc]  =dvar_desc(cdv)
            desc=cell(size(cdv));
            for i=1:numel(cdv)
                desc(i)=cellstr(cdv(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [initpt]=dvar_initpt(cdv)
            initpt=zeros(size(cdv));
            for i=1:numel(cdv)
                initpt(i)=cdv(i).initpt;
            end
        end
        function [lower] =dvar_lower(cdv)
            lower=zeros(size(cdv));
            for i=1:numel(cdv)
                lower(i)=cdv(i).lower;
            end
            lower=allnan(lower);
        end
        function [upper] =dvar_upper(cdv)
            upper=zeros(size(cdv));
            for i=1:numel(cdv)
                upper(i)=cdv(i).upper;
            end
            upper=allnan(upper);
        end
        function [mean]  =dvar_mean(cdv)
            mean=[];
        end
        function [stddev]=dvar_stddev(cdv)
            stddev=[];
        end
        function [initst]=dvar_initst(cdv)
            initst=[];
        end
    end
end
