
/*
   ParallelFetchScalar.c
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../shared/shared.h"
#include "../toolkits/toolkits.h"

#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

#undef __FUNCT__
#define __FUNCT__ "ParallelFetchScalar"

void ParallelFetchScalar(double* pscalar,FILE* fid){

	/*output: */
	double   scalar;
	extern int my_rank;
	extern int num_procs;

	/*We have to read a scalar from disk. First read the dimensions of the scalar, then the scalar: */
	if(my_rank==0){
		if(fread(&scalar,sizeof(double),1,fid)!=1)throw ErrorException(__FUNCT__," could not read scalar ");
	}
	MPI_Bcast(&scalar,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 

	/*Assign output pointers: */
	*pscalar=scalar;
}

#endif //#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)
