%
%  display for the continuous_state class.
%
%  []=display(csv)
%
function []=display(csv)

if ~isa(csv,'continuous_state')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(csv),'continuous_state');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(csv)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(csv),inputname(1),string_dim(csv,i)));
    disp(sprintf('    descriptor: ''%s'''  ,csv(i).descriptor));
    disp(sprintf('        initst: %g'      ,csv(i).initst));
    disp(sprintf('         lower: %g'      ,csv(i).lower));
    disp(sprintf('         upper: %g\n'    ,csv(i).upper));
end

end

