/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jul  2 16:41:09 EDT 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2r -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -name hc2rIII_64 -dft-III -include hc2rIII.h */

/*
 * This function contains 434 FP additions, 260 FP multiplications,
 * (or, 238 additions, 64 multiplications, 196 fused multiply/add),
 * 165 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.19 2006-02-12 23:34:12 athena Exp $
 */

#include "hc2rIII.h"

static void hc2rIII_64(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP357805721, +0.357805721314524104672487743774474392487532769);
     DK(KP1_883088130, +1.883088130366041556825018805199004714371179592);
     DK(KP472964775, +0.472964775891319928124438237972992463904131113);
     DK(KP1_807978586, +1.807978586246886663172400594461074097420264050);
     DK(KP049126849, +0.049126849769467254105343321271313617079695752);
     DK(KP1_997590912, +1.997590912410344785429543209518201388886407229);
     DK(KP906347169, +0.906347169019147157946142717268914412664134293);
     DK(KP1_481902250, +1.481902250709918182351233794990325459457910619);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP250486960, +0.250486960191305461595702160124721208578685568);
     DK(KP1_940062506, +1.940062506389087985207968414572200502913731924);
     DK(KP599376933, +0.599376933681923766271389869014404232837890546);
     DK(KP1_715457220, +1.715457220000544139804539968569540274084981599);
     DK(KP148335987, +0.148335987538347428753676511486911367000625355);
     DK(KP1_978353019, +1.978353019929561946903347476032486127967379067);
     DK(KP741650546, +0.741650546272035369581266691172079863842265220);
     DK(KP1_606415062, +1.606415062961289819613353025926283847759138854);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E T43, T4b, T49, T4e, T3T, T46, T40, T4a;
	  {
	       E T3t, T15, T2E, T3U, T6b, Tf, T6Q, T6u, T5J, T4L, T3V, T1g, T5U, T5q, T3u;
	       E T2H, T6v, Tu, T5r, T4V, T6R, T6e, T2K, T1s, T2J, T1D, T3X, T3B, T5s, T4Q;
	       E T3Y, T3y, T6g, TK, T5M, T57, T6N, T6j, T35, T1W, T34, T25, T4i, T3J, T5N;
	       E T52, T4j, T3G, T6l, TZ, T3L, T5P, T5i, T6M, T6o, T3M, T38, T2n, T37, T2w;
	       E T4l, T3Q, T5Q, T5d;
	       {
		    E T3x, T3w, T3E, T3F;
		    {
			 E T5p, T5o, T2G, T2F;
			 {
			      E T11, T3, T5m, T2D, T2A, T6, T5n, T14, Tb, T16, Ta, T4I, T19, Tc, T1c;
			      E T1d;
			      {
				   E T4, T5, T12, T13;
				   {
					E T1, T2, T2B, T2C;
					T1 = ri[0];
					T2 = ri[WS(ris, 31)];
					T2B = ii[0];
					T2C = ii[WS(iis, 31)];
					T4 = ri[WS(ris, 16)];
					T11 = T1 - T2;
					T3 = T1 + T2;
					T5m = T2C - T2B;
					T2D = T2B + T2C;
					T5 = ri[WS(ris, 15)];
					T12 = ii[WS(iis, 16)];
					T13 = ii[WS(iis, 15)];
				   }
				   {
					E T8, T9, T17, T18;
					T8 = ri[WS(ris, 8)];
					T2A = T4 - T5;
					T6 = T4 + T5;
					T5n = T13 - T12;
					T14 = T12 + T13;
					T9 = ri[WS(ris, 23)];
					T17 = ii[WS(iis, 8)];
					T18 = ii[WS(iis, 23)];
					Tb = ri[WS(ris, 7)];
					T16 = T8 - T9;
					Ta = T8 + T9;
					T4I = T18 - T17;
					T19 = T17 + T18;
					Tc = ri[WS(ris, 24)];
					T1c = ii[WS(iis, 7)];
					T1d = ii[WS(iis, 24)];
				   }
			      }
			      {
				   E T1b, T4J, T1e, T4H, T7, Te, Td;
				   T3t = T11 + T14;
				   T15 = T11 - T14;
				   T1b = Tb - Tc;
				   Td = Tb + Tc;
				   T4J = T1c - T1d;
				   T1e = T1c + T1d;
				   T2E = T2A + T2D;
				   T3U = T2A - T2D;
				   T4H = T3 - T6;
				   T7 = T3 + T6;
				   Te = Ta + Td;
				   T5p = Ta - Td;
				   {
					E T4K, T6s, T6t, T1a, T1f;
					T5o = T5m - T5n;
					T6s = T5n + T5m;
					T6t = T4I + T4J;
					T4K = T4I - T4J;
					T6b = T7 - Te;
					Tf = T7 + Te;
					T6Q = T6t + T6s;
					T6u = T6s - T6t;
					T2G = T16 + T19;
					T1a = T16 - T19;
					T1f = T1b - T1e;
					T2F = T1b + T1e;
					T5J = T4H - T4K;
					T4L = T4H + T4K;
					T3V = T1a - T1f;
					T1g = T1a + T1f;
				   }
			      }
			 }
			 {
			      E T1i, Ti, T4O, T1q, T1n, Tl, T4N, T1l, Tq, T1t, Tp, T4T, T1A, Tr, T1u;
			      E T1v;
			      {
				   E Tj, Tk, T1j, T1k;
				   {
					E Tg, Th, T1o, T1p;
					Tg = ri[WS(ris, 4)];
					T5U = T5p + T5o;
					T5q = T5o - T5p;
					T3u = T2G + T2F;
					T2H = T2F - T2G;
					Th = ri[WS(ris, 27)];
					T1o = ii[WS(iis, 4)];
					T1p = ii[WS(iis, 27)];
					Tj = ri[WS(ris, 20)];
					T1i = Tg - Th;
					Ti = Tg + Th;
					T4O = T1p - T1o;
					T1q = T1o + T1p;
					Tk = ri[WS(ris, 11)];
					T1j = ii[WS(iis, 20)];
					T1k = ii[WS(iis, 11)];
				   }
				   {
					E Tn, To, T1y, T1z;
					Tn = ri[WS(ris, 3)];
					T1n = Tj - Tk;
					Tl = Tj + Tk;
					T4N = T1k - T1j;
					T1l = T1j + T1k;
					To = ri[WS(ris, 28)];
					T1y = ii[WS(iis, 3)];
					T1z = ii[WS(iis, 28)];
					Tq = ri[WS(ris, 12)];
					T1t = Tn - To;
					Tp = Tn + To;
					T4T = T1y - T1z;
					T1A = T1y + T1z;
					Tr = ri[WS(ris, 19)];
					T1u = ii[WS(iis, 12)];
					T1v = ii[WS(iis, 19)];
				   }
			      }
			      {
				   E T4M, T1B, T1w, T4P, T1m, T1r, Tm, Ts, T4S;
				   T4M = Ti - Tl;
				   Tm = Ti + Tl;
				   T1B = Tq - Tr;
				   Ts = Tq + Tr;
				   T4S = T1v - T1u;
				   T1w = T1u + T1v;
				   {
					E T6c, Tt, T4R, T6d, T4U;
					T6c = T4N + T4O;
					T4P = T4N - T4O;
					Tt = Tp + Ts;
					T4R = Tp - Ts;
					T6d = T4S + T4T;
					T4U = T4S - T4T;
					T3x = T1i + T1l;
					T1m = T1i - T1l;
					T6v = Tm - Tt;
					Tu = Tm + Tt;
					T5r = T4R - T4U;
					T4V = T4R + T4U;
					T6R = T6c + T6d;
					T6e = T6c - T6d;
					T1r = T1n + T1q;
					T3w = T1n - T1q;
				   }
				   {
					E T3A, T3z, T1x, T1C;
					T3A = T1t + T1w;
					T1x = T1t - T1w;
					T1C = T1A - T1B;
					T3z = T1B + T1A;
					T2K = FMA(KP414213562, T1m, T1r);
					T1s = FNMS(KP414213562, T1r, T1m);
					T2J = FMA(KP414213562, T1x, T1C);
					T1D = FNMS(KP414213562, T1C, T1x);
					T3X = FMA(KP414213562, T3z, T3A);
					T3B = FNMS(KP414213562, T3A, T3z);
					T5s = T4M + T4P;
					T4Q = T4M - T4P;
				   }
			      }
			 }
		    }
		    {
			 E T1G, Ty, T54, T20, T1X, TB, T53, T1J, TI, T4Z, T1L, TF, T22, T1U, T50;
			 E T1O;
			 {
			      E T1Y, T1Z, Tz, TA, Tw, Tx, T1H, T1I;
			      Tw = ri[WS(ris, 2)];
			      Tx = ri[WS(ris, 29)];
			      T1Y = ii[WS(iis, 2)];
			      T3Y = FNMS(KP414213562, T3w, T3x);
			      T3y = FMA(KP414213562, T3x, T3w);
			      T1G = Tw - Tx;
			      Ty = Tw + Tx;
			      T1Z = ii[WS(iis, 29)];
			      Tz = ri[WS(ris, 18)];
			      TA = ri[WS(ris, 13)];
			      T1H = ii[WS(iis, 18)];
			      T54 = T1Y - T1Z;
			      T20 = T1Y + T1Z;
			      T1X = Tz - TA;
			      TB = Tz + TA;
			      T1I = ii[WS(iis, 13)];
			      {
				   E T1R, T1Q, T1S, TG, TH;
				   TG = ri[WS(ris, 5)];
				   TH = ri[WS(ris, 26)];
				   T1R = ii[WS(iis, 5)];
				   T53 = T1H - T1I;
				   T1J = T1H + T1I;
				   T1Q = TG - TH;
				   TI = TG + TH;
				   T1S = ii[WS(iis, 26)];
				   {
					E T1M, T1N, TD, TE, T1T;
					TD = ri[WS(ris, 10)];
					TE = ri[WS(ris, 21)];
					T1T = T1R + T1S;
					T4Z = T1S - T1R;
					T1M = ii[WS(iis, 10)];
					T1L = TD - TE;
					TF = TD + TE;
					T1N = ii[WS(iis, 21)];
					T22 = T1Q + T1T;
					T1U = T1Q - T1T;
					T50 = T1M - T1N;
					T1O = T1M + T1N;
				   }
			      }
			 }
			 {
			      E T4Y, T23, T51, T1K, T1V, T3I, T3H, T21, T24;
			      {
				   E T56, T1P, T6h, T55, TC, TJ, T6i;
				   T4Y = Ty - TB;
				   TC = Ty + TB;
				   TJ = TF + TI;
				   T56 = TF - TI;
				   T1P = T1L - T1O;
				   T23 = T1L + T1O;
				   T6h = T53 + T54;
				   T55 = T53 - T54;
				   T6g = TC - TJ;
				   TK = TC + TJ;
				   T6i = T50 + T4Z;
				   T51 = T4Z - T50;
				   T3E = T1G + T1J;
				   T1K = T1G - T1J;
				   T5M = T56 + T55;
				   T57 = T55 - T56;
				   T6N = T6i + T6h;
				   T6j = T6h - T6i;
				   T1V = T1P + T1U;
				   T3I = T1P - T1U;
			      }
			      T3H = T1X - T20;
			      T21 = T1X + T20;
			      T24 = T22 - T23;
			      T3F = T23 + T22;
			      T35 = FNMS(KP707106781, T1V, T1K);
			      T1W = FMA(KP707106781, T1V, T1K);
			      T34 = FMA(KP707106781, T24, T21);
			      T25 = FNMS(KP707106781, T24, T21);
			      T4i = FMA(KP707106781, T3I, T3H);
			      T3J = FNMS(KP707106781, T3I, T3H);
			      T5N = T4Y - T51;
			      T52 = T4Y + T51;
			 }
		    }
		    {
			 E T27, TN, T5f, T2q, T2r, TQ, T5e, T2a, TX, T5a, T2c, TU, T2t, T2l, T5b;
			 E T2f;
			 {
			      E T2o, T2p, TO, TP, TL, TM, T28, T29;
			      TL = ri[WS(ris, 1)];
			      TM = ri[WS(ris, 30)];
			      T2o = ii[WS(iis, 1)];
			      T4j = FMA(KP707106781, T3F, T3E);
			      T3G = FNMS(KP707106781, T3F, T3E);
			      T27 = TL - TM;
			      TN = TL + TM;
			      T2p = ii[WS(iis, 30)];
			      TO = ri[WS(ris, 14)];
			      TP = ri[WS(ris, 17)];
			      T28 = ii[WS(iis, 14)];
			      T5f = T2p - T2o;
			      T2q = T2o + T2p;
			      T2r = TO - TP;
			      TQ = TO + TP;
			      T29 = ii[WS(iis, 17)];
			      {
				   E T2i, T2h, T2j, TV, TW;
				   TV = ri[WS(ris, 9)];
				   TW = ri[WS(ris, 22)];
				   T2i = ii[WS(iis, 9)];
				   T5e = T28 - T29;
				   T2a = T28 + T29;
				   T2h = TV - TW;
				   TX = TV + TW;
				   T2j = ii[WS(iis, 22)];
				   {
					E T2d, T2e, TS, TT, T2k;
					TS = ri[WS(ris, 6)];
					TT = ri[WS(ris, 25)];
					T2k = T2i + T2j;
					T5a = T2j - T2i;
					T2d = ii[WS(iis, 6)];
					T2c = TS - TT;
					TU = TS + TT;
					T2e = ii[WS(iis, 25)];
					T2t = T2h + T2k;
					T2l = T2h - T2k;
					T5b = T2d - T2e;
					T2f = T2d + T2e;
				   }
			      }
			 }
			 {
			      E T59, T2u, T5c, T2b, T2m, T3P, T3O, T2s, T2v;
			      {
				   E T5h, T2g, T6m, T5g, TR, TY, T6n;
				   T59 = TN - TQ;
				   TR = TN + TQ;
				   TY = TU + TX;
				   T5h = TU - TX;
				   T2g = T2c - T2f;
				   T2u = T2c + T2f;
				   T6m = T5e + T5f;
				   T5g = T5e - T5f;
				   T6l = TR - TY;
				   TZ = TR + TY;
				   T6n = T5b + T5a;
				   T5c = T5a - T5b;
				   T3L = T27 + T2a;
				   T2b = T27 - T2a;
				   T5P = T5h + T5g;
				   T5i = T5g - T5h;
				   T6M = T6n + T6m;
				   T6o = T6m - T6n;
				   T2m = T2g + T2l;
				   T3P = T2g - T2l;
			      }
			      T3O = T2r + T2q;
			      T2s = T2q - T2r;
			      T2v = T2t - T2u;
			      T3M = T2u + T2t;
			      T38 = FNMS(KP707106781, T2m, T2b);
			      T2n = FMA(KP707106781, T2m, T2b);
			      T37 = FNMS(KP707106781, T2v, T2s);
			      T2w = FMA(KP707106781, T2v, T2s);
			      T4l = FMA(KP707106781, T3P, T3O);
			      T3Q = FNMS(KP707106781, T3P, T3O);
			      T5Q = T59 - T5c;
			      T5d = T59 + T5c;
			 }
		    }
	       }
	       {
		    E T4m, T3N, T5t, T5L, T63, T4W, T5Y, T5X, T66, T5W, T67, T5S;
		    {
			 E T6T, T6S, T6W, T6P;
			 {
			      E T6L, T6O, T6Y, T6X, T6Z, Tv, T10, T70;
			      T6L = Tf - Tu;
			      Tv = Tf + Tu;
			      T10 = TK + TZ;
			      T6T = TK - TZ;
			      T6O = T6M - T6N;
			      T6Y = T6N + T6M;
			      T4m = FMA(KP707106781, T3M, T3L);
			      T3N = FNMS(KP707106781, T3M, T3L);
			      T6X = Tv - T10;
			      T6S = T6Q - T6R;
			      T6Z = T6R + T6Q;
			      O[0] = KP2_000000000 * (Tv + T10);
			      O[WS(os, 32)] = KP2_000000000 * (T6Z - T6Y);
			      T70 = T6Y + T6Z;
			      T6W = T6L - T6O;
			      T6P = T6L + T6O;
			      O[WS(os, 48)] = KP1_414213562 * (T70 - T6X);
			      O[WS(os, 16)] = KP1_414213562 * (T6X + T70);
			 }
			 {
			      E T6D, T6f, T6w, T6G, T6p, T6x, T6y, T6k, T6V, T6U;
			      T6D = T6b - T6e;
			      T6f = T6b + T6e;
			      T6w = T6u - T6v;
			      T6G = T6v + T6u;
			      T6V = T6T + T6S;
			      T6U = T6S - T6T;
			      T6p = T6l + T6o;
			      T6x = T6l - T6o;
			      O[WS(os, 24)] = KP1_847759065 * (FMA(KP414213562, T6W, T6V));
			      O[WS(os, 56)] = -(KP1_847759065 * (FNMS(KP414213562, T6V, T6W)));
			      O[WS(os, 40)] = KP1_847759065 * (FNMS(KP414213562, T6P, T6U));
			      O[WS(os, 8)] = KP1_847759065 * (FMA(KP414213562, T6U, T6P));
			      T6y = T6g + T6j;
			      T6k = T6g - T6j;
			      {
				   E T5V, T5K, T5O, T5R;
				   T5t = T5r - T5s;
				   T5K = T5s + T5r;
				   {
					E T6E, T6z, T6H, T6q;
					T6E = T6y + T6x;
					T6z = T6x - T6y;
					T6H = T6k - T6p;
					T6q = T6k + T6p;
					{
					     E T6F, T6K, T6B, T6A;
					     T6F = FNMS(KP707106781, T6E, T6D);
					     T6K = FMA(KP707106781, T6E, T6D);
					     T6B = FNMS(KP707106781, T6z, T6w);
					     T6A = FMA(KP707106781, T6z, T6w);
					     {
						  E T6I, T6J, T6C, T6r;
						  T6I = FNMS(KP707106781, T6H, T6G);
						  T6J = FMA(KP707106781, T6H, T6G);
						  T6C = FNMS(KP707106781, T6q, T6f);
						  T6r = FMA(KP707106781, T6q, T6f);
						  O[WS(os, 44)] = KP1_662939224 * (FNMS(KP668178637, T6F, T6I));
						  O[WS(os, 12)] = KP1_662939224 * (FMA(KP668178637, T6I, T6F));
						  O[WS(os, 60)] = -(KP1_961570560 * (FNMS(KP198912367, T6J, T6K)));
						  O[WS(os, 28)] = KP1_961570560 * (FMA(KP198912367, T6K, T6J));
						  O[WS(os, 52)] = -(KP1_662939224 * (FNMS(KP668178637, T6B, T6C)));
						  O[WS(os, 20)] = KP1_662939224 * (FMA(KP668178637, T6C, T6B));
						  O[WS(os, 36)] = KP1_961570560 * (FNMS(KP198912367, T6r, T6A));
						  O[WS(os, 4)] = KP1_961570560 * (FMA(KP198912367, T6A, T6r));
						  T5L = FNMS(KP707106781, T5K, T5J);
						  T63 = FMA(KP707106781, T5K, T5J);
					     }
					}
				   }
				   T5V = T4Q - T4V;
				   T4W = T4Q + T4V;
				   T5Y = FNMS(KP414213562, T5M, T5N);
				   T5O = FMA(KP414213562, T5N, T5M);
				   T5R = FNMS(KP414213562, T5Q, T5P);
				   T5X = FMA(KP414213562, T5P, T5Q);
				   T66 = FMA(KP707106781, T5V, T5U);
				   T5W = FNMS(KP707106781, T5V, T5U);
				   T67 = T5O + T5R;
				   T5S = T5O - T5R;
			      }
			 }
		    }
		    {
			 E T1h, T2L, T2I, T3h, T3p, T1E, T3n, T3s, T3b, T3k, T3e, T3o;
			 {
			      E T4X, T5B, T5v, T5w, T5E, T5u, T5F, T5k, T58, T5j;
			      {
				   E T68, T69, T62, T5T, T64, T5Z;
				   T68 = FNMS(KP923879532, T67, T66);
				   T69 = FMA(KP923879532, T67, T66);
				   T62 = FNMS(KP923879532, T5S, T5L);
				   T5T = FMA(KP923879532, T5S, T5L);
				   T64 = T5Y + T5X;
				   T5Z = T5X - T5Y;
				   T4X = FMA(KP707106781, T4W, T4L);
				   T5B = FNMS(KP707106781, T4W, T4L);
				   {
					E T65, T6a, T61, T60;
					T65 = FNMS(KP923879532, T64, T63);
					T6a = FMA(KP923879532, T64, T63);
					T61 = FNMS(KP923879532, T5Z, T5W);
					T60 = FMA(KP923879532, T5Z, T5W);
					O[WS(os, 46)] = KP1_546020906 * (FNMS(KP820678790, T65, T68));
					O[WS(os, 14)] = KP1_546020906 * (FMA(KP820678790, T68, T65));
					O[WS(os, 62)] = -(KP1_990369453 * (FNMS(KP098491403, T69, T6a)));
					O[WS(os, 30)] = KP1_990369453 * (FMA(KP098491403, T6a, T69));
					O[WS(os, 54)] = -(KP1_763842528 * (FNMS(KP534511135, T61, T62)));
					O[WS(os, 22)] = KP1_763842528 * (FMA(KP534511135, T62, T61));
					O[WS(os, 38)] = KP1_913880671 * (FNMS(KP303346683, T5T, T60));
					O[WS(os, 6)] = KP1_913880671 * (FMA(KP303346683, T60, T5T));
				   }
			      }
			      T5v = FNMS(KP414213562, T52, T57);
			      T58 = FMA(KP414213562, T57, T52);
			      T5j = FNMS(KP414213562, T5i, T5d);
			      T5w = FMA(KP414213562, T5d, T5i);
			      T5E = FNMS(KP707106781, T5t, T5q);
			      T5u = FMA(KP707106781, T5t, T5q);
			      T5F = T58 - T5j;
			      T5k = T58 + T5j;
			      {
				   E T3l, T33, T3c, T3m, T3a, T3d;
				   {
					E T39, T3f, T3g, T36;
					{
					     E T31, T5G, T5H, T5A, T5l, T5C, T5x, T32;
					     T1h = FMA(KP707106781, T1g, T15);
					     T31 = FNMS(KP707106781, T1g, T15);
					     T5G = FNMS(KP923879532, T5F, T5E);
					     T5H = FMA(KP923879532, T5F, T5E);
					     T5A = FNMS(KP923879532, T5k, T4X);
					     T5l = FMA(KP923879532, T5k, T4X);
					     T5C = T5w - T5v;
					     T5x = T5v + T5w;
					     T32 = T2K + T2J;
					     T2L = T2J - T2K;
					     T39 = FNMS(KP668178637, T38, T37);
					     T3f = FMA(KP668178637, T37, T38);
					     {
						  E T5D, T5I, T5z, T5y;
						  T5D = FNMS(KP923879532, T5C, T5B);
						  T5I = FMA(KP923879532, T5C, T5B);
						  T5z = FNMS(KP923879532, T5x, T5u);
						  T5y = FMA(KP923879532, T5x, T5u);
						  T3l = FMA(KP923879532, T32, T31);
						  T33 = FNMS(KP923879532, T32, T31);
						  O[WS(os, 42)] = KP1_763842528 * (FNMS(KP534511135, T5D, T5G));
						  O[WS(os, 10)] = KP1_763842528 * (FMA(KP534511135, T5G, T5D));
						  O[WS(os, 58)] = -(KP1_913880671 * (FNMS(KP303346683, T5H, T5I)));
						  O[WS(os, 26)] = KP1_913880671 * (FMA(KP303346683, T5I, T5H));
						  O[WS(os, 50)] = -(KP1_546020906 * (FNMS(KP820678790, T5z, T5A)));
						  O[WS(os, 18)] = KP1_546020906 * (FMA(KP820678790, T5A, T5z));
						  O[WS(os, 34)] = KP1_990369453 * (FNMS(KP098491403, T5l, T5y));
						  O[WS(os, 2)] = KP1_990369453 * (FMA(KP098491403, T5y, T5l));
						  T3g = FMA(KP668178637, T34, T35);
						  T36 = FNMS(KP668178637, T35, T34);
					     }
					}
					T2I = FNMS(KP707106781, T2H, T2E);
					T3c = FMA(KP707106781, T2H, T2E);
					T3m = T3g + T3f;
					T3h = T3f - T3g;
					T3p = T39 - T36;
					T3a = T36 + T39;
					T3d = T1s - T1D;
					T1E = T1s + T1D;
				   }
				   T3n = FNMS(KP831469612, T3m, T3l);
				   T3s = FMA(KP831469612, T3m, T3l);
				   T3b = FNMS(KP831469612, T3a, T33);
				   T3k = FMA(KP831469612, T3a, T33);
				   T3e = FMA(KP923879532, T3d, T3c);
				   T3o = FNMS(KP923879532, T3d, T3c);
			      }
			 }
			 {
			      E T3v, T3Z, T3W, T4v, T4D, T3C, T4B, T4G, T4p, T4y, T4s, T4C;
			      {
				   E T4z, T4h, T4q, T4A, T4o, T4r;
				   {
					E T4n, T4t, T4u, T4k, T4f, T4g;
					T3v = FNMS(KP707106781, T3u, T3t);
					T4f = FMA(KP707106781, T3u, T3t);
					T4g = T3Y + T3X;
					T3Z = T3X - T3Y;
					{
					     E T3r, T3q, T3i, T3j;
					     T3r = FNMS(KP831469612, T3p, T3o);
					     T3q = FMA(KP831469612, T3p, T3o);
					     T3i = FNMS(KP831469612, T3h, T3e);
					     T3j = FMA(KP831469612, T3h, T3e);
					     O[WS(os, 45)] = -(KP1_606415062 * (FMA(KP741650546, T3n, T3q)));
					     O[WS(os, 13)] = KP1_606415062 * (FNMS(KP741650546, T3q, T3n));
					     O[WS(os, 61)] = -(KP1_978353019 * (FMA(KP148335987, T3r, T3s)));
					     O[WS(os, 29)] = -(KP1_978353019 * (FNMS(KP148335987, T3s, T3r)));
					     O[WS(os, 53)] = -(KP1_715457220 * (FMA(KP599376933, T3j, T3k)));
					     O[WS(os, 21)] = -(KP1_715457220 * (FNMS(KP599376933, T3k, T3j)));
					     O[WS(os, 37)] = -(KP1_940062506 * (FMA(KP250486960, T3b, T3i)));
					     O[WS(os, 5)] = KP1_940062506 * (FNMS(KP250486960, T3i, T3b));
					     T4z = FMA(KP923879532, T4g, T4f);
					     T4h = FNMS(KP923879532, T4g, T4f);
					}
					T4n = FNMS(KP198912367, T4m, T4l);
					T4t = FMA(KP198912367, T4l, T4m);
					T4u = FNMS(KP198912367, T4i, T4j);
					T4k = FMA(KP198912367, T4j, T4i);
					T3W = FNMS(KP707106781, T3V, T3U);
					T4q = FMA(KP707106781, T3V, T3U);
					T4A = T4u + T4t;
					T4v = T4t - T4u;
					T4D = T4k + T4n;
					T4o = T4k - T4n;
					T4r = T3y + T3B;
					T3C = T3y - T3B;
				   }
				   T4B = FNMS(KP980785280, T4A, T4z);
				   T4G = FMA(KP980785280, T4A, T4z);
				   T4p = FMA(KP980785280, T4o, T4h);
				   T4y = FNMS(KP980785280, T4o, T4h);
				   T4s = FNMS(KP923879532, T4r, T4q);
				   T4C = FMA(KP923879532, T4r, T4q);
			      }
			      {
				   E T2P, T2X, T2V, T30, T2z, T2S, T2M, T2W;
				   {
					E T2T, T1F, T2U, T2y;
					{
					     E T2x, T2N, T2O, T26;
					     {
						  E T4F, T4E, T4w, T4x;
						  T4F = FMA(KP980785280, T4D, T4C);
						  T4E = FNMS(KP980785280, T4D, T4C);
						  T4w = FMA(KP980785280, T4v, T4s);
						  T4x = FNMS(KP980785280, T4v, T4s);
						  O[WS(os, 47)] = KP1_481902250 * (FNMS(KP906347169, T4B, T4E));
						  O[WS(os, 15)] = KP1_481902250 * (FMA(KP906347169, T4E, T4B));
						  O[WS(os, 63)] = -(KP1_997590912 * (FNMS(KP049126849, T4F, T4G)));
						  O[WS(os, 31)] = KP1_997590912 * (FMA(KP049126849, T4G, T4F));
						  O[WS(os, 55)] = -(KP1_807978586 * (FNMS(KP472964775, T4x, T4y)));
						  O[WS(os, 23)] = KP1_807978586 * (FMA(KP472964775, T4y, T4x));
						  O[WS(os, 39)] = KP1_883088130 * (FNMS(KP357805721, T4p, T4w));
						  O[WS(os, 7)] = KP1_883088130 * (FMA(KP357805721, T4w, T4p));
						  T2T = FNMS(KP923879532, T1E, T1h);
						  T1F = FMA(KP923879532, T1E, T1h);
					     }
					     T2x = FNMS(KP198912367, T2w, T2n);
					     T2N = FMA(KP198912367, T2n, T2w);
					     T2O = FMA(KP198912367, T1W, T25);
					     T26 = FNMS(KP198912367, T25, T1W);
					     T2U = T2O + T2N;
					     T2P = T2N - T2O;
					     T2X = T26 - T2x;
					     T2y = T26 + T2x;
					}
					T2V = FNMS(KP980785280, T2U, T2T);
					T30 = FMA(KP980785280, T2U, T2T);
					T2z = FMA(KP980785280, T2y, T1F);
					T2S = FNMS(KP980785280, T2y, T1F);
					T2M = FNMS(KP923879532, T2L, T2I);
					T2W = FMA(KP923879532, T2L, T2I);
				   }
				   {
					E T47, T3D, T48, T3S;
					{
					     E T3K, T41, T42, T3R;
					     {
						  E T2Z, T2Y, T2Q, T2R;
						  T2Z = FNMS(KP980785280, T2X, T2W);
						  T2Y = FMA(KP980785280, T2X, T2W);
						  T2Q = FNMS(KP980785280, T2P, T2M);
						  T2R = FMA(KP980785280, T2P, T2M);
						  O[WS(os, 41)] = -(KP1_807978586 * (FMA(KP472964775, T2V, T2Y)));
						  O[WS(os, 9)] = KP1_807978586 * (FNMS(KP472964775, T2Y, T2V));
						  O[WS(os, 57)] = -(KP1_883088130 * (FMA(KP357805721, T2Z, T30)));
						  O[WS(os, 25)] = -(KP1_883088130 * (FNMS(KP357805721, T30, T2Z)));
						  O[WS(os, 49)] = -(KP1_481902250 * (FMA(KP906347169, T2R, T2S)));
						  O[WS(os, 17)] = -(KP1_481902250 * (FNMS(KP906347169, T2S, T2R)));
						  O[WS(os, 33)] = -(KP1_997590912 * (FMA(KP049126849, T2z, T2Q)));
						  O[WS(os, 1)] = KP1_997590912 * (FNMS(KP049126849, T2Q, T2z));
						  T47 = FNMS(KP923879532, T3C, T3v);
						  T3D = FMA(KP923879532, T3C, T3v);
					     }
					     T3K = FMA(KP668178637, T3J, T3G);
					     T41 = FNMS(KP668178637, T3G, T3J);
					     T42 = FMA(KP668178637, T3N, T3Q);
					     T3R = FNMS(KP668178637, T3Q, T3N);
					     T48 = T42 - T41;
					     T43 = T41 + T42;
					     T4b = T3K - T3R;
					     T3S = T3K + T3R;
					}
					T49 = FNMS(KP831469612, T48, T47);
					T4e = FMA(KP831469612, T48, T47);
					T3T = FMA(KP831469612, T3S, T3D);
					T46 = FNMS(KP831469612, T3S, T3D);
					T40 = FMA(KP923879532, T3Z, T3W);
					T4a = FNMS(KP923879532, T3Z, T3W);
				   }
			      }
			 }
		    }
	       }
	  }
	  {
	       E T4d, T4c, T44, T45;
	       T4d = FMA(KP831469612, T4b, T4a);
	       T4c = FNMS(KP831469612, T4b, T4a);
	       T44 = FMA(KP831469612, T43, T40);
	       T45 = FNMS(KP831469612, T43, T40);
	       O[WS(os, 43)] = KP1_715457220 * (FNMS(KP599376933, T49, T4c));
	       O[WS(os, 11)] = KP1_715457220 * (FMA(KP599376933, T4c, T49));
	       O[WS(os, 59)] = -(KP1_940062506 * (FNMS(KP250486960, T4d, T4e)));
	       O[WS(os, 27)] = KP1_940062506 * (FMA(KP250486960, T4e, T4d));
	       O[WS(os, 51)] = -(KP1_606415062 * (FNMS(KP741650546, T45, T46)));
	       O[WS(os, 19)] = KP1_606415062 * (FMA(KP741650546, T46, T45));
	       O[WS(os, 35)] = KP1_978353019 * (FNMS(KP148335987, T3T, T44));
	       O[WS(os, 3)] = KP1_978353019 * (FMA(KP148335987, T44, T3T));
	  }
     }
}

static const khc2r_desc desc = { 64, "hc2rIII_64", {238, 64, 196, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2rIII_64) (planner *p) {
     X(khc2rIII_register) (p, hc2rIII_64, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2r -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -name hc2rIII_64 -dft-III -include hc2rIII.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 342 additions, 116 multiplications, 92 fused multiply/add),
 * 130 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.19 2006-02-12 23:34:12 athena Exp $
 */

#include "hc2rIII.h"

static void hc2rIII_64(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP1_343117909, +1.343117909694036801250753700854843606457501264);
     DK(KP1_481902250, +1.481902250709918182351233794990325459457910619);
     DK(KP1_807978586, +1.807978586246886663172400594461074097420264050);
     DK(KP855110186, +0.855110186860564188641933713777597068609157259);
     DK(KP1_997590912, +1.997590912410344785429543209518201388886407229);
     DK(KP098135348, +0.098135348654836028509909953885365316629490726);
     DK(KP673779706, +0.673779706784440101378506425238295140955533559);
     DK(KP1_883088130, +1.883088130366041556825018805199004714371179592);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP1_191398608, +1.191398608984866686934073057659939779023852677);
     DK(KP1_606415062, +1.606415062961289819613353025926283847759138854);
     DK(KP1_715457220, +1.715457220000544139804539968569540274084981599);
     DK(KP1_028205488, +1.028205488386443453187387677937631545216098241);
     DK(KP1_978353019, +1.978353019929561946903347476032486127967379067);
     DK(KP293460948, +0.293460948910723503317700259293435639412430633);
     DK(KP485960359, +0.485960359806527779896548324154942236641981567);
     DK(KP1_940062506, +1.940062506389087985207968414572200502913731924);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP1_268786568, +1.268786568327290996430343226450986741351374190);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP942793473, +0.942793473651995297112775251810508755314920638);
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP196034280, +0.196034280659121203988391127777283691722273346);
     DK(KP580569354, +0.580569354508924735272384751634790549382952557);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP1_111140466, +1.111140466039204449485661627897065748749874382);
     DK(KP390180644, +0.390180644032256535696569736954044481855383236);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP765366864, +0.765366864730179543456919968060797733522689125);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E T15, T3t, T3U, T2N, Tf, T6b, T6u, T6R, T4L, T5J, T1g, T3V, T5q, T5U, T2I;
	  E T3u, Tu, T6v, T4V, T5s, T6e, T6Q, T1s, T2D, T1D, T2E, T3B, T3Y, T4Q, T5r;
	  E T3y, T3X, TK, T6g, T57, T5N, T6j, T6N, T1W, T34, T25, T35, T3J, T4j, T52;
	  E T5M, T3G, T4i, TZ, T6l, T5i, T5Q, T6o, T6M, T2n, T37, T2w, T38, T3Q, T4m;
	  E T5d, T5P, T3N, T4l;
	  {
	       E T3, T11, T2M, T5n, T6, T2J, T14, T5m, Ta, T16, T19, T4J, Td, T1b, T1e;
	       E T4I;
	       {
		    E T1, T2, T2K, T2L;
		    T1 = ri[0];
		    T2 = ri[WS(ris, 31)];
		    T3 = T1 + T2;
		    T11 = T1 - T2;
		    T2K = ii[0];
		    T2L = ii[WS(iis, 31)];
		    T2M = T2K + T2L;
		    T5n = T2L - T2K;
	       }
	       {
		    E T4, T5, T12, T13;
		    T4 = ri[WS(ris, 16)];
		    T5 = ri[WS(ris, 15)];
		    T6 = T4 + T5;
		    T2J = T4 - T5;
		    T12 = ii[WS(iis, 16)];
		    T13 = ii[WS(iis, 15)];
		    T14 = T12 + T13;
		    T5m = T12 - T13;
	       }
	       {
		    E T8, T9, T17, T18;
		    T8 = ri[WS(ris, 8)];
		    T9 = ri[WS(ris, 23)];
		    Ta = T8 + T9;
		    T16 = T8 - T9;
		    T17 = ii[WS(iis, 8)];
		    T18 = ii[WS(iis, 23)];
		    T19 = T17 + T18;
		    T4J = T17 - T18;
	       }
	       {
		    E Tb, Tc, T1c, T1d;
		    Tb = ri[WS(ris, 7)];
		    Tc = ri[WS(ris, 24)];
		    Td = Tb + Tc;
		    T1b = Tb - Tc;
		    T1c = ii[WS(iis, 7)];
		    T1d = ii[WS(iis, 24)];
		    T1e = T1c + T1d;
		    T4I = T1d - T1c;
	       }
	       {
		    E T7, Te, T1a, T1f;
		    T15 = T11 - T14;
		    T3t = T11 + T14;
		    T3U = T2J - T2M;
		    T2N = T2J + T2M;
		    T7 = T3 + T6;
		    Te = Ta + Td;
		    Tf = T7 + Te;
		    T6b = T7 - Te;
		    {
			 E T6s, T6t, T4H, T4K;
			 T6s = T4J + T4I;
			 T6t = T5n - T5m;
			 T6u = T6s + T6t;
			 T6R = T6t - T6s;
			 T4H = T3 - T6;
			 T4K = T4I - T4J;
			 T4L = T4H + T4K;
			 T5J = T4H - T4K;
		    }
		    T1a = T16 - T19;
		    T1f = T1b - T1e;
		    T1g = KP707106781 * (T1a + T1f);
		    T3V = KP707106781 * (T1a - T1f);
		    {
			 E T5o, T5p, T2G, T2H;
			 T5o = T5m + T5n;
			 T5p = Ta - Td;
			 T5q = T5o - T5p;
			 T5U = T5p + T5o;
			 T2G = T16 + T19;
			 T2H = T1b + T1e;
			 T2I = KP707106781 * (T2G - T2H);
			 T3u = KP707106781 * (T2G + T2H);
		    }
	       }
	  }
	  {
	       E Ti, T1i, T1q, T4N, Tl, T1n, T1l, T4O, Tp, T1t, T1B, T4S, Ts, T1y, T1w;
	       E T4T;
	       {
		    E Tg, Th, T1o, T1p;
		    Tg = ri[WS(ris, 4)];
		    Th = ri[WS(ris, 27)];
		    Ti = Tg + Th;
		    T1i = Tg - Th;
		    T1o = ii[WS(iis, 4)];
		    T1p = ii[WS(iis, 27)];
		    T1q = T1o + T1p;
		    T4N = T1o - T1p;
	       }
	       {
		    E Tj, Tk, T1j, T1k;
		    Tj = ri[WS(ris, 20)];
		    Tk = ri[WS(ris, 11)];
		    Tl = Tj + Tk;
		    T1n = Tj - Tk;
		    T1j = ii[WS(iis, 20)];
		    T1k = ii[WS(iis, 11)];
		    T1l = T1j + T1k;
		    T4O = T1j - T1k;
	       }
	       {
		    E Tn, To, T1z, T1A;
		    Tn = ri[WS(ris, 3)];
		    To = ri[WS(ris, 28)];
		    Tp = Tn + To;
		    T1t = Tn - To;
		    T1z = ii[WS(iis, 3)];
		    T1A = ii[WS(iis, 28)];
		    T1B = T1z + T1A;
		    T4S = T1A - T1z;
	       }
	       {
		    E Tq, Tr, T1u, T1v;
		    Tq = ri[WS(ris, 12)];
		    Tr = ri[WS(ris, 19)];
		    Ts = Tq + Tr;
		    T1y = Tq - Tr;
		    T1u = ii[WS(iis, 12)];
		    T1v = ii[WS(iis, 19)];
		    T1w = T1u + T1v;
		    T4T = T1u - T1v;
	       }
	       {
		    E Tm, Tt, T4R, T4U;
		    Tm = Ti + Tl;
		    Tt = Tp + Ts;
		    Tu = Tm + Tt;
		    T6v = Tm - Tt;
		    T4R = Tp - Ts;
		    T4U = T4S - T4T;
		    T4V = T4R + T4U;
		    T5s = T4U - T4R;
	       }
	       {
		    E T6c, T6d, T1m, T1r;
		    T6c = T4T + T4S;
		    T6d = T4O + T4N;
		    T6e = T6c - T6d;
		    T6Q = T6d + T6c;
		    T1m = T1i - T1l;
		    T1r = T1n + T1q;
		    T1s = FNMS(KP382683432, T1r, KP923879532 * T1m);
		    T2D = FMA(KP382683432, T1m, KP923879532 * T1r);
	       }
	       {
		    E T1x, T1C, T3z, T3A;
		    T1x = T1t - T1w;
		    T1C = T1y - T1B;
		    T1D = FMA(KP923879532, T1x, KP382683432 * T1C);
		    T2E = FNMS(KP382683432, T1x, KP923879532 * T1C);
		    T3z = T1t + T1w;
		    T3A = T1y + T1B;
		    T3B = FNMS(KP923879532, T3A, KP382683432 * T3z);
		    T3Y = FMA(KP923879532, T3z, KP382683432 * T3A);
	       }
	       {
		    E T4M, T4P, T3w, T3x;
		    T4M = Ti - Tl;
		    T4P = T4N - T4O;
		    T4Q = T4M - T4P;
		    T5r = T4M + T4P;
		    T3w = T1i + T1l;
		    T3x = T1q - T1n;
		    T3y = FNMS(KP923879532, T3x, KP382683432 * T3w);
		    T3X = FMA(KP923879532, T3w, KP382683432 * T3x);
	       }
	  }
	  {
	       E Ty, T1G, T23, T54, TB, T20, T1J, T55, TI, T4Z, T1U, T1Y, TF, T50, T1P;
	       E T1X;
	       {
		    E Tw, Tx, T1H, T1I;
		    Tw = ri[WS(ris, 2)];
		    Tx = ri[WS(ris, 29)];
		    Ty = Tw + Tx;
		    T1G = Tw - Tx;
		    {
			 E T21, T22, Tz, TA;
			 T21 = ii[WS(iis, 2)];
			 T22 = ii[WS(iis, 29)];
			 T23 = T21 + T22;
			 T54 = T21 - T22;
			 Tz = ri[WS(ris, 18)];
			 TA = ri[WS(ris, 13)];
			 TB = Tz + TA;
			 T20 = Tz - TA;
		    }
		    T1H = ii[WS(iis, 18)];
		    T1I = ii[WS(iis, 13)];
		    T1J = T1H + T1I;
		    T55 = T1H - T1I;
		    {
			 E TG, TH, T1Q, T1R, T1S, T1T;
			 TG = ri[WS(ris, 5)];
			 TH = ri[WS(ris, 26)];
			 T1Q = TG - TH;
			 T1R = ii[WS(iis, 5)];
			 T1S = ii[WS(iis, 26)];
			 T1T = T1R + T1S;
			 TI = TG + TH;
			 T4Z = T1S - T1R;
			 T1U = T1Q - T1T;
			 T1Y = T1Q + T1T;
		    }
		    {
			 E TD, TE, T1L, T1M, T1N, T1O;
			 TD = ri[WS(ris, 10)];
			 TE = ri[WS(ris, 21)];
			 T1L = TD - TE;
			 T1M = ii[WS(iis, 10)];
			 T1N = ii[WS(iis, 21)];
			 T1O = T1M + T1N;
			 TF = TD + TE;
			 T50 = T1M - T1N;
			 T1P = T1L - T1O;
			 T1X = T1L + T1O;
		    }
	       }
	       {
		    E TC, TJ, T53, T56;
		    TC = Ty + TB;
		    TJ = TF + TI;
		    TK = TC + TJ;
		    T6g = TC - TJ;
		    T53 = TF - TI;
		    T56 = T54 - T55;
		    T57 = T53 + T56;
		    T5N = T56 - T53;
	       }
	       {
		    E T6h, T6i, T1K, T1V;
		    T6h = T55 + T54;
		    T6i = T50 + T4Z;
		    T6j = T6h - T6i;
		    T6N = T6i + T6h;
		    T1K = T1G - T1J;
		    T1V = KP707106781 * (T1P + T1U);
		    T1W = T1K + T1V;
		    T34 = T1K - T1V;
	       }
	       {
		    E T1Z, T24, T3H, T3I;
		    T1Z = KP707106781 * (T1X - T1Y);
		    T24 = T20 + T23;
		    T25 = T1Z + T24;
		    T35 = T24 - T1Z;
		    T3H = KP707106781 * (T1P - T1U);
		    T3I = T23 - T20;
		    T3J = T3H + T3I;
		    T4j = T3I - T3H;
	       }
	       {
		    E T4Y, T51, T3E, T3F;
		    T4Y = Ty - TB;
		    T51 = T4Z - T50;
		    T52 = T4Y + T51;
		    T5M = T4Y - T51;
		    T3E = T1G + T1J;
		    T3F = KP707106781 * (T1X + T1Y);
		    T3G = T3E - T3F;
		    T4i = T3E + T3F;
	       }
	  }
	  {
	       E TN, T27, T2u, T5f, TQ, T2r, T2a, T5g, TX, T5a, T2l, T2p, TU, T5b, T2g;
	       E T2o;
	       {
		    E TL, TM, T28, T29;
		    TL = ri[WS(ris, 1)];
		    TM = ri[WS(ris, 30)];
		    TN = TL + TM;
		    T27 = TL - TM;
		    {
			 E T2s, T2t, TO, TP;
			 T2s = ii[WS(iis, 1)];
			 T2t = ii[WS(iis, 30)];
			 T2u = T2s + T2t;
			 T5f = T2t - T2s;
			 TO = ri[WS(ris, 14)];
			 TP = ri[WS(ris, 17)];
			 TQ = TO + TP;
			 T2r = TO - TP;
		    }
		    T28 = ii[WS(iis, 14)];
		    T29 = ii[WS(iis, 17)];
		    T2a = T28 + T29;
		    T5g = T28 - T29;
		    {
			 E TV, TW, T2h, T2i, T2j, T2k;
			 TV = ri[WS(ris, 9)];
			 TW = ri[WS(ris, 22)];
			 T2h = TV - TW;
			 T2i = ii[WS(iis, 9)];
			 T2j = ii[WS(iis, 22)];
			 T2k = T2i + T2j;
			 TX = TV + TW;
			 T5a = T2j - T2i;
			 T2l = T2h - T2k;
			 T2p = T2h + T2k;
		    }
		    {
			 E TS, TT, T2c, T2d, T2e, T2f;
			 TS = ri[WS(ris, 6)];
			 TT = ri[WS(ris, 25)];
			 T2c = TS - TT;
			 T2d = ii[WS(iis, 6)];
			 T2e = ii[WS(iis, 25)];
			 T2f = T2d + T2e;
			 TU = TS + TT;
			 T5b = T2d - T2e;
			 T2g = T2c - T2f;
			 T2o = T2c + T2f;
		    }
	       }
	       {
		    E TR, TY, T5e, T5h;
		    TR = TN + TQ;
		    TY = TU + TX;
		    TZ = TR + TY;
		    T6l = TR - TY;
		    T5e = TU - TX;
		    T5h = T5f - T5g;
		    T5i = T5e + T5h;
		    T5Q = T5h - T5e;
	       }
	       {
		    E T6m, T6n, T2b, T2m;
		    T6m = T5g + T5f;
		    T6n = T5b + T5a;
		    T6o = T6m - T6n;
		    T6M = T6n + T6m;
		    T2b = T27 - T2a;
		    T2m = KP707106781 * (T2g + T2l);
		    T2n = T2b + T2m;
		    T37 = T2b - T2m;
	       }
	       {
		    E T2q, T2v, T3O, T3P;
		    T2q = KP707106781 * (T2o - T2p);
		    T2v = T2r - T2u;
		    T2w = T2q + T2v;
		    T38 = T2v - T2q;
		    T3O = KP707106781 * (T2g - T2l);
		    T3P = T2r + T2u;
		    T3Q = T3O - T3P;
		    T4m = T3O + T3P;
	       }
	       {
		    E T59, T5c, T3L, T3M;
		    T59 = TN - TQ;
		    T5c = T5a - T5b;
		    T5d = T59 + T5c;
		    T5P = T59 - T5c;
		    T3L = T27 + T2a;
		    T3M = KP707106781 * (T2o + T2p);
		    T3N = T3L - T3M;
		    T4l = T3L + T3M;
	       }
	  }
	  {
	       E Tv, T10, T6X, T6Y, T6Z, T70;
	       Tv = Tf + Tu;
	       T10 = TK + TZ;
	       T6X = Tv - T10;
	       T6Y = T6N + T6M;
	       T6Z = T6R - T6Q;
	       T70 = T6Y + T6Z;
	       O[0] = KP2_000000000 * (Tv + T10);
	       O[WS(os, 32)] = KP2_000000000 * (T6Z - T6Y);
	       O[WS(os, 16)] = KP1_414213562 * (T6X + T70);
	       O[WS(os, 48)] = KP1_414213562 * (T70 - T6X);
	  }
	  {
	       E T6P, T6V, T6U, T6W;
	       {
		    E T6L, T6O, T6S, T6T;
		    T6L = Tf - Tu;
		    T6O = T6M - T6N;
		    T6P = T6L + T6O;
		    T6V = T6L - T6O;
		    T6S = T6Q + T6R;
		    T6T = TK - TZ;
		    T6U = T6S - T6T;
		    T6W = T6T + T6S;
	       }
	       O[WS(os, 8)] = FMA(KP1_847759065, T6P, KP765366864 * T6U);
	       O[WS(os, 56)] = FNMS(KP1_847759065, T6V, KP765366864 * T6W);
	       O[WS(os, 40)] = FNMS(KP765366864, T6P, KP1_847759065 * T6U);
	       O[WS(os, 24)] = FMA(KP765366864, T6V, KP1_847759065 * T6W);
	  }
	  {
	       E T6f, T6w, T6G, T6D, T6z, T6E, T6q, T6H;
	       T6f = T6b + T6e;
	       T6w = T6u - T6v;
	       T6G = T6v + T6u;
	       T6D = T6b - T6e;
	       {
		    E T6x, T6y, T6k, T6p;
		    T6x = T6g + T6j;
		    T6y = T6o - T6l;
		    T6z = KP707106781 * (T6x + T6y);
		    T6E = KP707106781 * (T6y - T6x);
		    T6k = T6g - T6j;
		    T6p = T6l + T6o;
		    T6q = KP707106781 * (T6k + T6p);
		    T6H = KP707106781 * (T6k - T6p);
	       }
	       {
		    E T6r, T6A, T6J, T6K;
		    T6r = T6f + T6q;
		    T6A = T6w - T6z;
		    O[WS(os, 4)] = FMA(KP1_961570560, T6r, KP390180644 * T6A);
		    O[WS(os, 36)] = FNMS(KP390180644, T6r, KP1_961570560 * T6A);
		    T6J = T6D - T6E;
		    T6K = T6H + T6G;
		    O[WS(os, 28)] = FMA(KP390180644, T6J, KP1_961570560 * T6K);
		    O[WS(os, 60)] = FNMS(KP1_961570560, T6J, KP390180644 * T6K);
	       }
	       {
		    E T6B, T6C, T6F, T6I;
		    T6B = T6f - T6q;
		    T6C = T6z + T6w;
		    O[WS(os, 20)] = FMA(KP1_111140466, T6B, KP1_662939224 * T6C);
		    O[WS(os, 52)] = FNMS(KP1_662939224, T6B, KP1_111140466 * T6C);
		    T6F = T6D + T6E;
		    T6I = T6G - T6H;
		    O[WS(os, 12)] = FMA(KP1_662939224, T6F, KP1_111140466 * T6I);
		    O[WS(os, 44)] = FNMS(KP1_111140466, T6F, KP1_662939224 * T6I);
	       }
	  }
	  {
	       E T5L, T63, T5W, T66, T5S, T67, T5Z, T64, T5K, T5V;
	       T5K = KP707106781 * (T5s - T5r);
	       T5L = T5J + T5K;
	       T63 = T5J - T5K;
	       T5V = KP707106781 * (T4Q - T4V);
	       T5W = T5U - T5V;
	       T66 = T5V + T5U;
	       {
		    E T5O, T5R, T5X, T5Y;
		    T5O = FNMS(KP923879532, T5N, KP382683432 * T5M);
		    T5R = FMA(KP382683432, T5P, KP923879532 * T5Q);
		    T5S = T5O + T5R;
		    T67 = T5O - T5R;
		    T5X = FMA(KP923879532, T5M, KP382683432 * T5N);
		    T5Y = FNMS(KP923879532, T5P, KP382683432 * T5Q);
		    T5Z = T5X + T5Y;
		    T64 = T5Y - T5X;
	       }
	       {
		    E T5T, T60, T69, T6a;
		    T5T = T5L + T5S;
		    T60 = T5W - T5Z;
		    O[WS(os, 6)] = FMA(KP1_913880671, T5T, KP580569354 * T60);
		    O[WS(os, 38)] = FNMS(KP580569354, T5T, KP1_913880671 * T60);
		    T69 = T63 - T64;
		    T6a = T67 + T66;
		    O[WS(os, 30)] = FMA(KP196034280, T69, KP1_990369453 * T6a);
		    O[WS(os, 62)] = FNMS(KP1_990369453, T69, KP196034280 * T6a);
	       }
	       {
		    E T61, T62, T65, T68;
		    T61 = T5L - T5S;
		    T62 = T5Z + T5W;
		    O[WS(os, 22)] = FMA(KP942793473, T61, KP1_763842528 * T62);
		    O[WS(os, 54)] = FNMS(KP1_763842528, T61, KP942793473 * T62);
		    T65 = T63 + T64;
		    T68 = T66 - T67;
		    O[WS(os, 14)] = FMA(KP1_546020906, T65, KP1_268786568 * T68);
		    O[WS(os, 46)] = FNMS(KP1_268786568, T65, KP1_546020906 * T68);
	       }
	  }
	  {
	       E T4X, T5B, T5u, T5E, T5k, T5F, T5x, T5C, T4W, T5t;
	       T4W = KP707106781 * (T4Q + T4V);
	       T4X = T4L + T4W;
	       T5B = T4L - T4W;
	       T5t = KP707106781 * (T5r + T5s);
	       T5u = T5q - T5t;
	       T5E = T5t + T5q;
	       {
		    E T58, T5j, T5v, T5w;
		    T58 = FNMS(KP382683432, T57, KP923879532 * T52);
		    T5j = FMA(KP923879532, T5d, KP382683432 * T5i);
		    T5k = T58 + T5j;
		    T5F = T58 - T5j;
		    T5v = FMA(KP382683432, T52, KP923879532 * T57);
		    T5w = FNMS(KP382683432, T5d, KP923879532 * T5i);
		    T5x = T5v + T5w;
		    T5C = T5w - T5v;
	       }
	       {
		    E T5l, T5y, T5H, T5I;
		    T5l = T4X + T5k;
		    T5y = T5u - T5x;
		    O[WS(os, 2)] = FMA(KP1_990369453, T5l, KP196034280 * T5y);
		    O[WS(os, 34)] = FNMS(KP196034280, T5l, KP1_990369453 * T5y);
		    T5H = T5B - T5C;
		    T5I = T5F + T5E;
		    O[WS(os, 26)] = FMA(KP580569354, T5H, KP1_913880671 * T5I);
		    O[WS(os, 58)] = FNMS(KP1_913880671, T5H, KP580569354 * T5I);
	       }
	       {
		    E T5z, T5A, T5D, T5G;
		    T5z = T4X - T5k;
		    T5A = T5x + T5u;
		    O[WS(os, 18)] = FMA(KP1_268786568, T5z, KP1_546020906 * T5A);
		    O[WS(os, 50)] = FNMS(KP1_546020906, T5z, KP1_268786568 * T5A);
		    T5D = T5B + T5C;
		    T5G = T5E - T5F;
		    O[WS(os, 10)] = FMA(KP1_763842528, T5D, KP942793473 * T5G);
		    O[WS(os, 42)] = FNMS(KP942793473, T5D, KP1_763842528 * T5G);
	       }
	  }
	  {
	       E T33, T3l, T3h, T3m, T3a, T3p, T3e, T3o;
	       {
		    E T31, T32, T3f, T3g;
		    T31 = T15 - T1g;
		    T32 = T2E - T2D;
		    T33 = T31 + T32;
		    T3l = T31 - T32;
		    T3f = FMA(KP831469612, T34, KP555570233 * T35);
		    T3g = FNMS(KP831469612, T37, KP555570233 * T38);
		    T3h = T3f + T3g;
		    T3m = T3g - T3f;
	       }
	       {
		    E T36, T39, T3c, T3d;
		    T36 = FNMS(KP831469612, T35, KP555570233 * T34);
		    T39 = FMA(KP555570233, T37, KP831469612 * T38);
		    T3a = T36 + T39;
		    T3p = T36 - T39;
		    T3c = T2I - T2N;
		    T3d = T1s - T1D;
		    T3e = T3c - T3d;
		    T3o = T3d + T3c;
	       }
	       {
		    E T3b, T3i, T3r, T3s;
		    T3b = T33 + T3a;
		    T3i = T3e - T3h;
		    O[WS(os, 5)] = FMA(KP1_940062506, T3b, KP485960359 * T3i);
		    O[WS(os, 37)] = FNMS(KP485960359, T3b, KP1_940062506 * T3i);
		    T3r = T3l - T3m;
		    T3s = T3p + T3o;
		    O[WS(os, 29)] = FMA(KP293460948, T3r, KP1_978353019 * T3s);
		    O[WS(os, 61)] = FNMS(KP1_978353019, T3r, KP293460948 * T3s);
	       }
	       {
		    E T3j, T3k, T3n, T3q;
		    T3j = T33 - T3a;
		    T3k = T3h + T3e;
		    O[WS(os, 21)] = FMA(KP1_028205488, T3j, KP1_715457220 * T3k);
		    O[WS(os, 53)] = FNMS(KP1_715457220, T3j, KP1_028205488 * T3k);
		    T3n = T3l + T3m;
		    T3q = T3o - T3p;
		    O[WS(os, 13)] = FMA(KP1_606415062, T3n, KP1_191398608 * T3q);
		    O[WS(os, 45)] = FNMS(KP1_191398608, T3n, KP1_606415062 * T3q);
	       }
	  }
	  {
	       E T4h, T4z, T4v, T4A, T4o, T4D, T4s, T4C;
	       {
		    E T4f, T4g, T4t, T4u;
		    T4f = T3t + T3u;
		    T4g = T3X + T3Y;
		    T4h = T4f - T4g;
		    T4z = T4f + T4g;
		    T4t = FMA(KP980785280, T4i, KP195090322 * T4j);
		    T4u = FMA(KP980785280, T4l, KP195090322 * T4m);
		    T4v = T4t - T4u;
		    T4A = T4t + T4u;
	       }
	       {
		    E T4k, T4n, T4q, T4r;
		    T4k = FNMS(KP980785280, T4j, KP195090322 * T4i);
		    T4n = FNMS(KP980785280, T4m, KP195090322 * T4l);
		    T4o = T4k + T4n;
		    T4D = T4k - T4n;
		    T4q = T3V + T3U;
		    T4r = T3y - T3B;
		    T4s = T4q - T4r;
		    T4C = T4r + T4q;
	       }
	       {
		    E T4p, T4w, T4F, T4G;
		    T4p = T4h + T4o;
		    T4w = T4s - T4v;
		    O[WS(os, 7)] = FMA(KP1_883088130, T4p, KP673779706 * T4w);
		    O[WS(os, 39)] = FNMS(KP673779706, T4p, KP1_883088130 * T4w);
		    T4F = T4z + T4A;
		    T4G = T4D + T4C;
		    O[WS(os, 31)] = FMA(KP098135348, T4F, KP1_997590912 * T4G);
		    O[WS(os, 63)] = FNMS(KP1_997590912, T4F, KP098135348 * T4G);
	       }
	       {
		    E T4x, T4y, T4B, T4E;
		    T4x = T4h - T4o;
		    T4y = T4v + T4s;
		    O[WS(os, 23)] = FMA(KP855110186, T4x, KP1_807978586 * T4y);
		    O[WS(os, 55)] = FNMS(KP1_807978586, T4x, KP855110186 * T4y);
		    T4B = T4z - T4A;
		    T4E = T4C - T4D;
		    O[WS(os, 15)] = FMA(KP1_481902250, T4B, KP1_343117909 * T4E);
		    O[WS(os, 47)] = FNMS(KP1_343117909, T4B, KP1_481902250 * T4E);
	       }
	  }
	  {
	       E T1F, T2T, T2P, T2W, T2y, T2X, T2C, T2U;
	       {
		    E T1h, T1E, T2F, T2O;
		    T1h = T15 + T1g;
		    T1E = T1s + T1D;
		    T1F = T1h + T1E;
		    T2T = T1h - T1E;
		    T2F = T2D + T2E;
		    T2O = T2I + T2N;
		    T2P = T2F + T2O;
		    T2W = T2F - T2O;
	       }
	       {
		    E T26, T2x, T2A, T2B;
		    T26 = FNMS(KP195090322, T25, KP980785280 * T1W);
		    T2x = FMA(KP980785280, T2n, KP195090322 * T2w);
		    T2y = T26 + T2x;
		    T2X = T26 - T2x;
		    T2A = FMA(KP195090322, T1W, KP980785280 * T25);
		    T2B = FNMS(KP195090322, T2n, KP980785280 * T2w);
		    T2C = T2A + T2B;
		    T2U = T2B - T2A;
	       }
	       {
		    E T2z, T2Q, T2Z, T30;
		    T2z = T1F + T2y;
		    T2Q = T2C + T2P;
		    O[WS(os, 1)] = FNMS(KP098135348, T2Q, KP1_997590912 * T2z);
		    O[WS(os, 33)] = -(FMA(KP098135348, T2z, KP1_997590912 * T2Q));
		    T2Z = T2T - T2U;
		    T30 = T2X + T2W;
		    O[WS(os, 25)] = FMA(KP673779706, T2Z, KP1_883088130 * T30);
		    O[WS(os, 57)] = FNMS(KP1_883088130, T2Z, KP673779706 * T30);
	       }
	       {
		    E T2R, T2S, T2V, T2Y;
		    T2R = T1F - T2y;
		    T2S = T2C - T2P;
		    O[WS(os, 17)] = FMA(KP1_343117909, T2R, KP1_481902250 * T2S);
		    O[WS(os, 49)] = FNMS(KP1_481902250, T2R, KP1_343117909 * T2S);
		    T2V = T2T + T2U;
		    T2Y = T2W - T2X;
		    O[WS(os, 9)] = FMA(KP1_807978586, T2V, KP855110186 * T2Y);
		    O[WS(os, 41)] = FNMS(KP855110186, T2V, KP1_807978586 * T2Y);
	       }
	  }
	  {
	       E T3D, T47, T43, T48, T3S, T4b, T40, T4a;
	       {
		    E T3v, T3C, T41, T42;
		    T3v = T3t - T3u;
		    T3C = T3y + T3B;
		    T3D = T3v + T3C;
		    T47 = T3v - T3C;
		    T41 = FMA(KP555570233, T3G, KP831469612 * T3J);
		    T42 = FNMS(KP555570233, T3N, KP831469612 * T3Q);
		    T43 = T41 + T42;
		    T48 = T42 - T41;
	       }
	       {
		    E T3K, T3R, T3W, T3Z;
		    T3K = FNMS(KP555570233, T3J, KP831469612 * T3G);
		    T3R = FMA(KP831469612, T3N, KP555570233 * T3Q);
		    T3S = T3K + T3R;
		    T4b = T3K - T3R;
		    T3W = T3U - T3V;
		    T3Z = T3X - T3Y;
		    T40 = T3W - T3Z;
		    T4a = T3Z + T3W;
	       }
	       {
		    E T3T, T44, T4d, T4e;
		    T3T = T3D + T3S;
		    T44 = T40 - T43;
		    O[WS(os, 3)] = FMA(KP1_978353019, T3T, KP293460948 * T44);
		    O[WS(os, 35)] = FNMS(KP293460948, T3T, KP1_978353019 * T44);
		    T4d = T47 - T48;
		    T4e = T4b + T4a;
		    O[WS(os, 27)] = FMA(KP485960359, T4d, KP1_940062506 * T4e);
		    O[WS(os, 59)] = FNMS(KP1_940062506, T4d, KP485960359 * T4e);
	       }
	       {
		    E T45, T46, T49, T4c;
		    T45 = T3D - T3S;
		    T46 = T43 + T40;
		    O[WS(os, 19)] = FMA(KP1_191398608, T45, KP1_606415062 * T46);
		    O[WS(os, 51)] = FNMS(KP1_606415062, T45, KP1_191398608 * T46);
		    T49 = T47 + T48;
		    T4c = T4a - T4b;
		    O[WS(os, 11)] = FMA(KP1_715457220, T49, KP1_028205488 * T4c);
		    O[WS(os, 43)] = FNMS(KP1_028205488, T49, KP1_715457220 * T4c);
	       }
	  }
     }
}

static const khc2r_desc desc = { 64, "hc2rIII_64", {342, 116, 92, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2rIII_64) (planner *p) {
     X(khc2rIII_register) (p, hc2rIII_64, &desc);
}

#endif				/* HAVE_FMA */
