function  new_gradients=Orth(gradients,oldgradients);

global client_server_mode IMDataCounter

%outpu 
new_gradients=gradients;

numparams=length(gradients);
for i=1:numparams,

	%recover gradient  #i
	gradient=gradients{i};
	oldgradient=oldgradients{i};
	
	if isempty(oldgradient),
		oldgradient=zeros(length(gradient),1);
	end

	% normalize gradient #i to 1
	gradient=gradient/norm(gradient);

	% rough orthagonalization
	gradient=gradient-(gradient'*oldgradient)*oldgradient; 
	
	% renormalize gradients 
	gradient=gradient/norm(gradient);

	%plug back into gradients
	new_gradients{i}=gradient;
end
