function B=GetBprime_prog(triaelem,xyz_list,gauss_coord)
%GETBPRIME_PROG - compute the B matrix for a prognostic
%
%   Compute B  matrix. B=[B1 B2 B3 ] where Bi is of size numgrids*NDOF
%   For grid i, Bi can be expressed in the basic coordinate system by:
%   Bi_basic=[dh/dx]
%            [dh/dy]
%   where h is the interpolation function for grid i.
%
%   Usage:
%      B=GetBprime_prog(triaelem,xyz_list,gauss_coord)
%
%   See also GETB_PROG, CREATEKMATRIX 

	num_grids=3;	

	dh1dh6_basic=GetNodalFunctionsDerivativesBasic(triaelem,xyz_list,gauss_coord);
	%Build B:
	B=zeros(2,num_grids);
	for i=1:num_grids,
		B(1,i)=dh1dh6_basic(1,i);
		B(2,i)=dh1dh6_basic(2,i);
	end
