%
%  constructor for the nonlinear_inequality_constraint class.
%
%  [nic]=nonlinear_inequality_constraint(varargin)
%
classdef nonlinear_inequality_constraint
    properties
        descriptor='';
        lower     = NaN;
        upper     = NaN;
        scale_type='none';
        scale     = 1.;
    end
    
    methods
        function [nic]=nonlinear_inequality_constraint(varargin)

            switch nargin

 %  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'nonlinear_inequality_constraint')
                        nic=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'nonlinear_inequality_constraint');
                    end

%  create the object from the input

                otherwise
                    nic.descriptor=varargin{1};
                    nic.lower     =varargin{2};
                    nic.upper     =varargin{3};

                    if (nargin >= 4)
                        nic.scale_type=varargin{4};
                        if (nargin >= 5)
                            nic.scale     =varargin{5};

                            if (nargin > 5)
                                warning('objective_function:extra_arg',...
                                    'Extra arguments for object of class ''%s''.',...
                                    class(nic));
                            end
                        end
                    end
            end

        end
        function [desc]  =dresp_desc(nic)
            desc=cell(size(nic));
            for i=1:numel(nic)
                desc(i)=cellstr(nic(i).descriptor);
            end
        end
        function [stype ]=dresp_stype(nic)
            stype=cell(size(nic));
            for i=1:numel(nic)
                stype(i)=cellstr(nic(i).scale_type);
            end
        end
        function [scale] =dresp_scale(nic)
            scale=zeros(size(nic));
            for i=1:numel(nic)
                scale(i)=nic(i).scale;
            end
        end
        function [weight]=dresp_weight(nic)
            weight=[];
        end
        function [lower] =dresp_lower(nic)
            lower=zeros(size(nic));
            for i=1:numel(nic)
                lower(i)=nic(i).lower;
            end
        end
        function [upper] =dresp_upper(nic)
            upper=zeros(size(nic));
            for i=1:numel(nic)
                upper(i)=nic(i).upper;
            end
        end
        function [target]=dresp_target(nic)
            target=[];
        end
    end
end
