C***********************************************************************
C LHS (Latin Hypercube Sampling) UNIX Library/Standalone. 
C Copyright (c) 2004, Sandia Corporation.  Under the terms of Contract
C DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
C retains certain rights in this software.
C
C This software is distributed under the GNU General Public License.
C For more information, see the README file in the LHS directory. 
C***********************************************************************
C     Last change:  SLD  23 May 101   12:35 pm
      Subroutine RDPAR2
cc    changes made to interal read statements;                          sld01
cc                some KLLERR test deactivated                          sld01
c
c     -- This routine reads from Input Unit 5 the distributions and
c     -- correlations for the new input format.  We only look for
c     -- things that are:
c     --      (a) on a line that starts with "DATA:"
c     --      (b) in a block that follows the keyword "DATASET:"
c     -- A line can contain either data item definition information or
c     -- information regarding the correlation between variables.
c
c     -- Each data item definiton line contains the following fields:
c     --       name of the data item
c     --       point estimate value (optional - ignored in LHS)
c     --       definition of the data item which may be
c     --          "FILE filename" --> read from a file (ignored in LHS),
c     --          "= expression"  --> produced by an LHS post-processor
c     --                              (ignored in LHS), or
c     --          distribution definition information
c
c     -- Each correlation information line contains the names of two
c     -- data items and a value between -1.0 and 1.0 which is the
c     -- desired correlation that is to be induced between these two items.
c
c     -- This routine uses the variable IDSet to mark whether or not a
c     -- "DATASET:" statement has been encountered.  Until DATASET: is
c     -- found, IDSet=0.  When DATASET: is found, IDSET=1 (indicating that
c     -- all records are to be examined - not just those beginning with
c     -- the keyword "DATA:".  IDSet is set back to zero when any of the
c     -- following keywords are found: BINNING:, SORTING: or REBINNING:.
c
c     -- This section of code operates as follows:
c     --
c     -- Do
c     --    Read a line from the file; exit loop on end of file
c     --
c     --    If first field is "DATASET:" --> IDSet = 1
c     --    If IDSet = 0 and the first item is not "DATA:" --> cycle
c     --    If IDSet = 1 and the first item is "BINNING:", "SORTING:", or
c     --       "REBINNING:" --> IDSet = 0 --> cycle (end of DATASET: block)
c     --    If line begins with "DATA:" --> strip 5 characters and left justify
c     --
c     --    If next token is "CORRELATE" Then
c     --       Get names of distributions to be correlated
c     --       If names not already in list, make places for them in the list
c     --       Find distribution numbers from list of names
c     --       Check and save the correlation information
c     --    Else
c     --       Get distribution information from the line as described above
c     --       If described by "FILE" or "=" --> cycle
c     --       If name already in list and distribution defined --> error
c     --       If name already in list and no dist defined --> save dist info
c     --       Otherwise establish a new dist name and save dist info
c     --       Check distribution information
c     --    End If
c     --
c     -- End Do
c     --
c     -- Check the list of distributions to assure that all distribution names
c     -- have defined distribution information that can be generated by LHS
c
C     INCLUDE 'KILLFILE.INC'                                            GDW-96  
      USE KILLFILE                      
c
C     INCLUDE 'PARMS.INC'                                               GDW-96  
      USE PARMS                         
c     PARMS provides:  MAXTB,LENC
C     INCLUDE 'CPARAM.INC'                                              GDW-96  
      USE CPARAM                        
c     CPARAM provides:  IPtVal and arrays List,PValue,IVarNam,IDist
C     INCLUDE 'DISTNM.INC'                                              GDW-96  
      USE DISTNM                        
c     DISTNM provides:  LEND,MAXPAR and arrays IDSST,IDSEND,IDSPAR
C     INCLUDE 'CWORKX.INC'                                              GDW-96  
      USE CWORKX, XVLZ => XX
c     CWORKX provides: arrays XVLZ,PRBZ
c
c
C     These statements removed to make modules work - GDW-96
C     COMMON/STAR/NSUBOB(NINTMX),SUBINT(NINTMX+1),NINT
      USE STAR
C     COMMON/UICORR/ICVAR(NCVAR),JCVAR(NCVAR),CVAR(NCVAR),NCV
      USE UICORR
C     These statements removed to make modules work - GDW-96
C     DIMENSION XVLZ(MAXTB), PRBZ(MAXTB)
C     EQUIVALENCE (XX(1),XVLZ(1))
C     EQUIVALENCE (XX(MAXTB+1), PRBZ(1))
c
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER CDUM1*5, CDUM2*12                                       sld01
      DATA CDUM1,CDUM2/' ',' '/                                         sld01
c
      Character Card*(LENC)
      Character*32768 LCard
c------------------------------------------------------------------------
c     NOTE: LCard length increased for use by the binary 'lhsdrv';
c     the card length was not sufficient for the options it needed.
c     2/2/2004 - slbrow
c------------------------------------------------------------------------
c$$$  Character*40 LCard
      Character*(NamLen) Name, Name2
      Character*35 NamVal
      Dimension A(MAXPAR)
C
      Logical Err
c
c     --Set Default Parameter Values
c
ccc***The following information is duplicated in LHS_INIT
      NNames = 0
      NCV = 0
      ICM = 0
ccc***End of information duplicated in LHS_INIT
      IDSet = 0
      Err = .False.
c
      Do While (.True.)
c
c        -- read a card and exit loop on end of file
         Call NewCrd(Card,5,IEnd)
cc         If(KLLERR) Return   NewCrd has no error conditions           sld01
         If ( IEnd /= 0 ) Exit
c
c        -- switch into IDSet mode if DATASET: keyword is found
         If ( Card(1:8) == 'DATASET:') Then
            IDSet = 1
            Cycle
         End If
c
         If ( IDSet == 0 ) Then
c           -- when not in IDSet mode, only take DATA: records
            If ( Card(1:5) /= 'DATA:' ) Then
               cycle
            End If
         Else
c           -- determine if we need to switch out of IDSet mode
            If ( Card(1:8)  == 'BINNING:'  .OR.
     1           Card(1:8)  == 'SORTING:'  .OR.
     2           Card(1:10) == 'REBINNING:'     ) Then
               IDSet = 0
               Cycle
            End If
         End If
c
c        -- Prepare the record for processing by stripping off the
c        -- leading DATA: keyword and leading blanks
         If ( Card(1:5) == 'DATA:' ) Then
            Card = Card(6:)
            Call LJust(Card)
cc            If(KLLERR) Return  LJust does not have error conditions   sld01
         End If
c        -- if all that remains on the card is blank, then ignore card
         If (Card == ' ') cycle
c
c        -- Now we know that we have something to process
c
ccc***The following information is duplicated in LHS_CORR
         If ( Card(1:10) == 'CORRELATE ' ) Then
c
c           -- Process correlation information
c
c           -- strip off the keyword and left-justify
            Card = Card(10:)
            Call LJust(Card)
cc            If(KLLERR) Return   LJust has no error conditions         sld01
c
c           -- first variable name is now left justified - get it
            ISpc = Index(Card,' ')
            Name = Card(1:ISpc-1)
            Card = Card(ISpc:)
            Call LJust(Card)
cc            If(KLLERR) Return    LJust has no error conditions        sld01
c
c           -- second variable name is now left justified - get it
            ISpc = Index(Card,' ')
            Name2 = Card(1:ISpc-1)
            Card = Card(ISpc:)
            Call LJust(Card)
cc            If(KLLERR) Return      LJust has no error conditions      sld01
c
c           -- check to see that neither name is blank
            If ( Name == ' '  .OR.  Name2 == ' ' ) Then
               Print *,'Error: two non-blank names must be specified'
               Print *,'when specifying correlation between variables.'
               Print *,'The following names were found: ',Name
               Print *,'                           and: ',Name2
c****** add prints to message and error files
               Write(99,*)'Error: two non-blank names must be specified'
               Write(99,*)'when specifying correlation between '
     1 ,           'variables.'
               Write(99,*)'The following names were found: ',Name
               Write(99,*)'                           and: ',Name2
               Write(6,*)'Error: two non-blank names must be specified'
               Write(6,*)'when specifying correlation between '
     1 ,           'variables.'
               Write(6,*)'The following names were found: ',Name
               Write(6,*)'                           and: ',Name2
c******
              Err = .True.
            End If
c
c           -- Correlation value is now left justified - get it and check
c           -- that it is in the range -1.0 < Value < 1.0
            Read (Card,*,Err=151) Value

            If ( Name /= Name2  .AND.  Abs(Value) >= 1.0 ) Then
               Print *, 'Error: The absolute value of all correlation',
     1            ' values must be less than 1.0'
               Print *, 'The following correlation was found:'
               Print *, 'CORRELATE ', Name, Name2, Value
c****** add prints to message and error files
               Write(99,*) 'Error: The absolute value of all ',
     1            'correlation values must be less than 1.0'
               Write(99,*) 'The following correlation was found:'
               Write(99,*) 'CORRELATE ', Name, Name2, Value
               Write(6,*) 'Error: The absolute value of all ',
     1            'correlation values must be less than 1.0'
               Write(6,*) 'The following correlation was found:'
               Write(6,*) 'CORRELATE ', Name, Name2, Value
c******
              Err = .True.
            End If
c
c           -- Now increment the correlation counter, determine which
c           -- variable numbers correspond to the given names, and
c           -- store this pair's correlation data in ICVAR, JCVAR and CVAR
c
            IFound = 0
            JFound = 0
            Do i=1, NNames
               If ( Name == List(i) ) Then
                  IFound = 1
                  IList = i
                  If (JFound == 1) Exit
               End If
               If ( Name2 == List(i) ) Then
                  JFound = 1
                  JList = i
                  If (IFound == 1) Exit
               End If
            End Do
c
c           -- If name not found in list, add to the list
            If (IFound == 0) Then
               NNames = NNames + 1
               IList = NNames
               List(IList) = Name
            End If
            If (Name == Name2) Then
c              -- both names are the same - correlation must be 1.00
               JList = IList
               If ( Abs(1.0-Value) > 1.0E-06 ) Then
                  Print *, 'Error: If a variable is to be correlated ',
     1              'with itself, the correlation must be 1.0'
                  Print *, 'CORRELATE ', Name, Name2, Value
c****** add prints to message and error files
                  Write(99,*) 'Error: If a variable is to be correlated'
     1,              ' with itself, the correlation must be 1.0'
                  Write(99,*) 'CORRELATE ', Name, Name2, Value
                  Write(6,*) 'Error: If a variable is to be correlated',
     1              ' with itself, the correlation must be 1.0'
                  Write(6,*) 'CORRELATE ', Name, Name2, Value
c******
                 Err = .True.
               End If
            Else If (JFound == 0) Then
               NNames = NNames + 1
               JList = NNames
               List(JList) = Name2
            End If
c
c           -- Store this pair's correlation data in ICVAR, JCVAR and CVAR.
c           -- These will be checked in CMCRD.
            ICM = 1
            NCV = NCV + 1
            ICVAR(NCV) = IList
            JCVAR(NCV) = JList
            CVAR(NCV) = Value
c
c           -- now done with the correlation record so cycle and repeat the
c           -- whole process with a new record
            Cycle
c
c           -- Error reading value
 151        Print *, 'Correlation Value read was not a number'
            Print *, Name, Name2, Card
c****** add prints to message and error files
            Write(99,*) 'Correlation Value read was not a number'
            Write(99,*) Name, Name2, Card
            Write(6,*) 'Correlation Value read was not a number'
            Write(6,*) Name, Name2, Card
c******
           Err = .True.
c
         End If
ccc***End of information duplicated in LHS_CORR
c
c        -- Since it was not a correlation record, it must be a
c        -- definition for a named data item
c
c        -- get the name and strip it out of Card, then left justify
c
         ISpc = Index(Card,' ')
         Name = Card(1:ISpc-1)
         Card = Card(ISpc:)
         Call LJust(Card)
cc         If(KLLERR) Return      LJust has no error conditions         sld01
c
c        -- now check for the optional point value
c
         IVFnd = 0
         NamVal = Name
         If ( Card == ' ' ) Go To 201
c------------------------------------------------------------------------
c     NOTE: Four additional goto's added to address issue with non-
c     portable behavior; list-directed input is being used in:
c
c$$$  Read(Card,*,Err=201) Value
c
c     which is an internal file read.  The F90 ANSI standard forbids this
c     usage while various compilers allow it as a non-standard extension.
c         
c     The behavior was that a value of -1.0 was being read for the
c     variable 'Value' from the 'Card' variable when there was no reason
c     to do so (i.e., list-directed, so do what you want).  This behavior
c     was recorded with keywords beginning with 'D', 'E' and 'T', hence
c     the goto's below escape those cases while allowing others to use
c     the original syntax.
c     
c     2/17/2004 - slbrow
c------------------------------------------------------------------------
         If ( Card(1:8) == "DISCRETE" ) Go To 201
         If ( Card(1:11) == "EXPONENTIAL" ) Go To 201
         If ( Card(1:10) == "TRIANGULAR" ) Go To 201
         If ( Card(1:9) == "TRUNCATED" ) Go To 201
c------------------------------------------------------------------------
         Read(Card,*,Err=201) Value
c        -- value was found, so strip it off and left justify
         IVFnd = 1
         ISpc = Index(Card,' ')
         Card = Card(ISpc:)
         Call LJust(Card)
cc         If(KLLERR) Return    LJust has no error conditions           sld01
c        -- Put the name and point value into the NamVal string
         Write (NamVal,202) Name, Value
 202     Format (A16,4X,1PE14.7)
c
c        -- now check for 'FILE' or '=' and reject those types of records
c
 201     If ( Card(1:1) == '='  .OR.  Card(1:4) == 'FILE' ) Then
            Call LRead(Card, LCard, LCLen)
            If(KLLERR) Return
            cycle
         End If
c
c        -- check the name against the existing list of names
c
ccc***The following information is duplicated in LHS_DIST, LHS_SDIST,
ccc***   LHS_UDIST, LHS_CONST and LHS_SAMEAS
         IFound = 0
         Do i=1, NNames
            If ( Name == List(i) ) Then
               IFound = 1
               IList = i
               If (IVarNm(i) /= 0) Then
c                 -- duplicate definition found
                  Print *, 'Multiple definitions found for ', Name
c****** add prints to message and error files
                  Write(99,*) 'Multiple definitions found for ', Name
                  Write(6,*) 'Multiple definitions found for ', Name
c******
                  Err = .True.
               End If
               Exit
            End If
         End Do
c        -- If name not found in list, add to the list
         If (IFound == 0) Then
            NNames = NNames + 1
            IList = NNames
            List(IList) = Name
         End If
ccc***End of information duplicated in LHS_SAMEAS
c
c        -- If no point value found and LHSPVAL 0 is specified, then
c        -- declare an error and stop.
c
         If ( IPtVal == 0  .AND.  IVFnd == 0 ) Then
            Print *, 'Error: When the keyword LHSPVAL 0 is present, ',
     1               'all point values must be specified.'
            Print *, 'Point value missing for ', Name
c****** add prints to message and error files
            Write(99,*) 'Error: When the keyword LHSPVAL 0 is ',
     1               'present, all point values must be specified.'
            Write(99,*) 'Point value missing for ', Name
            Write(6,*) 'Error: When the keyword LHSPVAL 0 is ',
     1               'present, all point values must be specified.'
            Write(6,*) 'Point value missing for ', Name
c******
           Err = .True.
         End If
         If ( IVFnd /= 0 ) PValue(IList) = Value
ccc***End of information duplicated in LHS_DIST, LHS_SDIST,
ccc***   LHS_UDIST and LHS_CONST
c
c        -- read the full distribution information for Name (including
c        -- any continuation lines) and put it into LCard
c
         Call LRead(Card, LCard, LCLen)
         If(KLLERR) Return
c
c        -- Check for the "Constant" distribution type
c
ccc***The following information is duplicated in LHS_CONST
         If ( LCard(1:9) == 'CONSTANT ' ) Then
            IVarNm(IList) = -9999999
cc            Read (LCard(10:),*,Err=9000) Value                        sld01
            Read (LCard(10:),*,Err=9000,END=9000) Value                 sld01
            If ( IPtVal /= 0 ) PValue(IList) = Value
            Cycle
         End If
ccc***End of information duplicated in LHS_CONST
c
c        -- Check for the "Same As" distribution type
c
ccc***The following information is duplicated in LHS_SAMEAS
         If ( LCard(1:8) == 'SAME AS ' ) Then
            Card = LCard(9:)
            Call LJust(Card)
cc            If(KLLERR) Return     LJust has no error conditions       sld01
cc            Read (Card,*,Err=9000) Name                               sld01
            Read (Card,*,Err=9000,END=9000) Name                        sld01
c           -- check that there is only one name on the line
            ISp = Index(Card,' ')
            Card = Card(ISp:)
            Call LJust(Card)
cc            If(KLLERR) Return   LJust has no error conditions         sld01
            If ( Card /= ' ' ) Then
               Card = LCard
               Print *, 'Error: too many names found on a Same As ',
     1                  'distribution definition record.'
               Print *, List(IList), ' SAME AS ', Card(1:50)
c****** add prints to message and error files
               Write(99,*) 'Error: too many names found on a Same',
     1                  ' As distribution definition record.'
               Write(99,*) List(IList), ' SAME AS ', Card(1:50)
               Write(6,*) 'Error: too many names found on a Same',
     1                  ' As distribution definition record.'
               Write(6,*) List(IList), ' SAME AS ', Card(1:50)
c******
               Err = .True.
            End If
c           -- check the name against the existing list of names
            IFound = 0
            Do i=1, NNames
               If ( Name == List(i) ) Then
                  IFound = 1
                  ISame = i
                  Exit
               End If
            End Do
c           -- If name not found in list, add to the list
            If (IFound == 0) Then
               NNames = NNames + 1
               ISame = NNames
               List(ISame) = Name
            End If
c           -- Now set the distribution information for LHS
            IVarNm(IList) = -ISame
            Cycle
         End If
ccc***End of information duplicated in LHS_SAMEAS
c
c        -- Read and check all distributions with a known no. of parameters
c
ccc***The following information is duplicated in LHS_DIST
         IFound = 0
         Do ID=1,LEND
            If ( IDSPAR(ID) < 1 ) Cycle
            IDL=IDSEND(ID)-IDSST(ID)+1
            IDL1=IDL+1
            If ( LCard(1:IDL) .EQ. DIST(IDSST(ID):IDSEND(ID))) THEN
cc               Read (LCard(IDL1:),*,Err=9000) (A(I),I=1,IDSPAR(ID))   sld01
               Read (LCard(IDL1:),*,Err=9000,END=9000)                  sld01
     x              (A(I),I=1,IDSPAR(ID))                               sld01
               CALL CHKDAT ( DIST(IDSST(ID):IDSEND(ID)), A, MAXPAR)
               If(KLLERR) Return
               CALL WRTCRD ( ID, NamVal)
cc               If(KLLERR) Return   WRTCRD has no error conditions     sld01
               IVarNm(IList) = NV
               IFound = 1
               Exit
            END IF
         End Do
c
c        -- If IFound = 1 then we have successfully completed a Distribution
ccc***End of information duplicated in LHS_DIST
c        -- record, so repeat the loop with another input file record
         If ( IFound == 1 ) Cycle
c
ccc***The following information is duplicated in LHS_SDIST
c        -- Read and check the * distributions
c
         Do ID=1, LEND
            If ( IDSPAR(ID) /= -1 ) Cycle
            IDL=IDSEND(ID)-IDSST(ID)+1
            IDL1=IDL+1
            IF ( LCard(1:IDL) .EQ. DIST(IDSST(ID):IDSEND(ID))) THEN
cc               Read (LCard(IDL1:),*,ERR=9000) NINT                    sld01
cc             Read (LCard(IDL1:),*,ERR=9000) NINT,(NSUBOB(I),I=1,NINT),sld01
cc     1                            (SUBINT(I),I=1,NINT+1)              sld01
               Read (LCard(IDL1:),*,ERR=9000,END=9000) NINT             sld01
               Read (LCard(IDL1:),*,ERR=9000,END=9000) NINT,            sld01
     1               (NSUBOB(I),I=1,NINT),(SUBINT(I),I=1,NINT+1)        sld01
               CALL CHKSTR ( DIST(IDSST(ID):IDSEND(ID)), CARD)
               If(KLLERR) Return
               CALL WRTCRD ( ID, NamVal)
CC               If(KLLERR) Return    WRTCRD has no error conditions	sld01
               IVarNm(IList) = NV
               IFound = 1
               Exit
            END IF
         End Do
c
c        -- If IFound = 1 then we have successfully completed a Distribution
ccc***End of information duplicated in LHS_SDIST
c        -- record, so repeat the loop with another input file record
         If ( IFound == 1 ) Cycle
c
ccc***The following information is duplicated in LHS_UDIST
c        -- Read and check empirical cumulative and density functions
c
         Do ID=1, LEND
            If ( IDSPAR(ID) /= -2) Cycle
            IDL=IDSEND(ID)-IDSST(ID)+1
            IDL1=IDL+1
            IF ( LCard(1:IDL) .EQ. DIST(IDSST(ID):IDSEND(ID))) THEN
cc               Read (LCard(IDL1:),*,ERR=9000) NP                      sld01
               Read (LCard(IDL1:),*,ERR=9000,END=9000) NP               sld01
               IF (NP .GT. MAXTB) THEN
                  WRITE (6, 9010) MAXTB, NP, CARD
                  Err = .True.
               ELSE IF (NP .LT. 2) THEN
                  WRITE (6,9011) NP, CARD
                  Err = .True.
               END IF
cc               READ (LCard(IDL1:),*,ERR=9000) NP,                     sld01
               READ (LCard(IDL1:),*,ERR=9000,END=9000) NP,              sld01
     1                    (XVLZ(I), PRBZ(I), I=1, NP)
               CALL CHKEMP ( DIST(IDSST(ID):IDSEND(ID)), PRBZ, XVLZ,
     1                       NP, MAXTB)
               If(KLLERR) Return
               CALL WRTCRD ( ID, NamVal)
CC               If(KLLERR) Return     WRTCRD has no error conditions   sld01
               IVarNm(IList) = NV
               IFound = 1
               Exit
            End If
         End Do
c
c        -- If IFound = 1 then we have successfully completed a Distribution
ccc***End of information duplicated in LHS_UDIST
c        -- record, so repeat the loop with another input file record
         If ( IFound == 1 ) Cycle
c
c        -- If the program gets here, then an
c        -- undefined parameter/data card was found
         Write(6,9004)NamVal,Card
         Err = .True.
c
      End Do
c
c     -- Stop if an error was encountered during the file read
      If (Err) Then
         Write(99,*) ' Error was encountered during the file read'
         Write(6,*) ' Error was encountered during the file read'
         KLLERR = .TRUE.
         RETURN
      Endif
c
ccc***The following information is duplicated in LHS_PREP
c     -- If LHS was not required to run in this case (NNames=0), the
c     -- LHS program should die gracefully here.
      If (NNames == 0) Then
         Print *, 'No information for LHS to process.'
         Print *, 'LHS termination.'
         Write(99,*) 'No information for LHS to process.'
         Write(99,*) 'LHS termination.'
         Write(6,*) 'No information for LHS to process.'
         Write(6,*) 'LHS termination.'
         Call FileOC(0)
         If(KLLERR) Return
         KLLERR = .TRUE.
         RETURN
      End If
c
c     -- Now check that each named data item found has a valid distribution
c     -- associated with it.  If not, it appeared on a Correlate record
c     -- but either had no definition or was defined in a file or
c     -- post-processor record.  Either way, it is an error and LHS can
c     -- not continue processing.  Also, one "Same As" record can not point
c     -- to another "Same As" record - it must point to a defined
c     -- distribution, so check "Same As" records to assure that the
c     -- IVarNm pointed to is positive.
c
      Do i=1, NNames
         If (IVarNm(i) == 0) Then
            Print *, 'Distribution required, not found for ', List(i)
c****** add prints to message and error files
            Write(99,*) 'Distribution required, not found for '
     1, List(i)
            Write(6,*) 'Distribution required, not found for '
     1, List(i)
c******
            Err = .True.
         End If
         If (IVarNm(i) < 0  .AND.  IVarNm(i) /= -9999999) Then
            j = -IVarNm(i)
            If (IVarNm(j) < 0  .AND.  IVarNm(j) /= -9999999) Then
               Print *, 'One distribution of type Same As points to ',
     1            'another Same As distribution.'
               Print *, 'This is invalid.  Each Same As distribution ',
     1            'may only point to an'
               Print *, 'explicitly defined distribution.'
               Print *, List(i), ' Same As ', List(j)
c****** add prints to message and error files
               Write(99,*) 'One distribution of type Same As points',
     1            ' to another Same As distribution.'
               Write(99,*) 'This is invalid.  Each Same As ',
     1            'distribution may only point to an'
               Write(99,*) 'explicitly defined distribution.'
               Write(99,*) List(i), ' Same As ', List(j)
               Write(6,*) 'One distribution of type Same As points',
     1            ' to another Same As distribution.'
               Write(6,*) 'This is invalid.  Each Same As ',
     1            'distribution may only point to an'
               Write(6,*) 'explicitly defined distribution.'
               Write(6,*) List(i), ' Same As ', List(j)
c******
               Err = .True.
            End If
         End If
      End Do
c
c     -- Now replace the current contents of ICVAR and JCVAR
c     -- They were originally set to point to the List array contents,
c     -- but they need to correspond to the order in which the distributions
c     -- were defined (IVarNm(i)).  This transformation made here to prepare
c     -- the data for the CMCRD routine.
c
      If (ICM == 1) Then
         Do i=1, NCV
            ij = ICVar(i)
            ICVar(i) = IVarNm(ij)
            jj = JCVar(i)
            JCVar(i) = IVarNm(jj)
c
            If ( ICVar(i) == -9999999 ) Then
               Print *, 'Error: Distributions of type Constant can ',
     1            'not be correlated to other distributions.'
               Print *, List(ij),' is CONSTANT'
c****** add prints to message and error files
               Write(99,*) 'Error: Distributions of type Constant can',
     1            ' not be correlated to other distributions.'
               Write(99,*) List(ij),' is CONSTANT'
               Write(6,*) 'Error: Distributions of type Constant can',
     1            ' not be correlated to other distributions.'
               Write(6,*) List(ij),' is CONSTANT'
c******
               Err = .True.
            Else If ( ICVar(i) <= 0 ) Then
               Print *, 'Error: Distributions of type Same As can ',
     1            'not be correlated to other distributions.'
               Print *, List(ij),' SAME AS ', List(-ICVar(i))
c****** add prints to message and error files
               Write(99,*) 'Error: Distributions of type Same As can',
     1            ' not be correlated to other distributions.'
               Write(99,*) List(ij),' SAME AS ', List(-ICVar(i))
               Write(6,*) 'Error: Distributions of type Same As can',
     1            ' not be correlated to other distributions.'
               Write(6,*) List(ij),' SAME AS ', List(-ICVar(i))
c******
               Err = .True.
            End If
c
            If ( JCVar(i) == -9999999 ) Then
               Print *, 'Error: Distributions of type Constant can ',
     1            'not be correlated to other distributions.'
               Print *, List(jj),' is CONSTANT'
c****** add prints to message and error files
               Write(99,*) 'Error: Distributions of type Constant can',
     1            ' not be correlated to other distributions.'
               Write(99,*) List(jj),' is CONSTANT'
               Write(6,*) 'Error: Distributions of type Constant can',
     1            ' not be correlated to other distributions.'
               Write(6,*) List(jj),' is CONSTANT'
c******
               Err = .True.
            Else If ( JCVar(i) <= 0 ) Then
               Print *, 'Error: Distributions of type Same As can ',
     1            'not be correlated to other distributions.'
               Print *, List(jj),' SAME AS ', List(-JCVar(i))
c****** add prints to message and error files
               Write(99,*) 'Error: Distributions of type Same As can',
     1            ' not be correlated to other distributions.'
               Write(99,*) List(jj),' SAME AS ', List(-JCVar(i))
               Write(6,*) 'Error: Distributions of type Same As can',
     1            ' not be correlated to other distributions.'
               Write(6,*) List(jj),' SAME AS ', List(-JCVar(i))
c******
               Err = .True.
            End If
c
         End Do
      End If
c
c     -- Stop if an error was encountered during data checking
      If (Err) Then
         Write(99,*) ' Error was encountered during data checking'
         Write(6,*) ' Error was encountered during data checking'
         KLLERR = .TRUE.
         RETURN
      Endif
c
c     -- Now check for a few more errors
c
      Call ChkZro(N,NV,IRSet)
      If(KLLERR) Return
      Call ChkDim(2,NV,NVAR,CDUM1,CDUM2)
      If(KLLERR) Return
      If (ICM == 1) then
         Call CMCRD
         If(KLLERR) Return
      Endif
ccc***End of information duplicated in LHS_PREP
c
c     -- Input has been successfully read - let's do the sampling!
c
      CLOSE(5)
      Return
c
c     -- Process all errors that occur reading parameters from the input file
c
 9000 Write (6,9005) NamVal, LCard(1:90), LCARD(91:180)
      Write (99,9005) NamVal, LCard(1:90), LCARD(91:180)
      KLLERR = .TRUE.
      RETURN
c
c     -- Format Statements
c
ccc 9001 Format (A50)                                                   SLD
 9002 Format('1',5X,'The random number generator seed value must ',
     1       'be positive.',/,5X,'The following value was found: ',I12)
 9004 FORMAT('1',5X,'The following card (possibly blank) is not a ',
     1       'valid parameter/data card.',/,6X,'Please consult the ',
     2       'user manual for the correct parameter/data card syntax.',
     3        //,3X,'***',A,A,'***')
 9005 FORMAT('1',5X,'The following parameter card did not have the ',
     1       'correct data card associated with it.',/,6X,'Please ',
     2       'consult the user manual for the correct data ',
     3       'card syntax.',/,3X,'***',A,A,'***',/,3X,'***',A,A,'***')
 9006 Format('1',5X,'The number of observations requested ',
     1            'is less than one:',I5)
 9007 Format('1',5X,'The number of repetitions requested ',
     1            'is less than one:',I5)
 9010 FORMAT('1',5X,'A maximum of ',I5,' pairs of values are allowed ',
     1       'for a cumulative continuous distribution function.',/,5X,
     2       I5,' Values were specified for the distribution with ',
     3       'the folowing card syntax:',/,3X,'***',A,'***')
 9011 FORMAT('1',5X,'A minimum of 2 pairs of values must be input ',
     1       'for a cumulative continuous distribution function.',/,5X,
     2       I5,' Values were specified for the distribution with ',
     3       'the folowing card syntax:',/,3X,'***',A,'***')
c
      End
