#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <float.h>

int main(int argc, char** argv)
{
  ifstream vars_in(argv[1]);   // asv.in stripped from params.in.#
  ifstream stress_in(argv[2]); // stress.out
  ifstream g_in(argv[3]);      // gs.out
  ofstream fout(argv[4]);      // results.out.#

  fout.precision(10);
  fout.setf(ios::scientific);
  fout.setf(ios::right);

  int i, ASV[56];
  for (i=0; i<56; i++)
    vars_in >> ASV[i];

  // read in the weight & compute the penalty
  double weight;
  //nominal_weight = 11.1442, weight_lb = .9*nominal_weight, 
  //weight_ub = 1.1*nominal_weight, penalty, penalty_factor = 100.,
  stress_in >> weight;
  if (ASV[0]==1)
    fout << weight << " f\n";

  // Read in safety margins for stress and g's and track minimum
  int num_stress_sm = 59, num_g_sm = 59;
  double sm_stress, sm_g;
  // g block ids:      7, 8, 15, 16, 18, 19, 20, 24, 25, 33, 34, 62, 65
  // g sequential ids: 7, 8, 15, 16, 18, 19, 20, 22, 23, 31, 32, 54, 57
  int g_index[13] = { 7, 8, 15, 16, 18, 19, 20, 22, 23, 31, 32, 54, 57 };
  // stress ids: everything else except 35, 36, 55, 56 (ignores)
  int stress_index[42] = { 1,  2,  3,  4,  5,  6,  9, 10, 11, 12, 13, 14, 17, 
                          21, 24, 25, 26, 27, 28, 29, 30, 33, 34, 37, 38, 39, 
                          40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
                          53, 58, 59 };
  int cntr = 0, asv_cntr = 1;
  for(i=0; i<num_stress_sm; i++) {
    stress_in >> sm_stress;
    if (i+1 == stress_index[cntr]) {
      if (ASV[asv_cntr] == 1)
        fout << -sm_stress << " stress_" << stress_index[cntr] << '\n';
      cntr++;
      asv_cntr++;
    }
    if (cntr > 41)
      break;
  }
  cntr = 0;
  for(i=0; i<num_g_sm; i++) {
    g_in >> sm_g;
    if (i+1 == g_index[cntr]) {
      if (ASV[asv_cntr] == 1)
        fout << -sm_g  << " g_" << g_index[cntr] << '\n';
      cntr++;
      asv_cntr++;
    }
    if (cntr > 12)
      break;
  }

  // Maximize the minimum safety margin.
  // For CPS:
  //double obj_fn = -min_sm + penalty;
  // For MMFD/SQP/LHS (note: LHS catalogue weight directly to RSM easier fn.?):
  //double obj_fn = -min_sm; // catalogue 2 weight constraints
  //double c1 = (weight_lb-weight)/weight_lb;
  //double c2 = (weight-weight_ub)/weight_ub;

  fout << flush;
  //delete [] sm_stress;
  //delete [] sm_g;
  return 0;
}
