/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class AllOperators.

    NOTES:

        See notes of AllOperators.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Wed Jun 04 09:20:13 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the AllOperators class.
 */



/*
================================================================================
Includes
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {








/*
================================================================================
Inline Mutators
================================================================================
*/








/*
================================================================================
Inline Accessors
================================================================================
*/








/*
================================================================================
Inline Public Methods
================================================================================
*/

inline
const GeneticAlgorithmOperatorGroup&
AllOperators::Instance(
    )
{
    return FullInstance();
}

inline
const AllOperators&
AllOperators::FullInstance(
    )
{
    static const AllOperators* instance = new AllOperators();
    return *instance;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::MutatorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::ConvergerRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::NichePressureApplicatorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::CrosserRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::FitnessAssessorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::SelectorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::InitializerRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::EvaluatorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::MainLoopRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
AllOperators::PostProcessorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}











/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA
