function display(beamelem)
%DISPLAY - displays the fields of a beam element
%
%   echo function for 'beamelem' class

disp(sprintf('\n%s = \n',inputname(1)));
disp(sprintf('   type: %s',beamelem.type));
disp(sprintf('   id: %i',beamelem.id));
disp(sprintf('   material id: %i',beamelem.matid));
disp(sprintf('   grid ids: %i %i',beamelem.g(1),beamelem.g(2)));
disp(sprintf('   thickness: %g %g',beamelem.h(1),beamelem.h(2)));
disp(sprintf('   surface: %g %g',beamelem.s(1),beamelem.s(2)));
disp(sprintf('   bedrock: %g %g',beamelem.b(1),beamelem.b(2)));
disp(sprintf('   drag coeff: %g',beamelem.k));
disp(sprintf('   onbed: %i',beamelem.onbed));
disp(sprintf('   onsurface: %i',beamelem.onsurface));
