function stress=StressCompute(m,inputs,type);
%STRESSCOMPUTE - compute the stress field
%
%   return a vector of size (numberofelements,1), holding the stress for 
%   every element.
%
%   Usage:
%      stress=StressCompute(m,inputs,type)

%global variables
global cluster gridset

%recover fem model fields
elements=m.elements;
grids=m.grids;
materials=m.materials;
loads=m.loads;
gridset=m.gridset;

%figure out active elements that will take part in the stiffness and load generation
[n1,n2]=GetNumberOfActiveElements(elements);
if strcmpi(type,'2d')

	%initialize vectors
	stress=struct('xx',[],'yy',[],'xy',[],'principalvalue1',[],'principalaxis1',[],'principalvalue2',[],'principalaxis2',[]);
	stress1=zeros((n2-n1)+1,3);
	A1=zeros((n2-n1)+1,1); Vx1=zeros((n2-n1)+1,1); Vy1=zeros((n2-n1)+1,1); Vz1=zeros((n2-n1)+1,1);
	A2=zeros((n2-n1)+1,1); Vx2=zeros((n2-n1)+1,1); Vy2=zeros((n2-n1)+1,1); Vz2=zeros((n2-n1)+1,1);

	%Go through all elements and call the stress routine, then compute eigen values and vector
	for n=n1:n2,
		if ~isempty(elements(n).element),
			stressvector=Stress(elements(n).element,grids,materials,inputs)';

			stressmatrix=[stressvector(1) stressvector(3)
				      stressvector(3)  stressvector(2)];

			%eigen values and vectors
			[directions,value]=eig(stressmatrix);

                        %Plug into global vectors
			stress1(n,:)=stressvector;
                        A1(n,1)=value(1,1); A2(n,1)=value(2,2);
                        Vx1(n,1)=directions(1,1); Vx2(n,1)=directions(1,2);
                        Vy1(n,1)=directions(2,1); Vy2(n,1)=directions(2,2);
		end
	end

	%plug results into outputs
	%NB: Matlab sorts the eigen value in increasing order, we want the reverse
	%components
	stress.xx=stress1(:,1);
	stress.yy=stress1(:,2);
	stress.xy=stress1(:,3);
	%principal axis
	stress.principalvalue2=A1;
	stress.principalaxis2=[Vx1 Vy1];
	stress.principalvalue1=A2;
	stress.principalaxis1=[Vx2 Vy2];
	%norm or effective value
	stress.effectivevalue=1/sqrt(2)*sqrt(stress.xx.^2+stress.yy.^2+2*stress.xy.^2);

else
	%initialize vectors
	stress=struct('xx',[],'yy',[],'zz',[],'xy',[],'xz',[],'yz',[],'principalvalue1',[],'principalaxis1',[],'principalvalue2',[],'principalaxis2',[],'principalvalue3',[],'principalaxis3',[]);
	stress1=zeros((n2-n1)+1,6);
	A1=zeros((n2-n1)+1,1); Vx1=zeros((n2-n1)+1,1); Vy1=zeros((n2-n1)+1,1); Vz1=zeros((n2-n1)+1,1);
	A2=zeros((n2-n1)+1,1); Vx2=zeros((n2-n1)+1,1); Vy2=zeros((n2-n1)+1,1); Vz2=zeros((n2-n1)+1,1);
	A3=zeros((n2-n1)+1,1); Vx3=zeros((n2-n1)+1,1); Vy3=zeros((n2-n1)+1,1); Vz3=zeros((n2-n1)+1,1);

	%Go through all elements and call the stress routine, then compute eigen values and vector
	for n=n1:n2,
		if ~isempty(elements(n).element),
			stressvector=Stress(elements(n).element,grids,materials,inputs)';

			stressmatrix=[stressvector(1) stressvector(4) stressvector(5)
				      stressvector(4)  stressvector(2)  stressvector(6)
				      stressvector(5)  stressvector(6)  stressvector(3)];

			%eigen values and vectors
			[directions,value]=eig(stressmatrix);

                        %Plug into global vectors
			stress1(n,:)=stressvector;
                        A1(n,1)=value(1,1); A2(n,1)=value(2,2); A3(n,1)=value(3,3);
                        Vx1(n,1)=directions(1,1); Vx2(n,1)=directions(1,2); Vx3(n,1)=directions(1,3);
                        Vy1(n,1)=directions(2,1); Vy2(n,1)=directions(2,2); Vy3(n,1)=directions(2,3);
                        Vz1(n,1)=directions(3,1); Vz2(n,1)=directions(3,2); Vz3(n,1)=directions(3,3);
		end
	end

	%plug results into outputs
	%NB: Matlab sorts the eigen value in increasing order, we want the reverse
	%components
	stress.xx=stress1(:,1);
	stress.yy=stress1(:,2);
	stress.zz=stress1(:,3);
	stress.xy=stress1(:,4);
	stress.xz=stress1(:,5);
	stress.yz=stress1(:,6);
	%principal axis
	stress.principalvalue3=A1;
	stress.principalaxis3=[Vx1 Vy1 Vz1];
	stress.principalvalue2=A2;
	stress.principalaxis2=[Vx2 Vy2 Vz2];
	stress.principalvalue1=A3;
	stress.principalaxis1=[Vx3 Vy3 Vz3];
	%norm or effective value
	stress.effectivevalue=1/sqrt(2)*sqrt(stress.xx.^2+stress.yy.^2+stress.zz.^2+2*stress.xy.^2+2*stress.xz.^2+2*stress.yz.^2);
end
