dnl @synopsis AX_CXX_HAVE_STD_DISTANCE
dnl
dnl Probes the C++ compiler to determine whether the version of the STL
dnl it uses makes std::distance() available.
dnl
dnl @author Shannon Brown <slbrow@sandia.gov>
dnl @category Cxx
dnl @license GPL2
dnl @version 2006-02-15

AC_DEFUN([AX_CXX_HAVE_STD_DISTANCE],
[AC_CACHE_CHECK(whether the C++ compiler std::distance(),
ax_cv_cxx_have_std_distance,
[AC_REQUIRE([AC_CXX_NAMESPACES])
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([#include <iterator>
#include <string>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif],[string array = "test";
int i = distance(array.begin(), array.end());],
ax_cv_cxx_have_std_distance=yes,ax_cv_cxx_have_std_distance=no)
 AC_LANG_RESTORE
])
if test "x$ax_cv_cxx_have_std_distance" = xyes; then
  AC_DEFINE([HAVE_STD_DISTANCE],[1],
	    [Define if you have an STL-conforming std::distance().])
fi
])dnl
