#include "petsc.h"
#include "petscfix.h"
/* dense.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensenhep_ EPSDENSENHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensenhep_ epsdensenhep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensegnhep_ EPSDENSEGNHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensegnhep_ epsdensegnhep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensehep_ EPSDENSEHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensehep_ epsdensehep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdenseghep_ EPSDENSEGHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdenseghep_ epsdenseghep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensehessenberg_ EPSDENSEHESSENBERG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensehessenberg_ epsdensehessenberg
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdenseschur_ EPSDENSESCHUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdenseschur_ epsdenseschur
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssortdenseschur_ EPSSORTDENSESCHUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssortdenseschur_ epssortdenseschur
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensetridiagonal_ EPSDENSETRIDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensetridiagonal_ epsdensetridiagonal
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epsdensenhep_(int *n,PetscScalar *A,PetscScalar *w,PetscScalar *wi,PetscScalar *V,PetscScalar *W, int *__ierr ){
*__ierr = EPSDenseNHEP(*n,A,w,wi,V,W);
}
void PETSC_STDCALL  epsdensegnhep_(int *n,PetscScalar *A,PetscScalar *B,PetscScalar *w,PetscScalar *wi,PetscScalar *V,PetscScalar *W, int *__ierr ){
*__ierr = EPSDenseGNHEP(*n,A,B,w,wi,V,W);
}
void PETSC_STDCALL  epsdensehep_(int *n,PetscScalar *A,int *lda,PetscReal *w,PetscScalar *V, int *__ierr ){
*__ierr = EPSDenseHEP(*n,A,*lda,w,V);
}
void PETSC_STDCALL  epsdenseghep_(int *n,PetscScalar *A,PetscScalar *B,PetscReal *w,PetscScalar *V, int *__ierr ){
*__ierr = EPSDenseGHEP(*n,A,B,w,V);
}
void PETSC_STDCALL  epsdensehessenberg_(int *n,int *k,PetscScalar *A,int *lda,PetscScalar *Q, int *__ierr ){
*__ierr = EPSDenseHessenberg(*n,*k,A,*lda,Q);
}
void PETSC_STDCALL  epsdenseschur_(int *n,int *k,PetscScalar *H,int *ldh,PetscScalar *Z,PetscScalar *wr,PetscScalar *wi, int *__ierr ){
*__ierr = EPSDenseSchur(*n,*k,H,*ldh,Z,wr,wi);
}
void PETSC_STDCALL  epssortdenseschur_(int *n,int *k,PetscScalar *T,int *ldt,PetscScalar *Z,PetscScalar *wr,PetscScalar *wi,EPSWhich *which, int *__ierr ){
*__ierr = EPSSortDenseSchur(*n,*k,T,*ldt,Z,wr,wi,*which);
}
void PETSC_STDCALL  epsdensetridiagonal_(int *n,PetscScalar *A,int *lda,PetscReal *w,PetscScalar *V, int *__ierr ){
*__ierr = EPSDenseTridiagonal(*n,A,*lda,w,V);
}
#if defined(__cplusplus)
}
#endif
