function plot_basaldrag(md,options_structure,width,i);
%PLOT_BASALDRAG - plot basal drag
%
%   Usage:
%      plot_basaldrag(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%check layer
if strcmpi(md.type,'3d')
	if options_structure.layer~=1,
		disp('plot_basaldrag warning: basal drag is displayed in the lower layer')
		options_structure.layer=1;
	end
end

%compute exponents
s=averaging(md,1./md.p,0);
r=averaging(md,md.p./md.q,0);

%compute horizontal velocity
ub=sqrt(md.vx.^2+md.vy.^2)/md.yts;

%compute basal drag
drag=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag).^2.*ub.^s/1000;

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[basal_drag isongrid]=processdata(md,drag,options_structure);

%plot mesh quivervel
subplot(width,width,i); 

%edgecolor?
if ~isnan(options_structure.edgecolor),
	edgecolor=options_structure.edgecolor;
else
	edgecolor='none';
end

%plot basal basal drag
A=elements(:,1); B=elements(:,2); C=elements(:,3);

patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData',basal_drag,'FaceColor','interp','EdgeColor',edgecolor);

%apply options
if isnan(options_structure.title)
	options_structure.title='Basal drag [kPa]';
end 
options_structure.view=2;
applyoptions(md,basal_drag,options_structure);
