function J=GetJacobian(triaelem,xyz_list,gauss_l1l2l3)
%GETJACOBIAN - computes the jacobian for a triaelem
%
%   Usage:
%      J=GetJacobian(triaelem,xyz_list,gauss_coord)
%
%   See also GETJACOBIANDETERMINANT, GETJACOBIANINVERT

%The Jacobian is constant over the element, discard the gaussian points. 

%Non optimized version 
%J=zeros(2,2);
%	
%x1=xyz_list(1,1);
%y1=xyz_list(1,2);
%x2=xyz_list(2,1);
%y2=xyz_list(2,2);
%x3=xyz_list(3,1);
%y3=xyz_list(3,2);
%
%J(1,1)=1.0/2.0*(x2-x1);
%J(1,2)=sqrt(3.0)/6.0*(2*x3-x1-x2);
%J(2,1)=1.0/2.0*(y2-y1);
%J(2,2)=sqrt(3.0)/6.0*(2*y3-y1-y2);


%Same code, a little optimized
J=[	  1.0/2.0*(xyz_list(2,1)-xyz_list(1,1))	sqrt(3.0)/6.0*(2*xyz_list(3,1)-xyz_list(1,1)-xyz_list(2,1))
	  1.0/2.0*(xyz_list(2,2)-xyz_list(1,2))	sqrt(3.0)/6.0*(2*xyz_list(3,2)-xyz_list(1,2)-xyz_list(2,2))];


